/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0430\u0440\u0430\u043f";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d\u0438";
        final String metaValue_ko = "\u043a\u043e\u0440\u0435\u0439";
        final Object[][] data = new Object[][] {
            { "001", "\u0442\u04d7\u043d\u0447\u0435" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "005", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438" },
            { "011", "\u0410\u043d\u04d1\u04ab \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "013", "\u0422\u04d7\u043f \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "014", "\u0425\u04d7\u0432\u0435\u043b\u0442\u0443\u0445\u04d1\u04ab \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "017", "\u0422\u04d7\u043f \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "018", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "021", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0441\u0435\u043c" },
            { "030", "\u0425\u04d7\u0432\u0435\u043b\u0442\u0443\u0445\u04d1\u04ab \u0410\u0437\u0438" },
            { "034", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0410\u0437\u0438" },
            { "035", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0445\u04d7\u0432\u0435\u043b\u0442\u0443\u0445\u04d1\u04ab \u0410\u0437\u0438" },
            { "039", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "142", "\u0410\u0437\u0438" },
            { "143", "\u0422\u04d7\u043f \u0410\u0437\u0438" },
            { "145", "\u0410\u043d\u04d1\u04ab \u0410\u0437\u0438" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0425\u04d7\u0432\u0435\u043b\u0442\u0443\u0445\u04d1\u04ab \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "155", "\u0410\u043d\u04d1\u04ab \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "202", "\u0422\u0440\u043e\u043f\u0438\u043a \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u043b\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "AC", "\u0412\u043e\u0437\u043d\u0435\u0441\u0435\u043d\u0438 \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0410\u0440\u0430\u043f\u0441\u0435\u043d \u041f\u04d7\u0440\u043b\u0435\u0448\u04f3\u043b\u043b\u04d7 \u042d\u043c\u0438\u0440\u0430\u0447\u04d7" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0442\u0430\u0442\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0438" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0438 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u043f\u0435 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439-\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "BQ", "\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0442\u0430\u0442\u0430 \u0421\u0430\u0431\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438" },
            { "BS", "\u041f\u0430\u0445\u0430\u043c \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u04ab" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e - \u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0422\u04d7\u043f \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0438" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0438\u0442\u0430\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0420\u0430\u0448\u0442\u0430\u0432 \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0438" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e-\u0413\u0430\u0440\u0441\u0438\u044f" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0438" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0442\u0430\u0442\u0430 \u041c\u0435\u043b\u0438\u043b\u044c\u044f" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0410\u043d\u04d1\u04ab \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u0439" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0430 \u043f\u04d7\u0440\u043b\u0435\u0448\u04d7\u0432\u04d7" },
            { "EZ", "\u0415\u0432\u0440\u043e\u0437\u043e\u043d" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0410\u0441\u043b\u04d1 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0438 \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u043b\u04d1 \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438" },
            { "GS", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0413\u0435\u043e\u0440\u0433\u0438 \u0442\u0430\u0442\u0430 \u0421\u0430\u043d\u0434\u0432\u0438\u0447\u0435\u0432 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0421\u0410\u0420)" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0442\u0430\u0442\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "IN", "\u0418\u043d\u0434\u0438" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0437\u0438" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0442\u0430\u0442\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u041a\u0425\u0414\u0420" },
            { "KR", "\u041a\u043e\u0440\u0435\u0439 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0438" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "MK", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u0421\u0410\u0420)" },
            { "MP", "\u04aa\u0443\u0440\u04ab\u04d7\u0440 \u041c\u0430\u0440\u0438\u0430\u043d \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0441\u0435\u043c" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "NC", "\u04aa\u04d7\u043d\u04d7 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u04aa\u04d7\u043d\u04d7 \u0417\u0435\u043b\u0430\u043d\u0434\u0438" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0438 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u2014 \u04aa\u04d7\u043d\u04d7 \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0441\u0435\u043c" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 & \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u04d1\u043d \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\u04d7\u0441\u0435\u043c" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "QO", "\u0422\u0443\u043b\u0430\u0448 \u041e\u043a\u0435\u0430\u043d\u0438" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "RU", "\u0420\u0430\u04ab\u04ab\u0435\u0439" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434 \u0410\u0440\u0430\u0432\u0438\u0439\u04d7" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u04d1\u0432\u0430\u043f\u043b\u04d1 \u0415\u043b\u0435\u043d\u0430 \u0443\u0442\u0440\u0430\u0432\u04d7" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0442\u0430\u0442\u0430 \u042f\u043d-\u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0442\u0430\u0442\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438" },
            { "SZ", "\u042d\u0441\u0432\u0430\u0442\u0438\u043d\u0438" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044c\u044f" },
            { "TC", "\u0422\u0451\u0440\u043a\u0441 \u0442\u0430\u0442\u0430 \u041a\u0430\u0439\u043a\u043e\u0441 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0438 \u041a\u04d1\u043d\u0442\u04d1\u0440 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\u04d7\u0441\u0435\u043c" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0425\u04d7\u0432\u0435\u043b\u0442\u0443\u0445\u04d1\u04ab \u0422\u0438\u043c\u043e\u0440" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0446\u0438" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0442\u0430\u0442\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0422\u0443\u043b\u0430\u0448\u04d7\u043d\u0447\u0438 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c (\u0410\u041f\u0428)" },
            { "UN", "\u041f\u04d7\u0440\u043b\u0435\u0448\u04f3\u043b\u043b\u04d7 \u041d\u0430\u0446\u0438\u0441\u0435\u043d \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439\u04d7" },
            { "US", "\u041f\u04d7\u0440\u043b\u0435\u0448\u04d7\u043d\u043d\u04d7 \u0428\u0442\u0430\u0442\u0441\u0435\u043c" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0442\u0430\u0442\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u044b" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u0412\u0438\u0440\u0433\u0438\u043d\u0438 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c" },
            { "VI", "\u0412\u0438\u0440\u0433\u0438\u043d\u0438 \u0443\u0442\u0440\u0430\u0432\u04d7\u0441\u0435\u043c (\u0410\u041f\u0428)" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0442\u0430\u0442\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XA", "\u043f\u0441\u0435\u0432\u0434\u0430\u043a\u0446\u0435\u043d\u0442\u0441\u0435\u043c" },
            { "XB", "\u043f\u0441\u0435\u0432\u0434-Bidi" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u041a\u04d1\u043d\u0442\u04d1\u0440 \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0438" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u043f\u0430\u043b\u043b\u04d1 \u043c\u0430\u0440 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "ar", metaValue_ar },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b" },
            { "cv", "\u0447\u04d1\u0432\u0430\u0448" },
            { "de", "\u043d\u0438\u043c\u04d7\u04ab" },
            { "en", "\u0430\u043a\u04d1\u043b\u0447\u0430\u043d" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0438" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0438" },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "it", "\u0438\u0442\u0430\u043b\u0438" },
            { "ja", metaValue_ja },
            { "ko", metaValue_ko },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u0438" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "ru", "\u0432\u044b\u0440\u04d1\u0441" },
            { "th", "\u0442\u0430\u0439" },
            { "tr", "\u0442\u0443\u0440\u043a\u043a\u04d1" },
            { "zh", "\u043a\u0438\u0442\u0430\u0439" },
            { "und", "\u043f\u0430\u043b\u043b\u04d1 \u043c\u0430\u0440 \u0447\u04d7\u043b\u0445\u0435" },
            { "Arab", metaValue_ar },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430" },
            { "Hans", "\u04ab\u04d1\u043c\u04d1\u043b\u043b\u0430\u0442\u043d\u04d1\u043d \u043a\u0438\u0442\u0430\u0439" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043b\u043b\u04d7\u043d \u043a\u0438\u0442\u0430\u0439" },
            { "Jpan", metaValue_ja },
            { "Kore", metaValue_ko },
            { "Latn", "\u043b\u0430\u0442\u0438\u043d" },
            { "Zxxx", "\u04ab\u044b\u0440\u0443\u0441\u04d1\u0440" },
            { "Zzzz", "\u043f\u0430\u043b\u043b\u04d1 \u043c\u0430\u0440 \u04ab\u044b\u0440\u0443\u043b\u0430\u0445" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u043d \u043d\u0438\u043c\u04d7\u04ab" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u043d\u0438\u043c\u04d7\u04ab" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u043d \u0430\u043a\u04d1\u043b\u0447\u0430\u043d" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u04d1\u043d \u0430\u043a\u04d1\u043b\u0447\u0430\u043d" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u0430\u043a\u04d1\u043b\u0447\u0430\u043d" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u04d1\u043d \u0430\u043a\u04d1\u043b\u0447\u0430\u043d" },
            { "es_ES", "\u0435\u0432\u0440\u043e\u043f\u04d1\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u04d1\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u04d1\u043d \u0444\u0440\u0430\u043d\u0446\u0438" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u04d7\u043d \u0444\u0440\u0430\u043d\u0446\u0438" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0438" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u0438\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "pt_PT", "\u0435\u0432\u0440\u043e\u043f\u04d1\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "ar_001", "\u0430\u0440\u0430\u043f \u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u0438" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u043b\u0430 \u0430\u043c\u0435\u0440\u0438\u043a\u04d1\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "zh_Hans", "\u043a\u0438\u0442\u0430\u0439, \u04ab\u04d1\u043c\u04d1\u043b\u043b\u0430\u0442\u043d\u04d1 \u04ab\u044b\u0440\u0443" },
            { "zh_Hant", "\u043a\u0438\u0442\u0430\u0439, \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043b\u043b\u04d7 \u04ab\u044b\u0440\u0443" },
            { "type.nu.latn", "\u0445\u0430\u043b\u044c\u0445\u0438 \u0430\u0440\u0430\u0431 \u0446\u0438\u0444\u0440\u0438\u0441\u0435\u043c" },
            { "type.ca.iso8601", "\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u04d7 ISO-8601" },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043b\u04d1 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430" },
            { "type.ca.gregorian", "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0430\u043d \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u04d7" },
        };
        return data;
    }
}
