/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.ResourceManager;
import com.sun.naming.internal.VersionHelper;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.function.Predicate;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;

public class NamingManagerHelper {
    private static final String DEFAULT_PKG_PREFIX = "com.sun.jndi.url";
    static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static ObjectFactoryBuilder object_factory_builder = null;

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Predicate<Class<?>> predicate) throws Exception {
        Object object2;
        ObjectFactoryBuilder objectFactoryBuilder = NamingManagerHelper.getObjectFactoryBuilder();
        if (objectFactoryBuilder != null) {
            ObjectFactory objectFactory = objectFactoryBuilder.createObjectFactory(object, hashtable);
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null) {
            String string = reference.getFactoryClassName();
            if (string != null) {
                ObjectFactory objectFactory = NamingManagerHelper.getObjectFactoryFromReference(reference, string, predicate);
                if (objectFactory != null) {
                    return objectFactory.getObjectInstance(reference, name, context, hashtable);
                }
                return object;
            }
            object2 = NamingManagerHelper.processURLAddrs(reference, name, context, hashtable);
            if (object2 != null) {
                return object2;
            }
        }
        return (object2 = NamingManagerHelper.createObjectFromFactories(object, name, context, hashtable)) != null ? object2 : object;
    }

    public static Object getDirObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes, Predicate<Class<?>> predicate) throws Exception {
        Object object2;
        ObjectFactoryBuilder objectFactoryBuilder = NamingManagerHelper.getObjectFactoryBuilder();
        if (objectFactoryBuilder != null) {
            ObjectFactory objectFactory = objectFactoryBuilder.createObjectFactory(object, hashtable);
            if (objectFactory instanceof DirObjectFactory) {
                return ((DirObjectFactory)objectFactory).getObjectInstance(object, name, context, hashtable, attributes);
            }
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null) {
            String string = reference.getFactoryClassName();
            if (string != null) {
                ObjectFactory objectFactory = NamingManagerHelper.getObjectFactoryFromReference(reference, string, predicate);
                if (objectFactory instanceof DirObjectFactory) {
                    return ((DirObjectFactory)objectFactory).getObjectInstance(reference, name, context, hashtable, attributes);
                }
                if (objectFactory != null) {
                    return objectFactory.getObjectInstance(reference, name, context, hashtable);
                }
                return object;
            }
            object2 = NamingManagerHelper.processURLAddrs(reference, name, context, hashtable);
            if (object2 != null) {
                return object2;
            }
        }
        return (object2 = NamingManagerHelper.createObjectFromFactories(object, name, context, hashtable, attributes)) != null ? object2 : object;
    }

    static ObjectFactory getObjectFactoryFromReference(Reference reference, String string, Predicate<Class<?>> predicate) throws IllegalAccessException, InstantiationException, MalformedURLException {
        String string2;
        Class<?> clazz = null;
        try {
            clazz = helper.loadClassWithoutInit(string);
            if (!predicate.test(clazz)) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && (string2 = reference.getFactoryClassLocation()) != null) {
            try {
                clazz = helper.loadClass(string, string2);
                if (clazz == null || !predicate.test(clazz)) {
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        ObjectFactory objectFactory = clazz != null ? (ObjectFactory)clazz.newInstance() : null;
        return objectFactory;
    }

    private static Object createObjectFromFactories(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws Exception {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.object", hashtable, context);
        if (factoryEnumeration == null) {
            return null;
        }
        Object object2 = null;
        while (object2 == null && factoryEnumeration.hasMore()) {
            ObjectFactory objectFactory = (ObjectFactory)factoryEnumeration.next();
            if (objectFactory instanceof DirObjectFactory) {
                object2 = ((DirObjectFactory)objectFactory).getObjectInstance(object, name, context, hashtable, attributes);
                continue;
            }
            object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        return object2;
    }

    static Object processURLAddrs(Reference reference, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        for (int i = 0; i < reference.size(); ++i) {
            String string;
            Object object;
            RefAddr refAddr = reference.get(i);
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equalsIgnoreCase("URL") || (object = NamingManagerHelper.processURL(string = (String)refAddr.getContent(), name, context, hashtable)) == null) continue;
            return object;
        }
        return null;
    }

    private static Object processURL(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        Object object2;
        String[] stringArray;
        String string;
        if (object instanceof String && (string = NamingManagerHelper.getURLScheme((String)(stringArray = (String[])object))) != null && (object2 = NamingManagerHelper.getURLObject(string, object, name, context, hashtable)) != null) {
            return object2;
        }
        if (object instanceof String[]) {
            stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = NamingManagerHelper.getURLScheme(stringArray[i]);
                if (string2 == null || (object2 = NamingManagerHelper.getURLObject(string2, object, name, context, hashtable)) == null) continue;
                return object2;
            }
        }
        return null;
    }

    private static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return null;
    }

    private static Object getURLObject(String string, Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        ObjectFactory objectFactory = (ObjectFactory)ResourceManager.getFactory("java.naming.factory.url.pkgs", hashtable, context, "." + string + "." + string + "URLContextFactory", DEFAULT_PKG_PREFIX);
        if (objectFactory == null) {
            return null;
        }
        try {
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static Object createObjectFromFactories(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.object", hashtable, context);
        if (factoryEnumeration == null) {
            return null;
        }
        Object object2 = null;
        while (object2 == null && factoryEnumeration.hasMore()) {
            ObjectFactory objectFactory = (ObjectFactory)factoryEnumeration.next();
            object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        return object2;
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws NamingException {
        if (object_factory_builder != null) {
            throw new IllegalStateException("ObjectFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        object_factory_builder = objectFactoryBuilder;
    }

    public static synchronized ObjectFactoryBuilder getObjectFactoryBuilder() {
        return object_factory_builder;
    }
}

