/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;

public final class DisplayMode {
    private Dimension size;
    private int bitDepth;
    private int refreshRate;
    public static final int BIT_DEPTH_MULTI = -1;
    public static final int REFRESH_RATE_UNKNOWN = 0;

    public DisplayMode(int n, int n2, int n3, int n4) {
        this.size = new Dimension(n, n2);
        this.bitDepth = n3;
        this.refreshRate = n4;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public boolean equals(DisplayMode displayMode) {
        if (displayMode == null) {
            return false;
        }
        return this.getHeight() == displayMode.getHeight() && this.getWidth() == displayMode.getWidth() && this.getBitDepth() == displayMode.getBitDepth() && this.getRefreshRate() == displayMode.getRefreshRate();
    }

    public boolean equals(Object object) {
        if (object instanceof DisplayMode) {
            return this.equals((DisplayMode)object);
        }
        return false;
    }

    public int hashCode() {
        return this.getWidth() + this.getHeight() + this.getBitDepth() * 7 + this.getRefreshRate() * 13;
    }

    public String toString() {
        return this.getWidth() + "x" + this.getHeight() + "x" + (this.getBitDepth() > 0 ? this.getBitDepth() + "bpp" : "[Multi depth]") + "@" + (this.getRefreshRate() > 0 ? this.getRefreshRate() + "Hz" : "[Unknown refresh rate]");
    }
}

