/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.HostPortrange;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class URLPermission
extends Permission {
    private static final long serialVersionUID = -2702463814894478682L;
    private transient String scheme;
    private transient String ssp;
    private transient String path;
    private transient List<String> methods;
    private transient List<String> requestHeaders;
    private transient Authority authority;
    private String actions;

    public URLPermission(String string, String string2) {
        super(string);
        this.init(string2);
    }

    private void init(String string) {
        String string2;
        String string3;
        this.parseURI(this.getName());
        int n = string.indexOf(58);
        if (string.lastIndexOf(58) != n) {
            throw new IllegalArgumentException("Invalid actions string: \"" + string + "\"");
        }
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        List<String> list = this.normalizeMethods(string3);
        Collections.sort(list);
        this.methods = Collections.unmodifiableList(list);
        list = this.normalizeHeaders(string2);
        Collections.sort(list);
        this.requestHeaders = Collections.unmodifiableList(list);
        this.actions = this.actions();
    }

    public URLPermission(String string) {
        this(string, "*:*");
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof URLPermission)) {
            return false;
        }
        URLPermission uRLPermission = (URLPermission)permission;
        if (!this.methods.get(0).equals("*") && Collections.indexOfSubList(this.methods, uRLPermission.methods) == -1) {
            return false;
        }
        if (this.requestHeaders.isEmpty() && !uRLPermission.requestHeaders.isEmpty()) {
            return false;
        }
        if (!this.requestHeaders.isEmpty() && !this.requestHeaders.get(0).equals("*") && Collections.indexOfSubList(this.requestHeaders, uRLPermission.requestHeaders) == -1) {
            return false;
        }
        if (!this.scheme.equals(uRLPermission.scheme)) {
            return false;
        }
        if (this.ssp.equals("*")) {
            return true;
        }
        if (!this.authority.implies(uRLPermission.authority)) {
            return false;
        }
        if (this.path == null) {
            return uRLPermission.path == null;
        }
        if (uRLPermission.path == null) {
            return false;
        }
        if (this.path.endsWith("/-")) {
            String string = this.path.substring(0, this.path.length() - 1);
            return uRLPermission.path.startsWith(string);
        }
        if (this.path.endsWith("/*")) {
            String string = this.path.substring(0, this.path.length() - 1);
            if (!uRLPermission.path.startsWith(string)) {
                return false;
            }
            String string2 = uRLPermission.path.substring(string.length());
            if (string2.indexOf(47) != -1) {
                return false;
            }
            return !string2.equals("-");
        }
        return this.path.equals(uRLPermission.path);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof URLPermission)) {
            return false;
        }
        URLPermission uRLPermission = (URLPermission)object;
        if (!this.scheme.equals(uRLPermission.scheme)) {
            return false;
        }
        if (!this.getActions().equals(uRLPermission.getActions())) {
            return false;
        }
        if (!this.authority.equals(uRLPermission.authority)) {
            return false;
        }
        if (this.path != null) {
            return this.path.equals(uRLPermission.path);
        }
        return uRLPermission.path == null;
    }

    @Override
    public int hashCode() {
        return this.getActions().hashCode() + this.scheme.hashCode() + this.authority.hashCode() + (this.path == null ? 0 : this.path.hashCode());
    }

    private List<String> normalizeMethods(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                String string2 = stringBuilder.toString();
                if (!string2.isEmpty()) {
                    arrayList.add(string2);
                }
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c == ' ' || c == '\t') {
                throw new IllegalArgumentException("White space not allowed in methods: \"" + string + "\"");
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            stringBuilder.append(c);
        }
        String string3 = stringBuilder.toString();
        if (!string3.isEmpty()) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private List<String> normalizeHeaders(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z') {
                if (bl) {
                    c = (char)(c - 32);
                    bl = false;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == ' ' || c == '\t') {
                throw new IllegalArgumentException("White space not allowed in headers: \"" + string + "\"");
            }
            if (c == '-') {
                bl = true;
                stringBuilder.append(c);
                continue;
            }
            if (c == ',') {
                String string2 = stringBuilder.toString();
                if (!string2.isEmpty()) {
                    arrayList.add(string2);
                }
                stringBuilder = new StringBuilder();
                bl = true;
                continue;
            }
            bl = false;
            stringBuilder.append(c);
        }
        String string3 = stringBuilder.toString();
        if (!string3.isEmpty()) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void parseURI(String string) {
        String string2;
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 == -1 || n2 + 1 == n) {
            throw new IllegalArgumentException("Invalid URL string: \"" + string + "\"");
        }
        this.scheme = string.substring(0, n2).toLowerCase(Locale.ROOT);
        this.ssp = string.substring(n2 + 1);
        if (!this.ssp.startsWith("//")) {
            if (!this.ssp.equals("*")) {
                throw new IllegalArgumentException("Invalid URL string: \"" + string + "\"");
            }
            this.authority = new Authority(this.scheme, "*");
            return;
        }
        String string3 = this.ssp.substring(2);
        n2 = string3.indexOf(47);
        if (n2 == -1) {
            this.path = "";
            string2 = string3;
        } else {
            string2 = string3.substring(0, n2);
            this.path = string3.substring(n2);
        }
        this.authority = new Authority(this.scheme, string2.toLowerCase(Locale.ROOT));
    }

    private String actions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.methods) {
            stringBuilder.append(string);
        }
        stringBuilder.append(":");
        for (String string : this.requestHeaders) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("actions", null);
        this.init(string);
    }

    static class Authority {
        HostPortrange p;

        Authority(String string, String string2) {
            int n = string2.indexOf(64);
            this.p = n == -1 ? new HostPortrange(string, string2) : new HostPortrange(string, string2.substring(n + 1));
        }

        boolean implies(Authority authority) {
            return this.impliesHostrange(authority) && this.impliesPortrange(authority);
        }

        private boolean impliesHostrange(Authority authority) {
            String string = this.p.hostname();
            String string2 = authority.p.hostname();
            if (this.p.wildcard() && string.equals("")) {
                return true;
            }
            if (authority.p.wildcard() && string2.equals("")) {
                return false;
            }
            if (string.equals(string2)) {
                return true;
            }
            if (this.p.wildcard()) {
                return string2.endsWith(string);
            }
            return false;
        }

        private boolean impliesPortrange(Authority authority) {
            int[] nArray = this.p.portrange();
            int[] nArray2 = authority.p.portrange();
            if (nArray[0] == -1) {
                return true;
            }
            return nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1];
        }

        boolean equals(Authority authority) {
            return this.p.equals(authority.p);
        }

        public int hashCode() {
            return this.p.hashCode();
        }
    }
}

