/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private String prompt;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String string, String[] stringArray, int n, boolean bl) {
        stringArray = stringArray == null || stringArray.length == 0 ? stringArray : (String[])stringArray.clone();
        String string2 = ChoiceCallback.doSanityCheck(string, stringArray, n, bl);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        this.prompt = string;
        this.defaultChoice = n;
        this.multipleSelectionsAllowed = bl;
        this.choices = stringArray;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int n) {
        this.selections = new int[1];
        this.selections[0] = n;
    }

    public void setSelectedIndexes(int[] nArray) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = nArray == null || nArray.length == 0 ? nArray : (int[])nArray.clone();
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.choices = this.choices == null || this.choices.length == 0 ? this.choices : (String[])this.choices.clone();
        String string = ChoiceCallback.doSanityCheck(this.prompt, this.choices, this.defaultChoice, this.multipleSelectionsAllowed);
        if (string != null) {
            throw new InvalidObjectException(string);
        }
        int[] nArray = this.selections = this.selections == null || this.selections.length == 0 ? this.selections : (int[])this.selections.clone();
        if (this.selections != null && this.selections.length > 1 && !this.multipleSelectionsAllowed) {
            throw new InvalidObjectException("Multiple selections not allowed");
        }
    }

    private static String doSanityCheck(String string, String[] stringArray, int n, boolean bl) {
        if (string == null || string.isEmpty() || stringArray == null || stringArray.length == 0 || n < 0 || n >= stringArray.length) {
            return "Missing/invalid prompt/choices";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && !stringArray[i].isEmpty()) continue;
            return "Null/empty choices value";
        }
        return null;
    }
}

