/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;

public class XbmImageDecoder
extends ImageDecoder {
    private static byte[] XbmColormap = new byte[]{-1, -1, -1, 0, 0, 0};
    private static int XbmHints = 30;
    private static final int MAX_XBM_SIZE = 16384;
    private static final int HEADER_SCAN_LIMIT = 100;

    public XbmImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
        if (!(this.input instanceof BufferedInputStream)) {
            this.input = new BufferedInputStream(this.input, 80);
        }
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    @Override
    public void produceImage() throws IOException, ImageFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = null;
        IndexColorModel indexColorModel = null;
        String string = "(0[xX])?[0-9a-fA-F]+[\\s+]?[,|};]";
        String string2 = "(0[xX])|,|[\\s+]|[};]";
        int n7 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.input));){
            Object object;
            String string3;
            while (!this.aborted && (string3 = bufferedReader.readLine()) != null && n7 <= 100) {
                ++n7;
                if (string3.trim().startsWith("#define")) {
                    object = string3.split("\\s+");
                    if (((String[])object).length != 3) {
                        XbmImageDecoder.error("Error while parsing define statement");
                    }
                    try {
                        if (!((String)object[2]).trim().isEmpty() && n6 == 0) {
                            n2 = Integer.parseInt((String)object[2]);
                            n6 = 1;
                        } else if (!((String)object[2]).trim().isEmpty() && n6 == 1) {
                            n = Integer.parseInt((String)object[2]);
                            n6 = 2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        XbmImageDecoder.error("Error while parsing width or height.");
                    }
                }
                if (n6 != 2) continue;
                if (n2 <= 0 || n <= 0) {
                    XbmImageDecoder.error("Invalid values for width or height.");
                }
                if (Math.multiplyExact(n2, n) > 16384) {
                    XbmImageDecoder.error("Large XBM file size. Maximum allowed size: 16384");
                }
                indexColorModel = new IndexColorModel(8, 2, XbmColormap, 0, false, 0);
                this.setDimensions(n2, n);
                this.setColorModel(indexColorModel);
                this.setHints(XbmHints);
                this.headerComplete();
                byArray = new byte[n2];
                n6 = 3;
                break;
            }
            if (n6 != 3) {
                XbmImageDecoder.error("Width or Height of XBM file not defined");
            }
            while (!this.aborted && (string3 = bufferedReader.readLine()) != null) {
                ++n7;
                if (!string3.contains("[]")) continue;
                object = Pattern.compile(string).matcher(string3);
                while (((Matcher)object).find()) {
                    int n8;
                    int n9;
                    int n10;
                    String string4;
                    if (n4 >= n) {
                        XbmImageDecoder.error("Scan size of XBM file exceeds the defined width x height");
                    }
                    if (!(string4 = string3.substring(n10 = ((Matcher)object).start(), n9 = ((Matcher)object).end())).startsWith("0x") && !string4.startsWith("0X")) {
                        XbmImageDecoder.error("Invalid hexadecimal number at Ln#:" + n7 + " Col#:" + (n10 + 1));
                    }
                    if ((string4 = string4.replaceAll(string2, "")).length() != 2) {
                        XbmImageDecoder.error("Invalid hexadecimal number at Ln#:" + n7 + " Col#:" + (n10 + 1));
                    }
                    try {
                        n5 = Integer.parseInt(string4, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        XbmImageDecoder.error("Error parsing hexadecimal at Ln#:" + n7 + " Col#:" + (n10 + 1));
                    }
                    for (n8 = 1; n8 <= 128; n8 <<= 1) {
                        if (n3 < n2) {
                            byArray[n3] = (n5 & n8) != 0 ? (byte)1 : 0;
                        }
                        ++n3;
                    }
                    if (n3 < n2) continue;
                    n8 = this.setPixels(0, n4, n2, 1, (ColorModel)indexColorModel, byArray, 0, n2);
                    if (n8 <= 0) {
                        XbmImageDecoder.error("Unexpected error occurred during setPixel()");
                    }
                    n3 = 0;
                    ++n4;
                }
            }
            this.imageComplete(3, true);
        }
    }
}

