/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.screencast;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import sun.awt.screencast.ScreencastHelper;
import sun.awt.screencast.TokenItem;
import sun.awt.screencast.XdgDesktopPortal;

final class TokenStorage {
    private static final String REL_NAME = ".java/robot/screencast-tokens.properties";
    private static final String REL_NAME_SECONDARY = ".awt/robot/screencast-tokens.properties";
    private static final String REL_RD_NAME = ".java/robot/remote-desktop-tokens.properties";
    private static final Properties PROPS = new Properties();
    private static final Path PROPS_PATH;
    private static final Path PROP_FILENAME;
    private static WatchService watchService;

    private TokenStorage() {
    }

    private static void doPrivilegedRunnable(Runnable runnable) {
        AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path setupPath() {
        Cloneable cloneable;
        boolean bl;
        Path path;
        Path path2;
        block21: {
            String string = System.getProperty("user.home", null);
            if (string == null) {
                return null;
            }
            path2 = null;
            if (XdgDesktopPortal.isRemoteDesktop()) {
                path = Paths.get(string, REL_RD_NAME);
            } else {
                path = Paths.get(string, REL_NAME);
                path2 = Paths.get(string, REL_NAME_SECONDARY);
            }
            bl = !Files.isWritable(path) && path2 != null && Files.isWritable(path2);
            Path path3 = path.getParent();
            if (!Files.isWritable(path)) {
                if (!Files.exists(path3, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path3, new FileAttribute[0]);
                    }
                    catch (Exception exception) {
                        if (ScreencastHelper.SCREENCAST_DEBUG) {
                            System.err.printf("Token storage: cannot create directory %s %s\n", path3, exception);
                        }
                        return null;
                    }
                }
                if (!Files.isWritable(path3)) {
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.err.printf("Token storage: %s is not writable\n", path3);
                    }
                    return null;
                }
            }
            try {
                cloneable = new HashSet<PosixFilePermission>();
                cloneable.add(PosixFilePermission.OWNER_READ);
                cloneable.add(PosixFilePermission.OWNER_WRITE);
                cloneable.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(path3, (Set<PosixFilePermission>)((Object)cloneable));
            }
            catch (IOException iOException) {
                if (!ScreencastHelper.SCREENCAST_DEBUG) break block21;
                System.err.printf("Token storage: cannot set permissions for directory %s %s\n", path3, iOException);
            }
        }
        if (bl) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("Token storage: copying from the secondary location " + path2);
            }
            cloneable = PROPS;
            synchronized (cloneable) {
                if (TokenStorage.readTokens(path2)) {
                    TokenStorage.store(path, "copy from the secondary location");
                }
            }
        } else if (Files.exists(path, new LinkOption[0])) {
            if (!TokenStorage.setFilePermission(path)) {
                return null;
            }
            TokenStorage.readTokens(path);
        }
        return path;
    }

    private static boolean setFilePermission(Path path) {
        try {
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
            hashSet.add(PosixFilePermission.OWNER_READ);
            hashSet.add(PosixFilePermission.OWNER_WRITE);
            Files.setPosixFilePermissions(path, hashSet);
            return true;
        }
        catch (IOException iOException) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: failed to set property file permission %s %s\n", path, iOException);
            }
            return false;
        }
    }

    private static void setupWatch() {
        TokenStorage.doPrivilegedRunnable(() -> {
            block2: {
                try {
                    watchService = FileSystems.getDefault().newWatchService();
                    PROPS_PATH.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (Exception exception) {
                    if (!ScreencastHelper.SCREENCAST_DEBUG) break block2;
                    System.err.printf("Token storage: failed to setup file watch %s\n", exception);
                }
            }
        });
        if (watchService != null) {
            new WatcherThread(watchService).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeTokenFromNative(String string, String string2, int[] nArray) {
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.printf("// storeToken old: |%s| new |%s| allowed bounds %s\n", string, string2, Arrays.toString(nArray));
        }
        if (nArray == null) {
            return;
        }
        TokenItem tokenItem = new TokenItem(string2, nArray);
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.printf("// Storing TokenItem:\n%s\n", tokenItem);
        }
        Properties properties = PROPS;
        synchronized (properties) {
            String string3 = PROPS.getProperty(tokenItem.token, null);
            String string4 = tokenItem.dump();
            boolean bl = false;
            if (string3 == null || !string3.equals(string4)) {
                PROPS.setProperty(tokenItem.token, string4);
                if (ScreencastHelper.SCREENCAST_DEBUG) {
                    System.out.printf("// Writing new TokenItem:\n%s\n", tokenItem);
                }
                bl = true;
            }
            if (string != null && !string.equals(string2)) {
                if (ScreencastHelper.SCREENCAST_DEBUG) {
                    System.out.printf("// storeTokenFromNative old token |%s| is no longer valid, removing\n", string);
                }
                PROPS.remove(string);
                bl = true;
            }
            if (bl) {
                TokenStorage.doPrivilegedRunnable(() -> TokenStorage.store(PROPS_PATH, "save tokens"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readTokens(Path path) {
        if (path == null) {
            return false;
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
            Properties properties = PROPS;
            synchronized (properties) {
                PROPS.clear();
                PROPS.load(bufferedReader);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: failed to load property file %s\n %s\n", path, exception);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<TokenItem> getTokens(List<Rectangle> list) {
        List list2;
        LinkedHashSet<TokenItem> linkedHashSet = new LinkedHashSet<TokenItem>();
        HashSet hashSet = new HashSet();
        Object object = PROPS;
        synchronized (object) {
            list2 = PROPS.entrySet().stream().map(entry -> {
                String string = String.valueOf(entry.getKey());
                TokenItem tokenItem = TokenItem.parse(string, entry.getValue());
                if (tokenItem == null) {
                    hashSet.add(string);
                }
                return tokenItem;
            }).filter(Objects::nonNull).sorted((tokenItem, tokenItem2) -> tokenItem2.allowedScreensBounds.size() - tokenItem.allowedScreensBounds.size()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        TokenStorage.doPrivilegedRunnable(() -> TokenStorage.removeMalformedRecords(hashSet));
        for (Object object2 : list2) {
            if (object2 == null || !((TokenItem)object2).hasAllScreensWithExactMatch(list)) continue;
            linkedHashSet.add((TokenItem)object2);
        }
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.println("// getTokens exact matches 1. " + linkedHashSet);
        }
        object = list.stream().map(rectangle -> new Dimension(rectangle.width, rectangle.height)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        for (TokenItem tokenItem3 : list2) {
            if (tokenItem3 == null || !tokenItem3.hasAllScreensOfSameSize((List<Dimension>)object)) continue;
            linkedHashSet.add(tokenItem3);
        }
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.println("// getTokens same sizes 2. " + linkedHashSet);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMalformedRecords(Set<String> set) {
        if (!TokenStorage.isWritable(PROPS_PATH) || set == null || set.isEmpty()) {
            return;
        }
        Properties properties = PROPS;
        synchronized (properties) {
            for (String string : set) {
                Object v = PROPS.remove(string);
                if (!ScreencastHelper.SCREENCAST_DEBUG) continue;
                System.err.println("removing malformed record\n" + v);
            }
            TokenStorage.store(PROPS_PATH, "remove malformed records");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(Path path, String string) {
        if (!TokenStorage.isWritable(path)) {
            return;
        }
        Properties properties = PROPS;
        synchronized (properties) {
            block18: {
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    PROPS.store(bufferedWriter, null);
                }
                catch (IOException iOException) {
                    if (!ScreencastHelper.SCREENCAST_DEBUG) break block18;
                    System.err.printf("Token storage: unable to %s\n%s\n", string, iOException);
                }
            }
        }
    }

    private static boolean isWritable(Path path) {
        if (path == null || Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: %s is not writable\n", path);
            }
            return false;
        }
        return true;
    }

    static {
        Path path = AccessController.doPrivileged(() -> TokenStorage.setupPath());
        PROPS_PATH = path;
        if (PROPS_PATH != null) {
            PROP_FILENAME = PROPS_PATH.getFileName();
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("Token storage: using " + PROPS_PATH);
            }
            TokenStorage.setupWatch();
        } else {
            PROP_FILENAME = null;
        }
    }

    private static class WatcherThread
    extends Thread {
        private final WatchService watcher;

        public WatcherThread(WatchService watchService) {
            this.watcher = watchService;
            this.setName("ScreencastWatcher");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("ScreencastWatcher: started");
            }
            while (true) {
                WatchKey watchKey;
                try {
                    watchKey = this.watcher.take();
                }
                catch (InterruptedException interruptedException) {
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.err.println("ScreencastWatcher: interrupted");
                    }
                    return;
                }
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !watchEvent.context().equals(PROP_FILENAME)) continue;
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.out.printf("ScreencastWatcher: %s %s\n", kind, watchEvent.context());
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        TokenStorage.doPrivilegedRunnable(() -> TokenStorage.setFilePermission(PROPS_PATH));
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        TokenStorage.doPrivilegedRunnable(() -> TokenStorage.readTokens(PROPS_PATH));
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    Properties properties = PROPS;
                    synchronized (properties) {
                        PROPS.clear();
                    }
                }
                watchKey.reset();
            }
        }
    }
}

