/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRBuffers;
import oracle.jvm.hotspot.jfr.JFREventWriter;
import oracle.jvm.hotspot.jfr.JFRProducers;
import oracle.jvm.hotspot.jfr.JFRRepository;
import oracle.jvm.hotspot.jfr.JFRStackTraceRepository;
import oracle.jvm.hotspot.jfr.JavaConstantPools;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JFR {
    private static AddressField jfrBuffersField;
    private static AddressField jfrRepositoryField;
    private static AddressField jfrEventWriterField;
    private static AddressField jfrProducersField;
    private static Field jfrConstantPoolsField;
    private static Field jfrStackTracesField;
    private static Field jfrStartMillisField;
    private static Field jfrPreviousStartMillisField;
    private static Field jfrStartTicksField;
    private static Field jfrPreviousStartTicksField;
    private static AddressField jfrLocaleField;
    private static CIntegerField jfrLocaleLenField;
    private static Field jfrStartupRecordingField;
    private static CIntegerField jfrTZOffsetField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Jfr");
        jfrBuffersField = type.getAddressField("_jfr_buffers");
        jfrRepositoryField = type.getAddressField("_jfr_repository");
        jfrEventWriterField = type.getAddressField("_jfr_event_writer");
        jfrProducersField = type.getAddressField("_jfr_producers");
        jfrLocaleField = type.getAddressField("_jfr_locale");
        jfrConstantPoolsField = type.getField("_java_constant_pools");
        jfrStackTracesField = type.getField("_jfr_stacktraces");
        jfrStartMillisField = type.getField("_jfr_start_millis");
        jfrPreviousStartMillisField = type.getField("_jfr_start_millis_prev");
        jfrStartTicksField = type.getField("_jfr_start_ticks");
        jfrPreviousStartTicksField = type.getField("_jfr_start_ticks_prev");
        jfrLocaleLenField = type.getCIntegerField("_jfr_locale_len");
        jfrStartupRecordingField = type.getField("_jfr_startup_recording");
        jfrTZOffsetField = type.getCIntegerField("_jfr_tz_offset");
    }

    public static JFRBuffers getJFRBuffers() {
        return (JFRBuffers)VMObjectFactory.newObject(JFRBuffers.class, jfrBuffersField.getValue());
    }

    public static JFRRepository getJFRRepository() {
        return (JFRRepository)VMObjectFactory.newObject(JFRRepository.class, jfrRepositoryField.getValue());
    }

    public static JFREventWriter getJFREventWriter() {
        return (JFREventWriter)VMObjectFactory.newObject(JFREventWriter.class, jfrEventWriterField.getValue());
    }

    public static JavaConstantPools getJFRConstantPools() {
        return (JavaConstantPools)VMObjectFactory.newObject(JavaConstantPools.class, jfrConstantPoolsField.getStaticFieldAddress());
    }

    public static JFRProducers getJFRProducers() {
        return (JFRProducers)VMObjectFactory.newObject(JFRProducers.class, jfrProducersField.getValue());
    }

    public static JFRStackTraceRepository getJFRStackTraces() {
        return (JFRStackTraceRepository)VMObjectFactory.newObject(JFRStackTraceRepository.class, jfrStackTracesField.getStaticFieldAddress());
    }

    public static long getLocaleLen() {
        return jfrLocaleLenField.getValue();
    }

    public static byte[] getLocale() {
        long len = JFR.getLocaleLen();
        Address jfrLocaleAddress = jfrLocaleField.getValue();
        byte[] str = new byte[(int)len];
        int i = 0;
        while ((long)i < len) {
            str[i] = jfrLocaleAddress.getJByteAt(i);
            ++i;
        }
        return str;
    }

    public static long getStartMillis() {
        return jfrStartMillisField.getJLong();
    }

    public static long getPreviousStartMillis() {
        return jfrPreviousStartMillisField.getJLong();
    }

    public static long getStartTicks() {
        return jfrStartTicksField.getJLong();
    }

    public static long getPreviousStartTicks() {
        return jfrPreviousStartTicksField.getJLong();
    }

    public static int getTZOffset() {
        return (int)jfrTZOffsetField.getValue();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFR.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

