/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;

public class NativePlatform {
    String _osname;
    String _osarch;
    String _unifiedOsArch;
    boolean _is32Bit;
    boolean _is64Bit;
    private static NativePlatform _currentNativePlatform = null;

    public String getOSName() {
        return this._osname;
    }

    public String getOSArch() {
        return this._osarch;
    }

    public String getOsArchUnified() {
        return this._unifiedOsArch;
    }

    public boolean is32Bit() {
        return this._is32Bit;
    }

    public boolean is64Bit() {
        return this._is64Bit;
    }

    public static NativePlatform getCurrentNativePlatform() {
        if (null == _currentNativePlatform) {
            _currentNativePlatform = new NativePlatform(null, null);
        }
        return _currentNativePlatform;
    }

    public NativePlatform(String string, String string2) {
        if (string == null) {
            string = Config.getOSName();
        }
        if (string2 == null) {
            string2 = Config.getOSArch();
        }
        this._osname = string;
        this._osarch = string2;
        if (string2.equals("x86") || string2.equals("i386") || string2.equals("i486") || string2.equals("i586") || string2.equals("i686")) {
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = "x86";
        } else if (string2.equals("ppc") || string2.equals("arm") || string2.equals("sparc") || string2.equals("pa_risc2.0")) {
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = string2;
        } else if (string2.equals("x86_64") || string2.equals("amd64")) {
            this._is32Bit = false;
            this._is64Bit = true;
            this._unifiedOsArch = "x86_64";
        } else if (string2.equals("ia64") || string2.equals("sparcv9")) {
            this._is32Bit = false;
            this._is64Bit = true;
            this._unifiedOsArch = string2;
        } else if (string2.equals("aarch64")) {
            this._is32Bit = false;
            this._is64Bit = true;
            this._unifiedOsArch = string2;
        } else {
            String string3 = "JREInfo: unknown osArch: <" + string2 + ">, considering 32bit";
            Trace.println(string3);
            System.out.println(string3);
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = string2;
        }
    }

    public boolean match(NativePlatform nativePlatform) {
        return this.getOSName().equals(nativePlatform.getOSName()) && this.getOsArchUnified().equals(nativePlatform.getOsArchUnified());
    }

    public boolean compatible(NativePlatform nativePlatform) {
        return this.getOSName().equals(nativePlatform.getOSName()) && Platform.get().isCompatibleArch(this.getOsArchUnified(), nativePlatform.getOsArchUnified());
    }

    public String toString() {
        String string = this.is32Bit() ? "32bit" : (this.is64Bit() ? "64bit" : "??bit");
        return this._osname + ", " + this._osarch + " [ " + this._unifiedOsArch + ", " + string + " ]";
    }
}

