/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022_JP;
import sun.nio.cs.ext.SJIS;
import sun.security.action.GetPropertyAction;

public class JISAutoDetect
extends Charset
implements HistoricallyNamedCharset {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;

    public JISAutoDetect() {
        super("x-JISAutoDetect", ExtendedCharsets.aliasesFor("x-JISAutoDetect"));
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof SJIS || charset instanceof EUC_JP || charset instanceof ISO2022_JP || charset instanceof JISAutoDetect;
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public String historicalName() {
        return "JISAutoDetect";
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    private static boolean looksLikeJapanese(CharBuffer charBuffer) {
        int n = 0;
        int n2 = 0;
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            if ('\u3040' <= c && c <= '\u309f' && ++n > 1) {
                return true;
            }
            if ('\uff65' > c || c > '\uff9f' || ++n2 <= 1) continue;
            return true;
        }
        return false;
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final String SJISName = Decoder.getSJISName();
        private static final String EUCJPName = Decoder.getEUCJPName();
        private DelegatableDecoder detectedDecoder = null;

        public Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        private static boolean isPlainASCII(byte by) {
            return by >= 0 && by != 27;
        }

        private static void copyLeadingASCII(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte by;
            int n;
            int n2 = byteBuffer.position();
            int n3 = n2 + Math.min(byteBuffer.remaining(), charBuffer.remaining());
            for (n = n2; n < n3 && Decoder.isPlainASCII(by = byteBuffer.get(n)); ++n) {
                charBuffer.put((char)(by & 0xFF));
            }
            byteBuffer.position(n);
        }

        private CoderResult decodeLoop(DelegatableDecoder delegatableDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
            ((CharsetDecoder)((Object)delegatableDecoder)).reset();
            this.detectedDecoder = delegatableDecoder;
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (this.detectedDecoder == null) {
                CharBuffer charBuffer2;
                ByteBuffer byteBuffer2;
                Decoder.copyLeadingASCII(byteBuffer, charBuffer);
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!charBuffer.hasRemaining() && Decoder.isPlainASCII(byteBuffer.get(byteBuffer.position()))) {
                    return CoderResult.OVERFLOW;
                }
                int n = (int)((double)byteBuffer.limit() * (double)this.maxCharsPerByte());
                CharBuffer charBuffer3 = CharBuffer.allocate(n);
                Charset charset = Charset.forName("ISO-2022-JP");
                DelegatableDecoder delegatableDecoder = (DelegatableDecoder)((Object)charset.newDecoder());
                CoderResult coderResult = delegatableDecoder.decodeLoop(byteBuffer2 = byteBuffer.asReadOnlyBuffer(), charBuffer3);
                if (!coderResult.isError()) {
                    return this.decodeLoop(delegatableDecoder, byteBuffer, charBuffer);
                }
                Charset charset2 = Charset.forName(EUCJPName);
                Charset charset3 = Charset.forName(SJISName);
                DelegatableDecoder delegatableDecoder2 = (DelegatableDecoder)((Object)charset2.newDecoder());
                DelegatableDecoder delegatableDecoder3 = (DelegatableDecoder)((Object)charset3.newDecoder());
                ByteBuffer byteBuffer3 = byteBuffer.asReadOnlyBuffer();
                charBuffer3.clear();
                CoderResult coderResult2 = delegatableDecoder2.decodeLoop(byteBuffer3, charBuffer3);
                if (coderResult2.isError()) {
                    return this.decodeLoop(delegatableDecoder3, byteBuffer, charBuffer);
                }
                ByteBuffer byteBuffer4 = byteBuffer.asReadOnlyBuffer();
                CoderResult coderResult3 = delegatableDecoder3.decodeLoop(byteBuffer4, charBuffer2 = CharBuffer.allocate(n));
                if (coderResult3.isError()) {
                    return this.decodeLoop(delegatableDecoder2, byteBuffer, charBuffer);
                }
                if (byteBuffer3.position() > byteBuffer4.position()) {
                    return this.decodeLoop(delegatableDecoder2, byteBuffer, charBuffer);
                }
                if (byteBuffer3.position() < byteBuffer4.position()) {
                    return this.decodeLoop(delegatableDecoder3, byteBuffer, charBuffer);
                }
                if (byteBuffer.position() == byteBuffer3.position()) {
                    return CoderResult.UNDERFLOW;
                }
                charBuffer3.flip();
                return this.decodeLoop(JISAutoDetect.looksLikeJapanese(charBuffer3) ? delegatableDecoder2 : delegatableDecoder3, byteBuffer, charBuffer);
            }
            return this.detectedDecoder.decodeLoop(byteBuffer, charBuffer);
        }

        @Override
        protected void implReset() {
            this.detectedDecoder = null;
        }

        @Override
        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.detectedDecoder != null) {
                return this.detectedDecoder.implFlush(charBuffer);
            }
            return super.implFlush(charBuffer);
        }

        @Override
        public boolean isAutoDetecting() {
            return true;
        }

        @Override
        public boolean isCharsetDetected() {
            return this.detectedDecoder != null;
        }

        @Override
        public Charset detectedCharset() {
            if (this.detectedDecoder == null) {
                throw new IllegalStateException("charset not yet detected");
            }
            return ((CharsetDecoder)((Object)this.detectedDecoder)).charset();
        }

        private static String getSJISName() {
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "PCK";
            }
            if (string.startsWith("Windows")) {
                return "windows-31J";
            }
            return "Shift_JIS";
        }

        private static String getEUCJPName() {
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "x-eucjp-open";
            }
            return "EUC_JP";
        }
    }
}

