/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.liquibase.common.DatatypeJavaType;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Driver;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.core.AddAutoIncrementChange;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.change.core.OutputChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.ClobType;
import liquibase.datatype.core.UnknownType;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.HSqlUtil;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.StringUtils;

public class ChangedColumnChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedColumnChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Change[] changes = super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        if (intellijDatabase == null) {
            for (Change change : changes) {
                ChangedColumnChangeGenerator.updateChangeType(differences, comparisonDatabase, change);
            }
        }
        return changes;
    }

    private static void updateChangeType(ObjectDifferences differences, Database comparisonDatabase, Change change) {
        DataType referenceType;
        LiquibaseDataType liquibaseDataType;
        Difference typeDifference;
        DataTypeFactory dataTypeFactory = DataTypeFactory.getInstance();
        if (change instanceof ModifyDataTypeChange && (typeDifference = differences.getDifference("type")) != null && !((liquibaseDataType = dataTypeFactory.from(referenceType = (DataType)typeDifference.getReferenceValue(), comparisonDatabase)) instanceof UnknownType)) {
            ((ModifyDataTypeChange)change).setNewDataType(liquibaseDataType.toDatabaseDataType(comparisonDatabase).toString());
        }
    }

    protected void handleNullableDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        super.handleNullableDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
        ArrayList<Change> toRemoveChanges = new ArrayList<Change>();
        for (Change change : changes) {
            Table table;
            PrimaryKey relationPk;
            List relationPkColumns;
            Relation relation;
            if (change instanceof AddNotNullConstraintChange) {
                LiquibaseDataType ldt = DataTypeFactory.getInstance().from(column.getType(), comparisonDatabase);
                if (ldt == null) continue;
                ((AddNotNullConstraintChange)change).setColumnDataType(ldt.toDatabaseDataType(comparisonDatabase).toString());
                continue;
            }
            if (!(change instanceof DropNotNullConstraintChange)) continue;
            IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
            if (intellijDatabase != null && intellijDatabase.getOrmFramework() != JpaOrmFramework.INSTANCE) {
                toRemoveChanges.add(change);
            }
            if (!((relation = column.getRelation()) instanceof Table) || (relationPkColumns = (relationPk = (table = (Table)relation).getPrimaryKey()) == null ? null : relationPk.getColumns()) == null || !ContainerUtil.exists((Iterable)relationPkColumns, pkColumn -> pkColumn.equals((Object)column))) continue;
            toRemoveChanges.add(change);
        }
        changes.removeAll(toRemoveChanges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleTypeDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        if (intellijDatabase == null) {
            super.handleTypeDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
            return;
        }
        Difference typeDifference = differences.getDifference("type");
        if (typeDifference == null) {
            return;
        }
        Object referenceValue = typeDifference.getReferenceValue();
        Object comparedValue = typeDifference.getComparedValue();
        if (!(referenceValue instanceof DataType)) return;
        DataType referenceDataType = (DataType)referenceValue;
        if (!(comparedValue instanceof DataType)) {
            return;
        }
        DataType comparedDataType = (DataType)comparedValue;
        String catalogName = null;
        String schemaName = null;
        if (control.getIncludeCatalog()) {
            catalogName = column.getRelation().getSchema().getCatalog().getName();
        }
        if (control.getIncludeSchema()) {
            schemaName = column.getRelation().getSchema().getName();
        }
        String tableName = column.getRelation().getName();
        LiquibaseGenerationContext generationContext = intellijDatabase.getGenerationContext();
        if ((LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.ORACLE || LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.DB2) && ("clob".equalsIgnoreCase(JavaType.render(referenceDataType, generationContext)) || "clob".equalsIgnoreCase(comparedDataType.getTypeName()))) {
            ColumnMigrator columnMigrator = new ColumnMigrator(column);
            columnMigrator.referenceDatabase = referenceDatabase;
            columnMigrator.referenceDataType = referenceDataType;
            columnMigrator.comparedDataType = comparedDataType;
            columnMigrator.catalogName = catalogName;
            columnMigrator.schemaName = schemaName;
            columnMigrator.tableName = tableName;
            columnMigrator.generationContext = generationContext;
            changes.addAll(columnMigrator.collectChanges());
            return;
        } else {
            if (LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.DB2 && "VARCHAR".equalsIgnoreCase(comparedDataType.getTypeName()) && comparedDataType.getColumnSize() > 0 && StringUtil.endsWithIgnoreCase((String)JavaType.render(referenceDataType, generationContext), (String)("varchar(" + comparedDataType.getColumnSize() / 4 + ")"))) return;
            if (LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.MARIA) {
                String innerType = generationContext.getType(referenceDataType.getTypeName()).render(generationContext);
                if (!comparedDataType.getTypeName().equalsIgnoreCase(StringUtil.replaceIgnoreCase((String)innerType, (String)" unsigned", (String)""))) return;
            }
            if (!ChangedColumnChangeGenerator.isConvertibleType(referenceDatabase, comparisonDatabase, referenceDataType, comparedDataType)) {
                DropColumnChange dropColumnChange = new DropColumnChange();
                dropColumnChange.setCatalogName(catalogName);
                dropColumnChange.setSchemaName(schemaName);
                dropColumnChange.setTableName(tableName);
                dropColumnChange.setColumnName(column.getName());
                changes.add((Change)dropColumnChange);
                AddColumnChange addColumn = new AddColumnChange();
                addColumn.setCatalogName(catalogName);
                addColumn.setSchemaName(schemaName);
                addColumn.setTableName(tableName);
                AddColumnConfig addColumnConfig = new AddColumnConfig(column);
                addColumnConfig.setName(column.getName());
                addColumnConfig.setType(JavaType.render(referenceDataType, generationContext));
                addColumnConfig.setAutoIncrement(column.isAutoIncrement() ? Boolean.TRUE : null);
                addColumn.addColumn(addColumnConfig);
                changes.add((Change)addColumn);
                return;
            } else {
                JavaType javaType;
                if (intellijDatabase.getOrmFramework() != JpaOrmFramework.INSTANCE) return;
                if (LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.MSSQL && column.getDefaultValue() != null) {
                    DropDefaultValueChange dropDefaultValueChange = new DropDefaultValueChange();
                    dropDefaultValueChange.setCatalogName(catalogName);
                    dropDefaultValueChange.setSchemaName(schemaName);
                    dropDefaultValueChange.setTableName(tableName);
                    dropDefaultValueChange.setColumnName(column.getName());
                    changes.add((Change)dropDefaultValueChange);
                }
                ModifyDataTypeChange change = new ModifyDataTypeChange();
                change.setCatalogName(catalogName);
                change.setSchemaName(schemaName);
                change.setTableName(tableName);
                change.setColumnName(column.getName());
                LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(referenceDataType, comparisonDatabase);
                String newDataType = liquibaseDataType.toString();
                if (referenceDatabase instanceof IntellijDatabase && liquibaseDataType instanceof ClobType && (javaType = generationContext.getType(referenceDataType.getTypeName())) instanceof DatatypeJavaType && ((DatatypeJavaType)javaType).getDatatype() == Datatypes.BasicDatatype.LobString) {
                    newDataType = javaType.render(generationContext);
                }
                change.setNewDataType(newDataType);
                changes.add((Change)change);
            }
        }
    }

    private static boolean isConvertibleType(Database referenceDatabase, Database comparisonDatabase, DataType referenceDataType, DataType comparedDataType) {
        if (referenceDatabase instanceof IntellijDatabase) {
            LiquibaseGenerationContext generationContext = ((IntellijDatabase)referenceDatabase).getGenerationContext();
            JavaType type = generationContext.getType(referenceDataType.getTypeName());
            return type.isConvertibleType(comparedDataType.getTypeName(), generationContext);
        }
        if (comparisonDatabase instanceof IntellijDatabase) {
            LiquibaseGenerationContext generationContext = ((IntellijDatabase)comparisonDatabase).getGenerationContext();
            JavaType type = generationContext.getType(comparedDataType.getTypeName());
            return type.isConvertibleType(referenceDataType.getTypeName(), generationContext);
        }
        throw new IllegalArgumentException("No found IntellijDatabase");
    }

    protected void handleDefaultValueDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        if (referenceDatabase instanceof IntellijDatabase || comparisonDatabase instanceof IntellijDatabase) {
            Difference difference = differences.getDifference("defaultValue");
            if (difference != null && difference.getReferenceValue() == null) {
                return;
            }
            if (referenceDatabase instanceof IntellijDatabase && difference != null) {
                String comparedValueNoCast;
                DbType comparisonDatabaseType = LiquibaseUtils.getDatabaseType(comparisonDatabase);
                Object referenceValue = difference.getReferenceValue();
                Object comparedValue = difference.getComparedValue();
                if (referenceValue == Boolean.FALSE && comparedValue == null || ChangedColumnChangeGenerator.isSameBooleanExpr(referenceValue, comparedValue) || referenceValue instanceof DatabaseFunction && comparedValue instanceof DatabaseFunction) {
                    return;
                }
                if ((comparisonDatabaseType == DbType.MYSQL || comparisonDatabaseType == DbType.MARIA) && referenceValue != null && referenceValue.equals("") && comparedValue == null) {
                    return;
                }
                if (referenceValue instanceof Boolean) {
                    String value;
                    Boolean refValueBoolean = (Boolean)referenceValue;
                    if ((comparisonDatabaseType == DbType.MSSQL || comparisonDatabaseType == DbType.MYSQL || comparisonDatabaseType == DbType.MARIA) && comparedValue instanceof DatabaseFunction && (StringUtil.contains((CharSequence)(value = ((DatabaseFunction)comparedValue).getValue()), (CharSequence)"0") && !refValueBoolean.booleanValue() || StringUtil.contains((CharSequence)value, (CharSequence)"1") && refValueBoolean.booleanValue())) {
                        return;
                    }
                    if (comparisonDatabaseType == DbType.ORACLE && comparedValue instanceof BigDecimal) {
                        Boolean comparedConverted;
                        Boolean referenceConverted = (Boolean)referenceValue;
                        Boolean bl = comparedConverted = comparedValue.equals(new BigDecimal(0)) ? Boolean.FALSE : Boolean.TRUE;
                        if (referenceConverted.equals(comparedConverted)) {
                            return;
                        }
                    }
                }
                if ((referenceValue instanceof Timestamp || referenceValue instanceof Date || referenceValue instanceof Time) && comparedValue != null) {
                    if (comparedValue instanceof DatabaseFunction && comparisonDatabaseType == DbType.DB2) {
                        return;
                    }
                    String refValueString = referenceValue.toString();
                    String comValueString = StringUtils.substringAfter((String)comparedValue.toString(), (String)"'");
                    for (int i = 0; i < comValueString.length(); ++i) {
                        if (refValueString.length() == i) {
                            return;
                        }
                        if (comValueString.charAt(i) == '\'') {
                            return;
                        }
                        if (refValueString.charAt(i) != comValueString.charAt(i)) break;
                    }
                }
                if ((comparisonDatabaseType == DbType.HSQL || comparisonDatabaseType == DbType.MYSQL || comparisonDatabaseType == DbType.MARIA) && referenceValue instanceof Number && comparedValue instanceof DatabaseFunction) {
                    return;
                }
                if (comparedValue != null && referenceValue != null && (comparedValueNoCast = HSqlUtil.removeTypeCasts(comparedValue.toString())).equalsIgnoreCase(referenceValue.toString())) {
                    return;
                }
                if (comparisonDatabaseType == DbType.MSSQL && comparedValue != null) {
                    DropDefaultValueChange dropChange = new DropDefaultValueChange();
                    Optional.ofNullable(column.getRelation()).map(Relation::getSchema).map(Schema::getName).ifPresent(arg_0 -> ((DropDefaultValueChange)dropChange).setSchemaName(arg_0));
                    Optional.ofNullable(column.getRelation()).map(Relation::getName).ifPresent(arg_0 -> ((DropDefaultValueChange)dropChange).setTableName(arg_0));
                    dropChange.setColumnName(column.getName());
                    changes.add((Change)dropChange);
                }
            }
        }
        super.handleDefaultValueDifferences(column, differences, control, changes, referenceDatabase, comparisonDatabase);
    }

    protected void handleAutoIncrementDifferences(Column column, ObjectDifferences differences, DiffOutputControl control, List<Change> changes, Database referenceDatabase, Database comparisonDatabase) {
        Difference difference = differences.getDifference("autoIncrement");
        if (difference != null) {
            Object referenceValue = difference.getReferenceValue();
            if (referenceValue == null || referenceValue == Boolean.FALSE) {
                Logger.getInstance(ChangedColumnChangeGenerator.class).info("ChangedColumnChangeGenerator cannot fix dropped auto increment values");
            } else {
                if (ChangedColumnChangeGenerator.isInvalidDriver(referenceDatabase, comparisonDatabase)) {
                    return;
                }
                if (LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.MSSQL) {
                    return;
                }
                AddAutoIncrementChange change = new AddAutoIncrementChange();
                if (control.getIncludeCatalog()) {
                    change.setCatalogName(column.getRelation().getSchema().getCatalog().getName());
                }
                if (control.getIncludeSchema()) {
                    change.setSchemaName(column.getRelation().getSchema().getName());
                }
                change.setTableName(column.getRelation().getName());
                change.setColumnName(column.getName());
                change.setColumnDataType(DataTypeFactory.getInstance().from(column.getType(), comparisonDatabase).toString());
                changes.add((Change)change);
            }
        }
    }

    private static boolean isInvalidDriver(Database referenceDatabase, Database comparisonDatabase) {
        DbType comparisonDatabaseType = LiquibaseUtils.getDatabaseType(comparisonDatabase);
        if (comparisonDatabaseType == DbType.ORACLE) {
            return true;
        }
        if (comparisonDatabaseType != DbType.POSTGRES) {
            return false;
        }
        if (!(referenceDatabase instanceof IntellijDatabase)) {
            return false;
        }
        Project project = ((IntellijDatabase)referenceDatabase).getProject();
        if (project == null) {
            return false;
        }
        DbDriversManager dbDriversManager = DbDriversManager.getInstance((Project)project);
        Driver postgresDriver = dbDriversManager.findDriver(DbType.POSTGRES);
        if (postgresDriver == null) {
            return false;
        }
        return postgresDriver.getMajorVersion() <= 9;
    }

    private static boolean isSameBooleanExpr(Object referenceValue, Object comparedValue) {
        if (referenceValue instanceof Integer && comparedValue instanceof Boolean) {
            return ChangedColumnChangeGenerator.isSameBooleanExpr((Integer)referenceValue, (Boolean)comparedValue);
        }
        if (comparedValue instanceof Integer && referenceValue instanceof Boolean) {
            return ChangedColumnChangeGenerator.isSameBooleanExpr((Integer)comparedValue, (Boolean)referenceValue);
        }
        return false;
    }

    private static boolean isSameBooleanExpr(int intValue, boolean boolValue) {
        return intValue == 0 && !boolValue || intValue == 1 && boolValue;
    }

    private static class ColumnMigrator {
        private final Column column;
        private Database referenceDatabase;
        private DataType referenceDataType;
        private DataType comparedDataType;
        private String catalogName;
        private String schemaName;
        private String tableName;
        private LiquibaseGenerationContext generationContext;

        private ColumnMigrator(Column column) {
            this.column = column;
        }

        private List<Change> collectChanges() {
            ArrayList<Change> changes = new ArrayList<Change>();
            String tempColName = "TEMP_CLOB_CONVERT";
            OutputChange outputChange = new OutputChange();
            outputChange.setTarget("WARN");
            outputChange.setMessage("Cannot convert directly from " + this.comparedDataType.getTypeName() + " to " + this.generationContext.getType(this.referenceDataType.getTypeName()).toLiquibaseDataType(this.generationContext).getTypeName() + ". Instead a new column will be created and the data transferred. This may cause unexpected side effects including constraint issues and/or table locks.");
            changes.add((Change)outputChange);
            AddColumnChange addColumn = new AddColumnChange();
            addColumn.setCatalogName(this.catalogName);
            addColumn.setSchemaName(this.schemaName);
            addColumn.setTableName(this.tableName);
            AddColumnConfig addColumnConfig = new AddColumnConfig(this.column);
            addColumnConfig.setName(tempColName);
            addColumnConfig.setType(JavaType.render(this.referenceDataType, this.generationContext));
            ArrayList<AddColumnConfig> columns = new ArrayList<AddColumnConfig>();
            columns.add(addColumnConfig);
            addColumn.setColumns(columns);
            changes.add((Change)addColumn);
            changes.add((Change)new RawSQLChange("UPDATE " + this.referenceDatabase.escapeObjectName(this.tableName, Table.class) + " SET " + tempColName + "=" + this.referenceDatabase.escapeObjectName(this.column.getName(), Column.class)));
            DropColumnChange dropColumnChange = new DropColumnChange();
            dropColumnChange.setCatalogName(this.catalogName);
            dropColumnChange.setSchemaName(this.schemaName);
            dropColumnChange.setTableName(this.tableName);
            dropColumnChange.setColumnName(this.column.getName());
            changes.add((Change)dropColumnChange);
            RenameColumnChange renameColumnChange = new RenameColumnChange();
            renameColumnChange.setCatalogName(this.catalogName);
            renameColumnChange.setSchemaName(this.schemaName);
            renameColumnChange.setTableName(this.tableName);
            renameColumnChange.setOldColumnName(tempColName);
            renameColumnChange.setNewColumnName(this.column.getName());
            changes.add((Change)renameColumnChange);
            return changes;
        }
    }
}

