/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.snowflake.types.SFlakeArrayType;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.snowflake.psi.SFlakeCreateStreamStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectLiteralExpression;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J&\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u0016H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/snowflake/types/SFlakeTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getTypeCategoryByName", "typeName", "doCreateArrayType", "Lcom/intellij/database/dialects/snowflake/types/SFlakeArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "getUnqualifiedAsteriskType", "element", "intellij.database.dialects.snowflake"})
public final class SFlakeTypeSystem
extends DasTypeSystemImpl {
    public SFlakeTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return StringsKt.equals((String)name2, (String)"GEOGRAPHY", (boolean)true) ? super.getNormalizedTypeName(name2) : super.getNormalizedTypeName(this.getDefaultTypeName(this.getTypeCategoryByName(name2)));
    }

    @NotNull
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "boolean";
            case 3 -> "float";
            case 4 -> "varchar";
            case 5 -> "binary";
            case 6, 7 -> "timestamp";
            case 8 -> "date";
            case 9 -> "time";
            case 10 -> "object";
            default -> "variant";
        };
    }

    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return StringUtil.containsIgnoreCase((String)typeName, (String)"string") ? DasTypeCategory.STRING : (StringUtil.containsIgnoreCase((String)typeName, (String)"bit") ? DasTypeCategory.BYTES : (StringUtil.containsIgnoreCase((String)typeName, (String)"dec") ? DasTypeCategory.REAL : (StringUtil.containsIgnoreCase((String)typeName, (String)"numeric") ? DasTypeCategory.REAL : (StringUtil.containsIgnoreCase((String)typeName, (String)"timestamp") ? DasTypeCategory.TIMESTAMP : (StringUtil.containsIgnoreCase((String)typeName, (String)"object") ? DasTypeCategory.RECORD : super.getTypeCategoryByName(typeName))))));
    }

    @NotNull
    protected SFlakeArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new SFlakeArrayType(componentType);
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReference ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (ref != null && resolved instanceof SFlakeCreateStreamStatement) {
            SqlReferenceExpression sqlReferenceExpression;
            SqlReferenceExpression tableRef = ((SFlakeCreateStreamStatement)resolved).getTargetTableReference();
            SqlReferenceExpression sqlReferenceExpression2 = tableRef;
            if (sqlReferenceExpression2 == null || (sqlReferenceExpression2 = sqlReferenceExpression2.getDasType()) == null) {
                sqlReferenceExpression2 = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            SqlTableType sqlTableType = (sqlReferenceExpression = sqlReferenceExpression2) instanceof SqlTableType ? (SqlTableType)sqlReferenceExpression : null;
            if (sqlTableType == null) {
                SqlTableType sqlTableType2 = SqlTableTypeBase.createUnresolvedTableType((PsiReference)((PsiReference)ref));
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType2, (String)"createUnresolvedTableType(...)");
                return (DasType)sqlTableType2;
            }
            SqlTableType baseType = sqlTableType;
            PsiElement psiElement = ref.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement refElement = psiElement;
            Object[] objectArray = new SqlImplUtil.Column[]{SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ACTION", (DasType)this.getStringType(), (boolean)false), SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ISUPDATE", (DasType)this.getBooleanType(), (boolean)false), SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ROW_ID", (DasType)this.getStringType(), (boolean)false)};
            SqlTableType sqlTableType3 = SqlImplUtil.createType((List)CollectionsKt.listOf((Object[])objectArray), (PsiElement)refElement);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType3, (String)"createType(...)");
            SqlTableType extraType = sqlTableType3;
            SqlTableType sqlTableType4 = baseType.add(extraType);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType4, (String)"add(...)");
            return (DasType)sqlTableType4;
        }
        return super.getDasType(ref, resolved, symbol);
    }

    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        SqlObjectLiteralExpression sqlObjectLiteralExpression = psiElement instanceof SqlObjectLiteralExpression ? (SqlObjectLiteralExpression)psiElement : null;
        return super.getUnqualifiedAsteriskType(sqlObjectLiteralExpression != null ? (PsiElement)sqlObjectLiteralExpression : element);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.RECORD.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

