/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlTypeSystem;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlPresentableNamedElement;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.VtlVariableType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlLoopVariable
extends VtlPresentableNamedElement
implements VtlVariable {
    public VtlLoopVariable(ASTNode node) {
        super(node);
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.loop.variable", new Object[0]);
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    @Override
    @Nullable
    public VtlVariableType getPsiType() {
        VtlImplicitVariable variable = VtlImplicitVariable.findImplicitCounterpart(this);
        return variable != null ? variable.getPsiType() : VtlLoopVariable.extractTypeFromIterable(this.getIterableExpression());
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    @Nullable
    public VtlExpression getIterableExpression() {
        for (PsiElement wouldBeIterable = this.getNextSibling(); wouldBeIterable != null; wouldBeIterable = wouldBeIterable.getNextSibling()) {
            if (!(wouldBeIterable instanceof VtlExpression)) continue;
            return (VtlExpression)wouldBeIterable;
        }
        return null;
    }

    @Nullable
    private static VtlVariableType extractTypeFromIterable(@Nullable VtlExpression expr) {
        return VtlTypeSystem.getTypeSystem().extractTypeFromIterable(expr);
    }

    public static String[] getVelocityIterables(@NotNull String className) {
        if (className == null) {
            VtlLoopVariable.$$$reportNull$$$0(0);
        }
        return new String[]{"java.lang.Iterable<" + className + ">", "java.util.Iterator<" + className + ">", "java.util.Collection<" + className + ">", "java.util.Map<?, " + className + ">", className + "[]"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/velocity/psi/VtlLoopVariable", "getVelocityIterables"));
    }
}

