/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome.actions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.monitor.JavaProcessMonitor;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.snapshots.SnapshotFolder;
import com.intellij.profiler.ultimate.welcome.actions.CaptureMemorySnapshot;
import com.intellij.profiler.ultimate.welcome.actions.CaptureMemorySnapshotKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n\u00a8\u0006\f"}, d2={"captureMemorySnapshot", "", "project", "Lcom/intellij/openapi/project/Project;", "pid", "", "executableName", "", "appName", "afterDumpCreated", "Lkotlin/Function2;", "Ljava/io/File;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nCaptureMemorySnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureMemorySnapshot.kt\ncom/intellij/profiler/ultimate/welcome/actions/CaptureMemorySnapshotKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class CaptureMemorySnapshotKt {
    /*
     * WARNING - void declaration
     */
    public static final void captureMemorySnapshot(@NotNull Project project, int pid, @NotNull String executableName, @NotNull String appName, @NotNull Function2<? super Project, ? super File, Unit> afterDumpCreated) {
        Ref.ObjectRef snapshotFolder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter(afterDumpCreated, (String)"afterDumpCreated");
        if (pid < 0) {
            return;
        }
        Ref.ObjectRef objectRef = snapshotFolder = new Ref.ObjectRef();
        Path path = SnapshotFolder.INSTANCE.getPath();
        if (path == null) {
            void it;
            Path path2;
            Path path3 = path2 = UtilsKt.getDefaultSnapshotFolder();
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Files.createDirectories((Path)it, new FileAttribute[0]);
            objectRef = objectRef2;
            path = path2;
        }
        objectRef.element = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)snapshotFolder.element, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            SnapshotFolder.INSTANCE.chooseViaDialog(project, (Function1<? super Path, Unit>)((Function1)arg_0 -> CaptureMemorySnapshotKt.captureMemorySnapshot$lambda$1(snapshotFolder, arg_0)));
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists((Path)snapshotFolder.element, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return;
            }
        }
        String string = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.capturing", new Object[0]);
        new Task.Backgroundable(project, pid, appName, executableName, afterDumpCreated, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ int $pid;
            final /* synthetic */ String $appName;
            final /* synthetic */ String $executableName;
            final /* synthetic */ Function2<Project, File, Unit> $afterDumpCreated;
            {
                this.$project = $project;
                this.$pid = $pid;
                this.$appName = $appName;
                this.$executableName = $executableName;
                this.$afterDumpCreated = $afterDumpCreated;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String snapshotName = CaptureMemorySnapshot.Companion.format(this.$pid, this.$appName);
                File file = SnapshotFolder.INSTANCE.tryCreateFile(snapshotName, "hprof", this.$project).getDumpFile();
                try {
                    JavaProcessMonitor javaProcessMonitor = JavaProcessMonitor.Companion.connect(this.$executableName, this.$pid);
                    String string = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    javaProcessMonitor.dumpHeap(string);
                    ProfileHistoryConfiguration.register$default((ProfileHistoryConfiguration)ProfileHistoryConfiguration.Companion.getInstance(this.$project), (File)file, null, (int)2, null);
                    ActionsKt.runInEdt$default(null, () -> captureMemorySnapshot.2.run$lambda$0(this.$afterDumpCreated, this.$project, file), (int)1, null);
                }
                catch (IOException e) {
                    Object[] objectArray = new Object[]{this.$appName};
                    ProfilerManager.showStickyError$default((ProfilerManager)ProfilerManager.INSTANCE, (String)UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.capturing.memory.error", objectArray), (Project)this.$project, null, (int)4, null);
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(JavaProcessMonitor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info((Throwable)e);
                }
            }

            private static final Unit run$lambda$0(Function2 $afterDumpCreated, Project $project, File $file) {
                $afterDumpCreated.invoke((Object)$project, (Object)$file);
                return Unit.INSTANCE;
            }
        }.queue();
    }

    private static final Unit captureMemorySnapshot$lambda$1(Ref.ObjectRef $snapshotFolder, Path it) {
        Path path = it;
        if (path == null) {
            path = UtilsKt.getDefaultSnapshotFolder();
        }
        $snapshotFolder.element = path;
        return Unit.INSTANCE;
    }
}

