/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.image.search;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.docker.agent.image.search.DockerHubRepository;
import com.intellij.docker.agent.image.search.DockerOauthHelper;
import com.intellij.docker.agent.image.search.DockerSearch;
import com.intellij.docker.agent.util.DockerJsonUtilsKt;
import com.intellij.docker.agent.util.HttpRequestExecutor;
import com.intellij.docker.agent.util.HttpRequestExecutorKt;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\b01234567B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u001b\u001a\u00020\u0018H\u0087@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0087@\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u001e\u001a\u00020\u0018H\u0087@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0018H\u0007J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010#\u001a\u00020\u0018H\u0087@\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0002J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0010\u00a8\u00068"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch;", "", "<init>", "()V", "client", "Lcom/intellij/docker/agent/util/HttpRequestExecutor;", "oauth", "Lcom/intellij/docker/agent/image/search/DockerOauthHelper;", "getOauth", "()Lcom/intellij/docker/agent/image/search/DockerOauthHelper;", "oauth$delegate", "Lkotlin/Lazy;", "libraryImages", "", "Lcom/intellij/docker/agent/image/search/DockerHubRepository;", "getLibraryImages", "()Ljava/util/List;", "libraryImages$delegate", "_libraryImages", "get_libraryImages$annotations", "get_libraryImages", "searchForCompletions", "Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement;", "prefix", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listImageTags", "image", "listImagesV1", "listImageDigests", "imageWithTag", "isOfficialLibraryImage", "", "tag", "listRepositoriesInNamespace", "account", "imageFqn", "oauthToken", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listLibraryImages", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractDigestsFromResponseBody", "response", "Lcom/intellij/docker/agent/util/HttpRequestExecutor$ResponseWithHeaders;", "isAttestationManifest", "manifest", "Lcom/intellij/docker/agent/image/search/DockerSearch$Manifest;", "extractDigestsFromHeaders", "Companion", "TagListV2", "ManifestList", "Manifest", "ManifestPlatform", "DockerDistributionManifestV2", "SearchResultV1", "LookupElement", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerSearch.kt\ncom/intellij/docker/agent/image/search/DockerSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 dockerJsonUtils.kt\ncom/intellij/docker/agent/util/DockerJsonUtilsKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,289:1\n774#2:290\n865#2,2:291\n1563#2:295\n1634#2,3:296\n1761#2,3:299\n1563#2:304\n1634#2,3:305\n1563#2:310\n1634#2,3:311\n1563#2:314\n1634#2,3:315\n1563#2:318\n1634#2,3:319\n827#2:324\n855#2,2:325\n1617#2,9:327\n1869#2:336\n1870#2:338\n1626#2:339\n1869#2:340\n1870#2:343\n121#3:293\n121#3:302\n121#3:308\n121#3:322\n121#3:341\n54#4:294\n54#4:303\n54#4:309\n54#4:323\n54#4:342\n1#5:337\n8#6:344\n*S KotlinDebug\n*F\n+ 1 DockerSearch.kt\ncom/intellij/docker/agent/image/search/DockerSearch\n*L\n63#1:290\n63#1:291,2\n72#1:295\n72#1:296,3\n91#1:299,3\n114#1:304\n114#1:305,3\n128#1:310\n128#1:311,3\n134#1:314\n134#1:315,3\n153#1:318\n153#1:319,3\n159#1:324\n159#1:325,2\n160#1:327,9\n160#1:336\n160#1:338\n160#1:339\n18#1:340\n18#1:343\n71#1:293\n113#1:302\n128#1:308\n158#1:322\n22#1:341\n71#1:294\n113#1:303\n128#1:309\n158#1:323\n22#1:342\n160#1:337\n173#1:344\n*E\n"})
public final class DockerSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpRequestExecutor client = new HttpRequestExecutor(0L, 1, null);
    @NotNull
    private final Lazy oauth$delegate = LazyKt.lazy(() -> DockerSearch.oauth_delegate$lambda$0(this));
    @NotNull
    private final Lazy libraryImages$delegate = LazyKt.lazy(DockerSearch::libraryImages_delegate$lambda$0);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LIBRARY = "library/";
    @NotNull
    private static final String ACCEPT_HEADER = "Accept";
    @NotNull
    private static final String AUTHORIZATION_HEADER = "Authorization";
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    private static final String DOCKER_CONTENT_DIGEST_HEADER = "Docker-Content-Digest";
    @NotNull
    private static final String OCI_IMAGE_INDEX_CONTENT_TYPE = "application/vnd.oci.image.index.v1+json";
    @NotNull
    private static final String OCI_IMAGE_MANIFEST_CONTENT_TYPE = "application/vnd.oci.image.manifest.v1+json";
    @NotNull
    private static final String DOCKER_MANIFEST_LIST_CONTENT_TYPE = "application/vnd.docker.distribution.manifest.list.v2+json";
    @NotNull
    private static final String DOCKER_MANIFEST_CONTENT_TYPE = "application/vnd.docker.distribution.manifest.v2+json";

    private final DockerOauthHelper getOauth() {
        Lazy lazy = this.oauth$delegate;
        return (DockerOauthHelper)lazy.getValue();
    }

    private final List<DockerHubRepository> getLibraryImages() {
        Lazy lazy = this.libraryImages$delegate;
        return (List)lazy.getValue();
    }

    @TestOnly
    @NotNull
    public final List<DockerHubRepository> get_libraryImages() {
        return this.getLibraryImages();
    }

    public static /* synthetic */ void get_libraryImages$annotations() {
    }

    @Nullable
    public final Object searchForCompletions(@NotNull String prefix, @NotNull Continuation<? super List<LookupElement>> $completion) {
        if (!(((CharSequence)prefix).length() == 0)) {
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)"@", (boolean)false, (int)2, null)) {
                return this.listImageDigests(StringsKt.substringBeforeLast$default((String)prefix, (String)"@", null, (int)2, null), $completion);
            }
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)":", (boolean)false, (int)2, null)) {
                return this.listImageTags(StringsKt.substringBeforeLast$default((String)prefix, (String)":", null, (int)2, null), $completion);
            }
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)"/", (boolean)false, (int)2, null)) {
                return this.listRepositoriesInNamespace(StringsKt.substringBeforeLast$default((String)prefix, (String)"/", null, (int)2, null), $completion);
            }
            return this.listImagesV1(prefix, $completion);
        }
        return this.listLibraryImages();
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object listImageTags(@NotNull String image, @NotNull Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listImageTags.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listImageTags(null, (Continuation<? super List<LookupElement>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (((CharSequence)image).length() == 0 || new Regex("[:@$]").containsMatchIn(var3_6 = (CharSequence)image)) {
                    return CollectionsKt.emptyList();
                }
                imageFqn = StringsKt.contains$default((CharSequence)image, (CharSequence)"/", (boolean)false, (int)2, null) != false ? image : "library/" + image;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$1 = imageFqn;
                $continuation.label = 1;
                v0 = DockerOauthHelper.obtainToken$intellij_clouds_docker_agent$default(this.getOauth(), (String)imageFqn, null, (Continuation)$continuation, 2, null);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                imageFqn = (String)$continuation.L$1;
                image = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                token = ((DockerOauthHelper.OauthToken)v0).getToken();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)imageFqn);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.label = 2;
                v1 = this.listImageTags((String)imageFqn, token, (Continuation<? super List<LookupElement>>)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                token = (String)$continuation.L$2;
                imageFqn = (String)$continuation.L$1;
                image = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object listImagesV1(@Nullable String prefix, @NotNull Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listImagesV1.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listImagesV1(null, (Continuation<? super List<LookupElement>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = prefix;
                if (var3_6 == null || var3_6.length() == 0) {
                    return this.listLibraryImages();
                }
                if (prefix.length() < 2) {
                    $this$filter$iv = this.listLibraryImages();
                    $i$f$filter = false;
                    var5_9 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (LookupElement)element$iv$iv;
                        $i$a$-filter-DockerSearch$listImagesV1$2 = false;
                        if (!StringsKt.contains$default((CharSequence)it.getLookupText(), (CharSequence)prefix, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                url = InternalUtilsKt.addQueryParameter(InternalUtilsKt.addQueryParameter(new URI("https://registry.hub.docker.com/v1/search"), "q", prefix), "n", "100");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)prefix);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.label = 1;
                v0 = HttpRequestExecutorKt.httpGet$default(this.client, url, null, (Continuation)$continuation, 2, null);
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl42
            }
            case 1: {
                url = (URI)$continuation.L$1;
                prefix = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 2 sources

                $this$filterTo$iv$iv = (String)v0;
                $i$f$mapJsonTo = false;
                $i$f$jacksonTypeRef = false;
                var4_8 = ((SearchResultV1.SinglePage)DockerJsonUtilsKt.mapJsonTo$default((String)$this$mapJsonTo$iv, (TypeReference)new TypeReference<SearchResultV1.SinglePage>(){}, null, 2, null)).getResults();
                if (var4_8 != null) {
                    $i$f$mapJsonTo = var4_8;
                    $i$f$map = false;
                    var8_17 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var13_25 = (SearchResultV1)item$iv$iv;
                        var15_27 = destination$iv$iv;
                        $i$a$-map-DockerSearch$listImagesV1$3 = false;
                        var15_27.add(p0.toDockerSearchResult());
                    }
                    v1 = (List)destination$iv$iv;
                } else {
                    v1 = CollectionsKt.emptyList();
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object listImageDigests(@NotNull String imageWithTag, @NotNull Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listImageDigests.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listImageDigests(null, (Continuation<? super List<LookupElement>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!StringsKt.contains$default((CharSequence)imageWithTag, (CharSequence)":", (boolean)false, (int)2, null)) {
                    return CollectionsKt.emptyList();
                }
                imageTagSeparatorIndex = StringsKt.lastIndexOf$default((CharSequence)imageWithTag, (String)":", (int)0, (boolean)false, (int)6, null);
                v0 = imageWithTag.substring(0, imageTagSeparatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                image = v0;
                v1 = imageWithTag.substring(imageTagSeparatorIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                tag = v1;
                imageFqn = StringsKt.contains$default((CharSequence)image, (CharSequence)"/", (boolean)false, (int)2, null) != false ? image : "library/" + image;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)imageWithTag);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$2 = tag;
                $continuation.L$3 = imageFqn;
                $continuation.I$0 = imageTagSeparatorIndex;
                $continuation.label = 1;
                v2 = DockerOauthHelper.obtainToken$intellij_clouds_docker_agent$default(this.getOauth(), (String)imageFqn, null, (Continuation)$continuation, 2, null);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl40
            }
            case 1: {
                imageTagSeparatorIndex = $continuation.I$0;
                imageFqn = (String)$continuation.L$3;
                tag = (String)$continuation.L$2;
                image = (String)$continuation.L$1;
                imageWithTag = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl40:
                // 2 sources

                token = ((DockerOauthHelper.OauthToken)v2).getToken();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)imageWithTag);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)tag);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)imageFqn);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.I$0 = imageTagSeparatorIndex;
                $continuation.label = 2;
                v3 = this.listImageDigests((String)imageFqn, tag, token, (Continuation<? super List<LookupElement>>)$continuation);
                if (v3 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl61
            }
            case 2: {
                imageTagSeparatorIndex = $continuation.I$0;
                token = (String)$continuation.L$4;
                imageFqn = (String)$continuation.L$3;
                tag = (String)$continuation.L$2;
                image = (String)$continuation.L$1;
                imageWithTag = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl61:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public final boolean isOfficialLibraryImage(@NotNull String tag) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)"/", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.getLibraryImages();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            DockerHubRepository it = (DockerHubRepository)element$iv;
            boolean bl2 = false;
            if (it.isDefaultNamespace$intellij_clouds_docker_agent() && Intrinsics.areEqual((Object)it.getName(), (Object)tag)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object listRepositoriesInNamespace(@NotNull String account, @NotNull Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listRepositoriesInNamespace.1)) ** GOTO lbl-1000
        var18_3 = $completion;
        if ((var18_3.label & -2147483648) != 0) {
            var18_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listRepositoriesInNamespace(null, (Continuation<? super List<LookupElement>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (((CharSequence)account).length() == 0) {
                    return CollectionsKt.emptyList();
                }
                namespace = StringsKt.removeSuffix((String)account, (CharSequence)"/");
                if (StringsKt.contains$default((CharSequence)namespace, (char)'/', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)namespace, (char)'$', (boolean)false, (int)2, null)) {
                    return CollectionsKt.emptyList();
                }
                try {
                    var5_7 = InternalUtilsKt.addQueryParameter(new URI("https://hub.docker.com/v2/repositories/" + namespace), "page_size", "200");
                }
                catch (URISyntaxException e) {
                    return CollectionsKt.emptyList();
                }
                url = var5_7;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)account);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)namespace);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.label = 1;
                v0 = HttpRequestExecutorKt.httpGet$default(this.client, (URI)url, null, (Continuation)$continuation, 2, null);
                if (v0 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                url = (URI)$continuation.L$2;
                namespace = (String)$continuation.L$1;
                account = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                e = (String)v0;
                $i$f$mapJsonTo = false;
                $i$f$jacksonTypeRef = false;
                var5_7 = ((DockerHubRepository.SinglePage)DockerJsonUtilsKt.mapJsonTo$default((String)$this$mapJsonTo$iv, (TypeReference)new TypeReference<DockerHubRepository.SinglePage>(){}, null, 2, null)).getResults();
                if (var5_7 != null) {
                    $i$f$mapJsonTo = var5_7;
                    $i$f$map = false;
                    var9_14 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_19 = (DockerHubRepository)item$iv$iv;
                        var16_21 = destination$iv$iv;
                        $i$a$-map-DockerSearch$listRepositoriesInNamespace$2 = false;
                        var16_21.add(p0.toDockerSearchResult());
                    }
                    v1 = (List)destination$iv$iv;
                } else {
                    v1 = CollectionsKt.emptyList();
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object listImageTags(String imageFqn, String oauthToken, Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listImageTags.2)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerSearch.access$listImageTags(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var5_7 = new URI("https://registry-1.docker.io/v2/" + imageFqn + "/tags/list");
                }
                catch (URISyntaxException <unused var>) {
                    return CollectionsKt.emptyList();
                }
                uri = var5_7;
                var7_11 = <unused var> = MapsKt.createMapBuilder();
                var17_14 = uri;
                var16_15 = this.client;
                $i$a$-buildMap-DockerSearch$listImageTags$3 = false;
                $this$listImageTags_u24lambda_u240.put("Accept", "application/json");
                $this$listImageTags_u24lambda_u240.put("Authorization", "Bearer " + oauthToken);
                var18_17 = Unit.INSTANCE;
                $continuation.L$0 = imageFqn;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oauthToken);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.label = 1;
                v0 = HttpRequestExecutorKt.httpGet((HttpRequestExecutor)var16_15, var17_14, MapsKt.build((Map)<unused var>), (Continuation<? super String>)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl43
            }
            case 1: {
                uri = (URI)$continuation.L$2;
                oauthToken = (String)$continuation.L$1;
                imageFqn = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl43:
                // 2 sources

                <unused var> = (String)v0;
                $i$f$mapJsonTo = false;
                $i$f$jacksonTypeRef = false;
                var5_7 = ((TagListV2)DockerJsonUtilsKt.mapJsonTo$default((String)$this$mapJsonTo$iv, (TypeReference)new TypeReference<TagListV2>(){}, null, 2, null)).getTags();
                if (var5_7 != null) {
                    $i$f$mapJsonTo = var5_7;
                    $i$f$map = false;
                    var9_18 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_23 = (String)item$iv$iv;
                        var16_15 = destination$iv$iv;
                        $i$a$-map-DockerSearch$listImageTags$4 = false;
                        var16_15.add(new LookupElement(StringsKt.removePrefix((String)imageFqn, (CharSequence)"library/") + ":" + (String)tag, null, LookupElement.Kind.TAG));
                    }
                    v1 = (List)destination$iv$iv;
                } else {
                    v1 = CollectionsKt.emptyList();
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> listLibraryImages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLibraryImages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DockerHubRepository dockerHubRepository = (DockerHubRepository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toDockerSearchResult());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final Object listImageDigests(String imageFqn, String tag, String oauthToken, Continuation<? super List<LookupElement>> $completion) {
        if (!($completion instanceof listImageDigests.2)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DockerSearch this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerSearch.access$listImageDigests(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var6_8 = new URI("https://registry-1.docker.io/v2/" + imageFqn + "/manifests/" + tag);
                }
                catch (URISyntaxException <unused var>) {
                    return CollectionsKt.emptyList();
                }
                uri = var6_8;
                <unused var> = var6_8 = MapsKt.createMapBuilder();
                var20_12 = uri;
                var19_13 = this.client;
                $i$a$-buildMap-DockerSearch$listImageDigests$3 = false;
                $this$listImageDigests_u24lambda_u240.put("Accept", "application/vnd.oci.image.index.v1+json,application/vnd.docker.distribution.manifest.list.v2+json,application/vnd.oci.image.manifest.v1+json,application/vnd.docker.distribution.manifest.v2+json");
                $this$listImageDigests_u24lambda_u240.put("Authorization", "Bearer " + oauthToken);
                var21_15 = Unit.INSTANCE;
                $continuation.L$0 = imageFqn;
                $continuation.L$1 = tag;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)oauthToken);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.label = 1;
                v0 = HttpRequestExecutorKt.httpGetWithHeaders(var19_13, var20_12, MapsKt.build((Map)var6_8), (Continuation<? super HttpRequestExecutor.ResponseWithHeaders>)$continuation);
                if (v0 == var24_7) {
                    return var24_7;
                }
                ** GOTO lbl45
            }
            case 1: {
                uri = (URI)$continuation.L$3;
                oauthToken = (String)$continuation.L$2;
                tag = (String)$continuation.L$1;
                imageFqn = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                it = (HttpRequestExecutor.ResponseWithHeaders)v0;
                $i$a$-let-DockerSearch$listImageDigests$4 = false;
                var9_16 = (String)CollectionsKt.firstOrNull(it.header("Content-Type"));
                if (var9_16 == null) ** GOTO lbl66
                switch (var9_16.hashCode()) {
                    case -1585366650: {
                        if (var9_16.equals("application/vnd.oci.image.manifest.v1+json")) break;
                        ** break;
                    }
                    case 1275881109: {
                        if (var9_16.equals("application/vnd.docker.distribution.manifest.v2+json")) break;
                        ** break;
                    }
                    case -1504499703: {
                        if (!var9_16.equals("application/vnd.docker.distribution.manifest.list.v2+json")) {
                            ** break;
                        }
                        ** GOTO lbl62
                    }
                    case -2112740433: {
                        if (!var9_16.equals("application/vnd.oci.image.index.v1+json")) ** break;
lbl62:
                        // 2 sources

                        v1 = this.extractDigestsFromResponseBody(it);
                        ** GOTO lbl67
                    }
                }
                v1 = this.extractDigestsFromHeaders(it);
                ** GOTO lbl67
lbl66:
                // 6 sources

                v1 = CollectionsKt.emptyList();
lbl67:
                // 3 sources

                var9_16 = v1;
                $i$f$map = false;
                var11_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_23 = (String)item$iv$iv;
                    var17_24 = destination$iv$iv;
                    $i$a$-map-DockerSearch$listImageDigests$4$1 = false;
                    var17_24.add(new LookupElement(StringsKt.removePrefix((String)imageFqn, (CharSequence)"library/") + ":" + tag + "@" + (String)digest, null, LookupElement.Kind.DIGEST));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> extractDigestsFromResponseBody(HttpRequestExecutor.ResponseWithHeaders response) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        String $this$mapJsonTo$iv = response.getContent();
        boolean $i$f$mapJsonTo = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Iterable $this$filterNot$iv = ((ManifestList)DockerJsonUtilsKt.mapJsonTo$default($this$mapJsonTo$iv, (TypeReference)new TypeReference<ManifestList>(){}, null, 2, null)).getManifests();
        boolean $i$f$filterNot = false;
        Iterable $i$f$jacksonTypeRef22 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Manifest it = (Manifest)element$iv$iv;
            boolean bl = false;
            if (this.isAttestationManifest(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Manifest it = (Manifest)element$iv$iv;
            boolean bl2 = false;
            if (it.getDigest() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAttestationManifest(Manifest manifest) {
        ManifestPlatform manifestPlatform = manifest.getPlatform();
        if (Intrinsics.areEqual((Object)(manifestPlatform != null ? manifestPlatform.getArchitecture() : null), (Object)"unknown")) return true;
        ManifestPlatform manifestPlatform2 = manifest.getPlatform();
        if (!Intrinsics.areEqual((Object)(manifestPlatform2 != null ? manifestPlatform2.getOs() : null), (Object)"unknown")) return false;
        return true;
    }

    private final List<String> extractDigestsFromHeaders(HttpRequestExecutor.ResponseWithHeaders response) {
        return response.header(DOCKER_CONTENT_DIGEST_HEADER);
    }

    private static final DockerOauthHelper oauth_delegate$lambda$0(DockerSearch this$0) {
        return new DockerOauthHelper(null, this$0.client, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List libraryImages_delegate$lambda$0() {
        List result2 = new ArrayList();
        Object[] objectArray = new String[]{"/hub/docker-hub-library.page1.json", "/hub/docker-hub-library.page2.json"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            URL next;
            Object object;
            URL uRL;
            String it = (String)element$iv;
            boolean bl = false;
            try {
                DockerHubRepository.SinglePage singlePage;
                uRL = DockerSearch.class.getResource(it);
                if (uRL != null) {
                    void $this$mapJsonTo$iv;
                    Object object2 = uRL;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object2);
                    object2 = new String(byArray, charset);
                    boolean $i$f$mapJsonTo = false;
                    boolean $i$f$jacksonTypeRef = false;
                    singlePage = (DockerHubRepository.SinglePage)DockerJsonUtilsKt.mapJsonTo$default((String)$this$mapJsonTo$iv, (TypeReference)new TypeReference<DockerHubRepository.SinglePage>(){}, null, 2, null);
                } else {
                    singlePage = null;
                }
                uRL = singlePage;
            }
            catch (IOException e) {
                LOG.error("Can't read bundled resource: " + it, (Throwable)e);
                uRL = null;
            }
            result2.addAll((object = (next = uRL)) != null && (object = ((DockerHubRepository.SinglePage)object).getResults()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        }
        return result2;
    }

    public static final /* synthetic */ Object access$listImageTags(DockerSearch $this, String imageFqn, String oauthToken, Continuation $completion) {
        return $this.listImageTags(imageFqn, oauthToken, (Continuation<? super List<LookupElement>>)$completion);
    }

    public static final /* synthetic */ Object access$listImageDigests(DockerSearch $this, String imageFqn, String tag, String oauthToken, Continuation $completion) {
        return $this.listImageDigests(imageFqn, tag, oauthToken, (Continuation<? super List<LookupElement>>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DockerSearch.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "LIBRARY", "", "ACCEPT_HEADER", "AUTHORIZATION_HEADER", "CONTENT_TYPE_HEADER", "DOCKER_CONTENT_DIGEST_HEADER", "OCI_IMAGE_INDEX_CONTENT_TYPE", "OCI_IMAGE_MANIFEST_CONTENT_TYPE", "DOCKER_MANIFEST_LIST_CONTENT_TYPE", "DOCKER_MANIFEST_CONTENT_TYPE", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$DockerDistributionManifestV2;", "", "<init>", "()V", "intellij.clouds.docker.agent"})
    private static final class DockerDistributionManifestV2 {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement;", "", "lookupText", "", "description", "kind", "Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement$Kind;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement$Kind;)V", "getLookupText", "()Ljava/lang/String;", "getDescription", "getKind", "()Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement$Kind;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Kind", "Companion", "intellij.clouds.docker.agent"})
    public static final class LookupElement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String lookupText;
        @Nullable
        private final String description;
        @NotNull
        private final Kind kind;
        @NotNull
        public static final String DEFAULT_NAMESPACE = "library";

        public LookupElement(@NotNull String lookupText, @Nullable String description, @NotNull Kind kind) {
            Intrinsics.checkNotNullParameter((Object)lookupText, (String)"lookupText");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.lookupText = lookupText;
            this.description = description;
            this.kind = kind;
        }

        @NotNull
        public final String getLookupText() {
            return this.lookupText;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final String component1() {
            return this.lookupText;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final Kind component3() {
            return this.kind;
        }

        @NotNull
        public final LookupElement copy(@NotNull String lookupText, @Nullable String description, @NotNull Kind kind) {
            Intrinsics.checkNotNullParameter((Object)lookupText, (String)"lookupText");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return new LookupElement(lookupText, description, kind);
        }

        public static /* synthetic */ LookupElement copy$default(LookupElement lookupElement, String string, String string2, Kind kind, int n, Object object) {
            if ((n & 1) != 0) {
                string = lookupElement.lookupText;
            }
            if ((n & 2) != 0) {
                string2 = lookupElement.description;
            }
            if ((n & 4) != 0) {
                kind = lookupElement.kind;
            }
            return lookupElement.copy(string, string2, kind);
        }

        @NotNull
        public String toString() {
            return "LookupElement(lookupText=" + this.lookupText + ", description=" + this.description + ", kind=" + this.kind + ")";
        }

        public int hashCode() {
            int result2 = this.lookupText.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LookupElement)) {
                return false;
            }
            LookupElement lookupElement = (LookupElement)other;
            if (!Intrinsics.areEqual((Object)this.lookupText, (Object)lookupElement.lookupText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)lookupElement.description)) {
                return false;
            }
            return this.kind == lookupElement.kind;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement$Companion;", "", "<init>", "()V", "DEFAULT_NAMESPACE", "", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "NAMESPACE", "IMAGE", "TAG", "DIGEST", "intellij.clouds.docker.agent"})
        public static final class Kind
        extends Enum<Kind> {
            public static final /* enum */ Kind NAMESPACE = new Kind();
            public static final /* enum */ Kind IMAGE = new Kind();
            public static final /* enum */ Kind TAG = new Kind();
            public static final /* enum */ Kind DIGEST = new Kind();
            private static final /* synthetic */ Kind[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Kind[] values() {
                return (Kind[])$VALUES.clone();
            }

            public static Kind valueOf(String value) {
                return Enum.valueOf(Kind.class, value);
            }

            @NotNull
            public static EnumEntries<Kind> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = kindArray = new Kind[]{Kind.NAMESPACE, Kind.IMAGE, Kind.TAG, Kind.DIGEST};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$Manifest;", "", "<init>", "()V", "digest", "", "getDigest", "()Ljava/lang/String;", "setDigest", "(Ljava/lang/String;)V", "platform", "Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestPlatform;", "getPlatform", "()Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestPlatform;", "setPlatform", "(Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestPlatform;)V", "intellij.clouds.docker.agent"})
    private static final class Manifest {
        @JsonProperty(value="digest")
        @Nullable
        private String digest;
        @JsonProperty(value="platform")
        @Nullable
        private ManifestPlatform platform;

        @Nullable
        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(@Nullable String string) {
            this.digest = string;
        }

        @Nullable
        public final ManifestPlatform getPlatform() {
            return this.platform;
        }

        public final void setPlatform(@Nullable ManifestPlatform manifestPlatform) {
            this.platform = manifestPlatform;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestList;", "", "<init>", "()V", "manifests", "", "Lcom/intellij/docker/agent/image/search/DockerSearch$Manifest;", "getManifests", "()Ljava/util/List;", "setManifests", "(Ljava/util/List;)V", "intellij.clouds.docker.agent"})
    private static final class ManifestList {
        @JsonProperty(value="manifests")
        @NotNull
        private List<Manifest> manifests = CollectionsKt.emptyList();

        @NotNull
        public final List<Manifest> getManifests() {
            return this.manifests;
        }

        public final void setManifests(@NotNull List<Manifest> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.manifests = list;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestPlatform;", "", "<init>", "()V", "architecture", "", "getArchitecture", "()Ljava/lang/String;", "setArchitecture", "(Ljava/lang/String;)V", "os", "getOs", "setOs", "Companion", "intellij.clouds.docker.agent"})
    private static final class ManifestPlatform {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JsonProperty(value="architecture")
        @Nullable
        private String architecture;
        @JsonProperty(value="os")
        @Nullable
        private String os;
        @NotNull
        public static final String UNKNOWN_VALUE = "unknown";

        @Nullable
        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(@Nullable String string) {
            this.architecture = string;
        }

        @Nullable
        public final String getOs() {
            return this.os;
        }

        public final void setOs(@Nullable String string) {
            this.os = string;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$ManifestPlatform$Companion;", "", "<init>", "()V", "UNKNOWN_VALUE", "", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001a\u001a\u00020\u001bR \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R \u0010\u0017\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0007\"\u0004\b\u0019\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "starCount", "", "getStarCount", "()I", "setStarCount", "(I)V", "isOfficial", "", "()Z", "setOfficial", "(Z)V", "isTrusted", "setTrusted", "description", "getDescription", "setDescription", "toDockerSearchResult", "Lcom/intellij/docker/agent/image/search/DockerSearch$LookupElement;", "SinglePage", "intellij.clouds.docker.agent"})
    private static final class SearchResultV1 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="star_count")
        private int starCount;
        @JsonProperty(value="is_official")
        private boolean isOfficial;
        @JsonProperty(value="is_trusted")
        private boolean isTrusted;
        @JsonProperty(value="description")
        @Nullable
        private String description;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        public final int getStarCount() {
            return this.starCount;
        }

        public final void setStarCount(int n) {
            this.starCount = n;
        }

        public final boolean isOfficial() {
            return this.isOfficial;
        }

        public final void setOfficial(boolean bl) {
            this.isOfficial = bl;
        }

        public final boolean isTrusted() {
            return this.isTrusted;
        }

        public final void setTrusted(boolean bl) {
            this.isTrusted = bl;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @NotNull
        public final LookupElement toDockerSearchResult() {
            String string = this.name;
            if (string == null) {
                string = "";
            }
            return new LookupElement(string, this.description, LookupElement.Kind.IMAGE);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001e\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR \u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1$SinglePage;", "", "<init>", "()V", "pagesCount", "", "getPagesCount", "()I", "setPagesCount", "(I)V", "totalCount", "getTotalCount", "setTotalCount", "page", "getPage", "setPage", "pageSize", "getPageSize", "setPageSize", "query", "", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "results", "", "Lcom/intellij/docker/agent/image/search/DockerSearch$SearchResultV1;", "getResults", "()Ljava/util/List;", "setResults", "(Ljava/util/List;)V", "intellij.clouds.docker.agent"})
        public static final class SinglePage {
            @JsonProperty(value="num_pages")
            private int pagesCount;
            @JsonProperty(value="num_results")
            private int totalCount;
            @JsonProperty(value="page")
            private int page;
            @JsonProperty(value="page_size")
            private int pageSize;
            @JsonProperty(value="query")
            @Nullable
            private String query;
            @JsonProperty(value="results")
            @Nullable
            private List<SearchResultV1> results;

            public final int getPagesCount() {
                return this.pagesCount;
            }

            public final void setPagesCount(int n) {
                this.pagesCount = n;
            }

            public final int getTotalCount() {
                return this.totalCount;
            }

            public final void setTotalCount(int n) {
                this.totalCount = n;
            }

            public final int getPage() {
                return this.page;
            }

            public final void setPage(int n) {
                this.page = n;
            }

            public final int getPageSize() {
                return this.pageSize;
            }

            public final void setPageSize(int n) {
                this.pageSize = n;
            }

            @Nullable
            public final String getQuery() {
                return this.query;
            }

            public final void setQuery(@Nullable String string) {
                this.query = string;
            }

            @Nullable
            public final List<SearchResultV1> getResults() {
                return this.results;
            }

            public final void setResults(@Nullable List<SearchResultV1> list) {
                this.results = list;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/image/search/DockerSearch$TagListV2;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "tags", "", "getTags", "()Ljava/util/List;", "setTags", "(Ljava/util/List;)V", "intellij.clouds.docker.agent"})
    private static final class TagListV2 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="tags")
        @Nullable
        private List<String> tags;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final List<String> getTags() {
            return this.tags;
        }

        public final void setTags(@Nullable List<String> list) {
            this.tags = list;
        }
    }
}

