/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithOrdinalityClause;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlExplicitTableExpressionWithOrdinalityBase
extends SqlExplicitTableExpressionImpl {
    public SqlExplicitTableExpressionWithOrdinalityBase(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    protected Dbms getDbms() {
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this);
        if (dbms == null) {
            SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = this.getDasTypeWithCaching();
        if (dasType == null) {
            SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(2);
        }
        return dasType;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        DasType type = this.getDasTypeWithoutOrdinality();
        if (!(type instanceof SqlTableType)) {
            DasType dasType = type;
            if (dasType == null) {
                SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(3);
            }
            return dasType;
        }
        SqlTableType tableType2 = (SqlTableType)type;
        SqlTypedDefinition ordinality = this.getOrdinalityColumn();
        if (ordinality != null) {
            tableType2 = tableType2.add(new TableBasedSqlTableTypeImpl<SqlTypedDefinition>(Collections.singletonList(ordinality), (PsiElement)this.getTable()));
        }
        SqlTableType sqlTableType = tableType2;
        if (sqlTableType == null) {
            SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    @NotNull
    protected DasType getDasTypeWithoutOrdinality() {
        DasType dasType = super.getDasType();
        if (dasType == null) {
            SqlExplicitTableExpressionWithOrdinalityBase.$$$reportNull$$$0(5);
        }
        return dasType;
    }

    @NotNull
    protected abstract PsiTable getTable();

    @Nullable
    private SqlTypedDefinition getOrdinalityColumn() {
        return (SqlTypedDefinition)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcOrdinalityColumn(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlTypedDefinition calcOrdinalityColumn() {
        SqlWithOrdinalityClause ordinality = this.findChildByClass(SqlWithOrdinalityClause.class);
        if (ordinality == null) {
            return null;
        }
        return new OrdinalityColumn(this.getTable(), ordinality);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeWithoutOrdinality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private class OrdinalityColumn
    extends FakeDefinition
    implements SqlTypedDefinition {
        private final SqlWithOrdinalityClause myClause;

        protected OrdinalityColumn(PsiTable table, SqlWithOrdinalityClause clause) {
            super((PsiElement)table);
            this.myClause = clause;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            SqlDefinition ordinalityDefinition = this.myClause.getAliasDefinition();
            if (ordinalityDefinition != null) {
                String string = ordinalityDefinition.getName();
                if (string == null) {
                    OrdinalityColumn.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = this.myClause.getLastChild().getText();
            if (string == null) {
                OrdinalityColumn.$$$reportNull$$$0(1);
            }
            return string;
        }

        public DasObject getDasParent() {
            return (PsiTable)this.getParent();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                OrdinalityColumn.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = SqlImplUtil.getTypeSystem((PsiElement)this.myClause).getIntType();
            if (dasType == null) {
                OrdinalityColumn.$$$reportNull$$$0(3);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlDefinition definition = this.myClause.getAliasDefinition();
            Object object = definition != null ? definition : this.myClause;
            if (object == null) {
                OrdinalityColumn.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$OrdinalityColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        protected FakeDefinition(PsiElement parent) {
            super(parent);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlExplicitTableExpressionWithOrdinalityBase.this.getDbms();
            if (dbms == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        private SqlExplicitTableExpressionWithOrdinalityBase getOuter() {
            SqlExplicitTableExpressionWithOrdinalityBase sqlExplicitTableExpressionWithOrdinalityBase = SqlExplicitTableExpressionWithOrdinalityBase.this;
            if (sqlExplicitTableExpressionWithOrdinalityBase == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            return sqlExplicitTableExpressionWithOrdinalityBase;
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted((SqlNameElement)this.getNameElement());
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @NotNull
        public String getName() {
            SqlNameElement nameElement = this.getNameElement();
            String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String getTypeName() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DbPresentationCore.getIcon((DasObject)this);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        public boolean isPlainIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement == null || nameElement.isPlainIdentifier();
        }

        public boolean isQuotedIdentifier() {
            SqlNameElement nameElement = this.getNameElement();
            return nameElement != null && nameElement.isQuotedIdentifier();
        }

        public void accept(SqlVisitor visitor2) {
        }

        public void acceptChildren(SqlVisitor visitor2) {
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            SqlNameElement nameElement;
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            if ((nameElement = this.getNameElement()) != null) {
                nameElement.setName(name);
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.getOuter();
        }

        public boolean isEquivalentTo(PsiElement another) {
            return another != null && another.getClass().equals(((Object)((Object)this)).getClass()) && this.getOuter().equals((Object)((FakeDefinition)another).getOuter());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FakeDefinition definition = (FakeDefinition)((Object)o);
            return this.getOuter().equals((Object)definition.getOuter());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getOuter()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$FakeDefinition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOuter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlExplicitTableExpressionWithOrdinalityBase$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

