/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.properties;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringPropertiesUtil {
    private SpringPropertiesUtil() {
    }

    @Nullable
    public static BeanProperty getBeanProperty(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        return SpringPropertiesUtil.getBeanProperty(editor, file);
    }

    @Nullable
    public static BeanProperty getBeanProperty(Editor editor, PsiFile file) {
        if (editor != null && file instanceof XmlFile) {
            PsiElement psiElement;
            int offset = editor.getCaretModel().getOffset();
            DomElement value = DomUtil.getContextElement((Editor)editor);
            SpringPropertyDefinition property = (SpringPropertyDefinition)DomUtil.getParentOfType((DomElement)value, SpringPropertyDefinition.class, (boolean)false);
            if (property == null || SpringPropertiesUtil.isJavaBeanReference(file, offset)) {
                return null;
            }
            PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
            if (reference != null && (psiElement = reference.resolve()) instanceof PsiMethod && psiElement.getLanguage() == JavaLanguage.INSTANCE) {
                return BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)psiElement));
            }
        }
        return null;
    }

    @Nullable
    public static BeanProperty getBeanProperty(@NotNull PsiElement element) {
        PsiElement psiElement;
        PsiReference reference;
        SpringPropertyDefinition propertyDefinition;
        if (element == null) {
            SpringPropertiesUtil.$$$reportNull$$$0(0);
        }
        if ((propertyDefinition = (SpringPropertyDefinition)DomUtil.findDomElement((PsiElement)element, SpringPropertyDefinition.class, (boolean)false)) != null && !SpringPropertiesUtil.isJavaBeanReference(element) && (reference = element.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiMethod && psiElement.getLanguage() == JavaLanguage.INSTANCE) {
            return BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)psiElement));
        }
        return null;
    }

    private static boolean isJavaBeanReference(PsiFile file, int offset) {
        return SpringPropertiesUtil.isJavaBeanReference(PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), XmlAttribute.class));
    }

    private static boolean isJavaBeanReference(PsiElement psiElement) {
        Object attributeValue;
        GenericAttributeValue value;
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttribute.class);
        if (xmlAttribute != null && (value = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(xmlAttribute)) != null && (attributeValue = value.getValue()) instanceof SpringBeanPointer) {
            return ((SpringBeanPointer)attributeValue).getSpringBean() instanceof SpringJavaBean;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/properties/SpringPropertiesUtil", "getBeanProperty"));
    }
}

