/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.utils;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.javaee.web.WebUtil;
import com.intellij.jsp.javaee.web.codeInsight.daemon.analysis.encoding.JspEncodingInAttributeReferenceProvider;
import com.intellij.jsp.psi.BaseJspElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.CharTable;
import com.intellij.util.indexing.FileBasedIndex;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspWebUtil {
    private static final Logger LOG = Logger.getInstance(JspWebUtil.class);

    @Nullable
    public static String detectCharsetAsPerJspSpec(@NotNull VirtualFile jspFile, byte @NotNull [] content, @NotNull Language language) {
        if (jspFile == null) {
            JspWebUtil.$$$reportNull$$$0(0);
        }
        if (language == null) {
            JspWebUtil.$$$reportNull$$$0(1);
        }
        if (content == null) {
            JspWebUtil.$$$reportNull$$$0(2);
        }
        @NonNls String strContent = new String(content, StandardCharsets.ISO_8859_1);
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)jspFile);
        Charset charset = JspWebUtil.detectCharsetAsPerJspSpec(project, jspFile, strContent, language);
        return charset == null ? null : charset.name();
    }

    @Nullable
    public static Charset detectCharsetAsPerJspSpec(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content, @NotNull Language language) {
        if (content == null) {
            JspWebUtil.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JspWebUtil.$$$reportNull$$$0(4);
        }
        return (Charset)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            Charset charset;
            if (project != null && project.isInitialized() && !project.isDisposed() && file != null && file.isValid() && !NoAccessDuringPsiEvents.isInsideEventProcessing() && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && (charset = JspWebUtil.detectCharsetFromWebXml(project, file)) != null) {
                return charset;
            }
            return JspWebUtil.detectCharsetFromDirectives(content, language);
        }));
    }

    @Nullable
    private static Charset detectCharsetFromDirectives(@NotNull CharSequence content, @NotNull Language language) {
        ParserDefinition definition;
        if (content == null) {
            JspWebUtil.$$$reportNull$$$0(5);
        }
        if (language == null) {
            JspWebUtil.$$$reportNull$$$0(6);
        }
        if ((definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)) == null) {
            LOG.error(language.getID());
            return null;
        }
        Lexer lexer = definition.createLexer(null);
        lexer.start(content);
        final Ref charsetNameRef = new Ref();
        CharTableImpl charTable = new CharTableImpl();
        while (lexer.getTokenType() != null) {
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == BaseJspElementType.JSP_DIRECTIVE) {
                ASTNode parsed = BaseJspElementType.JSP_DIRECTIVE.parse(LexerUtil.getTokenText((Lexer)lexer), (CharTable)charTable);
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project = projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                new DummyHolder(psiManager, (TreeElement)parsed, null, null, null, BaseJspElementType.JSP_DIRECTIVE.getLanguage());
                PsiElement psiElement = parsed.getPsi();
                assert (psiElement != null);
                psiElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (PsiReference reference : JspEncodingInAttributeReferenceProvider.getReferencesByElement((PsiElement)value)) {
                            XmlEncodingReference prev;
                            if (!(reference instanceof XmlEncodingReference)) continue;
                            XmlEncodingReference xmlRef = (XmlEncodingReference)reference;
                            if (reference.resolve() == null || (prev = (XmlEncodingReference)charsetNameRef.get()) != null && prev.compareTo(xmlRef) >= 0) continue;
                            charsetNameRef.set((Object)xmlRef);
                        }
                        super.visitXmlAttributeValue(value);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jsp/javaee/web/utils/JspWebUtil$1", "visitXmlAttributeValue"));
                    }
                });
            }
            lexer.advance();
        }
        XmlEncodingReference ref = (XmlEncodingReference)charsetNameRef.get();
        String name = ref == null ? null : ref.getCanonicalText();
        return CharsetToolkit.forName((String)name);
    }

    @Nullable
    private static Charset detectCharsetFromWebXml(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            JspWebUtil.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            JspWebUtil.$$$reportNull$$$0(8);
        }
        Ref result = new Ref();
        WebUtil.processMatchingJspGroups((Project)project, (VirtualFile)virtualFile, group -> {
            result.set((Object)CharsetToolkit.forName((String)((String)group.getPageEncoding().getValue())));
            return !result.isNull();
        });
        return (Charset)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jspFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsp/javaee/web/utils/JspWebUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetAsPerJspSpec";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetFromDirectives";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetFromWebXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

