/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.codeInsight.AddCustomMethodFix;
import com.intellij.httpClient.http.request.psi.HttpMethod;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpRequestCustomHttpMethodInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerProblem", "", "method", "Lcom/intellij/httpClient/http/request/psi/HttpMethod;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.restClient"})
public final class HttpRequestCustomHttpMethodInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new HttpVisitor(this, holder){
            final /* synthetic */ HttpRequestCustomHttpMethodInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitRequest(HttpRequest o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                HttpMethod $this$asSafely$iv = o.getMethod();
                boolean $i$f$asSafely = false;
                HttpMethod httpMethod = $this$asSafely$iv;
                if (!(httpMethod instanceof HttpMethod)) {
                    httpMethod = null;
                }
                if (httpMethod == null) {
                    return;
                }
                HttpMethod method = httpMethod;
                Project project = o.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (RequestExecutionSupport.All.allSupportedMethods(project).contains(method.getText())) {
                    return;
                }
                HttpRequestCustomHttpMethodInspection.access$registerProblem(this.this$0, method, this.$holder, (PsiElement)o);
                super.visitRequest(o);
            }
        };
    }

    private final void registerProblem(HttpMethod method, ProblemsHolder holder, PsiElement element) {
        String string = RestClientBundle.message("rest.client.request.inspection.add.custom.http.method", new Object[0]);
        TextRange textRange = method.getTextRangeInParent();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
        String string2 = method.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        localQuickFixArray[0] = new AddCustomMethodFix(element, string2);
        holder.registerProblem(element, string, ProblemHighlightType.WARNING, textRange, localQuickFixArray);
    }

    public static final /* synthetic */ void access$registerProblem(HttpRequestCustomHttpMethodInspection $this, HttpMethod method, ProblemsHolder holder, PsiElement element) {
        $this.registerProblem(method, holder, element);
    }
}

