/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public final class GroovySynchronizationOnVariableInitializedWithLiteralInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.synchronization.on.variable.ref.which.was.initialized.with.literal", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
            if (synchronizedStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (!(lock instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lock).resolve();
            if (referent instanceof GrVariable) {
                GrVariable variable = (GrVariable)referent;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer == null) {
                    return;
                }
                if (!(initializer instanceof GrLiteral)) {
                    return;
                }
                this.registerError(lock);
            } else if (referent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referent;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                if (!(initializer instanceof PsiLiteralExpression)) {
                    return;
                }
                this.registerError(lock);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synchronizedStatement", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizationOnVariableInitializedWithLiteralInspection$Visitor", "visitSynchronizedStatement"));
        }
    }
}

