/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;

public abstract class AbstractArgNamesInspection
extends AbstractAopInspection {
    @Override
    protected void checkAopMethod(PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator != null) {
            this.checkAnnotation(pointcutMethod.getParameterList().getParameters(), holder, manipulator, pointcutMethod);
        }
    }

    @Override
    protected void checkElement(PsiElement element, ProblemsHolder holder) {
        super.checkElement(element, holder);
        for (AopProvider provider : AopProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            Pair<? extends ArgNamesManipulator, PsiMethod> pair = provider.getCustomArgNamesManipulator(element);
            if (pair == null) continue;
            PsiMethod method = (PsiMethod)pair.second;
            this.checkAnnotation(method.getParameterList().getParameters(), holder, (ArgNamesManipulator)pair.first, method);
        }
    }

    protected abstract void checkAnnotation(PsiParameter[] var1, ProblemsHolder var2, ArgNamesManipulator var3, PsiMethod var4);
}

