/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.util.JsPathUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u0007J\b\u0010'\u001a\u0004\u0018\u00010(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J\b\u0010*\u001a\u00020\u0007H\u0016J\u0013\u0010+\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR$\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace;", "", "pnpFile", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "workspaceRootDependency", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "libraryName", "", "<init>", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;Ljava/lang/String;)V", "getPnpFile", "()Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "getLibraryName", "()Ljava/lang/String;", "dependencies", "", "getDependencies", "()Ljava/util/List;", "nameToDependencyMap", "", "_workspaceList", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;", "allDependencies", "", "getAllDependencies", "()Ljava/util/Set;", "allDependencies$delegate", "Lkotlin/Lazy;", "location", "getLocation", "workspaceList", "getWorkspaceList", "()Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;", "setWorkspaceList", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;)V", "findDependencyByName", "dependencyName", "hasDirectOrIndirectDependency", "", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeAllDependencies", "toString", "equals", "other", "hashCode", "", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nYarnPnpWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpWorkspace.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1208#2,2:102\n1236#2,4:104\n1#3:108\n13#4:109\n*S KotlinDebug\n*F\n+ 1 YarnPnpWorkspace.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace\n*L\n21#1:102,2\n21#1:104,4\n76#1:109\n*E\n"})
public final class YarnPnpWorkspace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YarnPnpFile pnpFile;
    @NotNull
    private final YarnPnpDependency workspaceRootDependency;
    @NotNull
    private final String libraryName;
    @NotNull
    private final List<YarnPnpDependency> dependencies;
    @NotNull
    private final Map<String, YarnPnpDependency> nameToDependencyMap;
    private YarnPnpWorkspaceList _workspaceList;
    @NotNull
    private final Lazy allDependencies$delegate;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public YarnPnpWorkspace(@NotNull YarnPnpFile pnpFile, @NotNull YarnPnpDependency workspaceRootDependency, @NotNull String libraryName) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)pnpFile, (String)"pnpFile");
        Intrinsics.checkNotNullParameter((Object)workspaceRootDependency, (String)"workspaceRootDependency");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        this.pnpFile = pnpFile;
        this.workspaceRootDependency = workspaceRootDependency;
        this.libraryName = libraryName;
        this.dependencies = CollectionsKt.toList((Iterable)this.workspaceRootDependency.getChildren());
        Iterable iterable = this.dependencies;
        YarnPnpWorkspace yarnPnpWorkspace = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            YarnPnpDependency yarnPnpDependency = (YarnPnpDependency)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        yarnPnpWorkspace.nameToDependencyMap = destination$iv$iv;
        this.allDependencies$delegate = LazyKt.lazy(() -> YarnPnpWorkspace.allDependencies_delegate$lambda$0(this));
    }

    @NotNull
    public final YarnPnpFile getPnpFile() {
        return this.pnpFile;
    }

    @NotNull
    public final String getLibraryName() {
        return this.libraryName;
    }

    @NotNull
    public final List<YarnPnpDependency> getDependencies() {
        return this.dependencies;
    }

    private final Set<String> getAllDependencies() {
        Lazy lazy = this.allDependencies$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final String getLocation() {
        return this.workspaceRootDependency.getLocation();
    }

    @NotNull
    public final YarnPnpWorkspaceList getWorkspaceList() {
        YarnPnpWorkspaceList yarnPnpWorkspaceList = this._workspaceList;
        if (yarnPnpWorkspaceList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_workspaceList");
            yarnPnpWorkspaceList = null;
        }
        return yarnPnpWorkspaceList;
    }

    public final void setWorkspaceList(@NotNull YarnPnpWorkspaceList workspaceList) {
        Intrinsics.checkNotNullParameter((Object)workspaceList, (String)"workspaceList");
        if (!(this._workspaceList == null)) {
            boolean bl = false;
            String string = "workspaceList already set";
            throw new IllegalStateException(string.toString());
        }
        this._workspaceList = workspaceList;
    }

    @Nullable
    public final YarnPnpDependency findDependencyByName(@NotNull String dependencyName) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        return this.nameToDependencyMap.get(dependencyName);
    }

    public final boolean hasDirectOrIndirectDependency(@NotNull String dependencyName) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        return this.getAllDependencies().contains(dependencyName);
    }

    @Nullable
    public final VirtualFile findPackageJson() {
        return Companion.findPackageJson(this.getLocation());
    }

    private final Set<String> computeAllDependencies() {
        Set result2 = new LinkedHashSet();
        ArrayDeque queue = new ArrayDeque((Collection)this.dependencies);
        while (!((Collection)queue).isEmpty()) {
            YarnPnpDependency dependency = (YarnPnpDependency)queue.removeFirst();
            if (!result2.add(dependency)) continue;
            queue.addAll((Collection)dependency.getChildren());
        }
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)result2), YarnPnpWorkspace::computeAllDependencies$lambda$0));
    }

    @NotNull
    public String toString() {
        return "location=" + this.getLocation() + ", " + this.dependencies.size() + " deps=" + this.dependencies;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace");
        YarnPnpWorkspace cfr_ignored_0 = (YarnPnpWorkspace)object2;
        return Intrinsics.areEqual((Object)this.pnpFile, (Object)((YarnPnpWorkspace)other).pnpFile) && Intrinsics.areEqual((Object)this.getLocation(), (Object)((YarnPnpWorkspace)other).getLocation()) && Intrinsics.areEqual((Object)this.libraryName, (Object)((YarnPnpWorkspace)other).libraryName) && Intrinsics.areEqual(this.dependencies, ((YarnPnpWorkspace)other).dependencies);
    }

    public int hashCode() {
        int result2 = this.pnpFile.hashCode();
        result2 = 31 * result2 + this.getLocation().hashCode();
        result2 = 31 * result2 + this.libraryName.hashCode();
        result2 = 31 * result2 + ((Object)this.dependencies).hashCode();
        return result2;
    }

    private static final Set allDependencies_delegate$lambda$0(YarnPnpWorkspace this$0) {
        return this$0.computeAllDependencies();
    }

    private static final String computeAllDependencies$lambda$0(YarnPnpDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findPackageJson(@NotNull String workspaceLocation) {
        return Companion.findPackageJson(workspaceLocation);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Logger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildLibraryName", "", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "location", "getLocationPresentablePath", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "workspaceLocation", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String buildLibraryName(@NotNull Project project, @NotNull String location) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Shouldn't be invoked under read action");
            Object object = ActionsKt.runReadAction(() -> Companion.buildLibraryName$lambda$0(project, location));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            return (String)object;
        }

        private final String getLocationPresentablePath(Project project, String location) {
            Object object;
            block3: {
                block2: {
                    object = LocalFileSystem.getInstance().findFileByPath(location);
                    if (object == null) break block2;
                    VirtualFile it = object;
                    boolean bl = false;
                    String string = JsPathUtil.getPathRelativeToContentRoot(project, it, true);
                    object = string;
                    if (string != null) break block3;
                }
                String string = FileUtil.getLocationRelativeToUserHome((String)location);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
            }
            return object;
        }

        @JvmStatic
        @Nullable
        public final VirtualFile findPackageJson(@NotNull String workspaceLocation) {
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)workspaceLocation, (String)"workspaceLocation");
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(workspaceLocation);
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                virtualFile = PackageJsonUtil.findChildPackageJsonFile(it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        private static final String buildLibraryName$lambda$0(Project $project, String $location) {
            Object[] objectArray = new Object[]{Companion.getLocationPresentablePath($project, $location) + File.separator + "package.json"};
            return JavaScriptBundle.message((String)"yarn.pnp.library_name", (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

