/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil;", "", "<init>", "()V", "JEST_NAME_PARAMETERS", "", "", "TEMPLATE_PARAM_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parseEachPattern", "Lcom/intellij/javascript/testFramework/util/JSTestNamePattern;", "enclosingCallExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "value", "determineInjectionType", "Lcom/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil$InjectionType;", "methodExpression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "toPatternWithPositionalParams", "pattern", "name", "toPatternWithNamedParams", "InjectionType", "intellij.javascript.testing"})
@SourceDebugExtension(value={"SMAP\nJestTestNamePatternUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JestTestNamePatternUtil.kt\ncom/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1374#2:94\n1460#2,5:95\n1923#3,14:100\n*S KotlinDebug\n*F\n+ 1 JestTestNamePatternUtil.kt\ncom/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil\n*L\n45#1:94\n45#1:95,5\n63#1:100,14\n*E\n"})
public final class JestTestNamePatternUtil {
    @NotNull
    public static final JestTestNamePatternUtil INSTANCE = new JestTestNamePatternUtil();
    @NotNull
    private static final List<String> JEST_NAME_PARAMETERS;
    private static final Pattern TEMPLATE_PARAM_PATTERN;

    private JestTestNamePatternUtil() {
    }

    @NotNull
    public final JSTestNamePattern parseEachPattern(@NotNull JSCallExpression enclosingCallExpression, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)enclosingCallExpression, (String)"enclosingCallExpression");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.determineInjectionType(enclosingCallExpression.getMethodExpression()).ordinal()]) {
            case 1 -> this.toPatternWithNamedParams(value);
            case 2 -> this.toPatternWithPositionalParams(value);
            case 3 -> {
                JSTestNamePattern namedParamsPattern = this.toPatternWithNamedParams(value);
                yield this.toPatternWithPositionalParams(namedParamsPattern);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final InjectionType determineInjectionType(JSExpression methodExpression) {
        if (methodExpression instanceof ES6TaggedTemplateExpression) {
            return InjectionType.NAMED_PARAMS;
        }
        if (methodExpression instanceof JSCallExpression) {
            JSExpression[] jSExpressionArray = ((JSCallExpression)methodExpression).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
            Object object = ArraysKt.firstOrNull((Object[])jSExpressionArray);
            JSArrayLiteralExpression jSArrayLiteralExpression = object instanceof JSArrayLiteralExpression ? (JSArrayLiteralExpression)object : null;
            if (jSArrayLiteralExpression != null) {
                JSArrayLiteralExpression it = jSArrayLiteralExpression;
                boolean bl = false;
                if (it.getExpressionStream().allMatch(arg_0 -> JestTestNamePatternUtil.determineInjectionType$lambda$0$1(JestTestNamePatternUtil::determineInjectionType$lambda$0$0, arg_0))) {
                    return InjectionType.NAMED_PARAMS;
                }
                if (it.getExpressionStream().allMatch(arg_0 -> JestTestNamePatternUtil.determineInjectionType$lambda$0$3(JestTestNamePatternUtil::determineInjectionType$lambda$0$2, arg_0))) {
                    return InjectionType.POSITIONAL_PARAMS;
                }
            }
        }
        return InjectionType.UNSURE;
    }

    /*
     * WARNING - void declaration
     */
    private final JSTestNamePattern toPatternWithPositionalParams(JSTestNamePattern pattern) {
        void $this$flatMapTo$iv$iv;
        List<JSTestNamePattern.Range> list = pattern.getRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRanges(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<JSTestNamePattern.Range> list2;
            JSTestNamePattern.Range it = (JSTestNamePattern.Range)element$iv$iv;
            boolean bl = false;
            if (it instanceof JSTestNamePattern.Literal) {
                String string = ((JSTestNamePattern.Literal)it).getLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
                List<JSTestNamePattern.Range> list3 = INSTANCE.toPatternWithPositionalParams(string).getRanges();
                Intrinsics.checkNotNull(list3);
                list2 = list3;
            } else {
                list2 = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List ranges = (List)destination$iv$iv;
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.normalizeAndCreate(ranges);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern, (String)"normalizeAndCreate(...)");
        return jSTestNamePattern;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSTestNamePattern toPatternWithPositionalParams(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List ranges = new ArrayList();
        Ref.IntRef ind = new Ref.IntRef();
        while (ind.element < name.length()) {
            Object v0;
            void $this$minByOrNull$iv;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)JEST_NAME_PARAMETERS), arg_0 -> JestTestNamePatternUtil.toPatternWithPositionalParams$lambda$1(name, ind, arg_0));
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    Pair it = (Pair)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = ((Number)it.getSecond()).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-minByOrNull-JestTestNamePatternUtil$toPatternWithPositionalParams$nextParam$2 = false;
                        int v$iv = ((Number)it2.getSecond()).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Pair nextParam = v0;
            if (nextParam == null) {
                String string = name.substring(ind.element);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                ranges.add(new JSTestNamePattern.Literal(string));
                break;
            }
            String string = name.substring(ind.element, ((Number)nextParam.getSecond()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            ranges.add(new JSTestNamePattern.Literal(string));
            ranges.add(new JSTestNamePattern.AnyText((String)nextParam.getFirst()));
            ind.element = ((Number)nextParam.getSecond()).intValue() + ((String)nextParam.getFirst()).length();
        }
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.normalizeAndCreate(ranges);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern, (String)"normalizeAndCreate(...)");
        return jSTestNamePattern;
    }

    @NotNull
    public final JSTestNamePattern toPatternWithNamedParams(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List ranges = new ArrayList();
        Matcher matcher = TEMPLATE_PARAM_PATTERN.matcher(name);
        int ind = 0;
        while (matcher.find()) {
            int start = matcher.start();
            String string = name.substring(ind, start);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            ranges.add(new JSTestNamePattern.Literal(string));
            ranges.add(new JSTestNamePattern.AnyText(matcher.group()));
            ind = matcher.end();
        }
        String string = name.substring(ind);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        ranges.add(new JSTestNamePattern.Literal(string));
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.normalizeAndCreate(ranges);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern, (String)"normalizeAndCreate(...)");
        return jSTestNamePattern;
    }

    private static final boolean determineInjectionType$lambda$0$0(JSExpression expr) {
        return expr instanceof JSObjectLiteralExpression;
    }

    private static final boolean determineInjectionType$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean determineInjectionType$lambda$0$2(JSExpression expr) {
        return expr instanceof JSArrayLiteralExpression;
    }

    private static final boolean determineInjectionType$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair toPatternWithPositionalParams$lambda$1(String $name, Ref.IntRef $ind, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int i = StringsKt.indexOf$default((CharSequence)$name, (String)it, (int)$ind.element, (boolean)false, (int)4, null);
        return i != -1 ? TuplesKt.to((Object)it, (Object)i) : null;
    }

    static {
        Object[] objectArray = new String[]{"%p", "%s", "%d", "%i", "%f", "%j", "%o", "%#", "%%"};
        JEST_NAME_PARAMETERS = CollectionsKt.listOf((Object[])objectArray);
        TEMPLATE_PARAM_PATTERN = Pattern.compile("\\$(?:#|\\{[\\w.]+}|[\\w.]+)");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil$InjectionType;", "", "<init>", "(Ljava/lang/String;I)V", "POSITIONAL_PARAMS", "NAMED_PARAMS", "UNSURE", "intellij.javascript.testing"})
    private static final class InjectionType
    extends Enum<InjectionType> {
        public static final /* enum */ InjectionType POSITIONAL_PARAMS = new InjectionType();
        public static final /* enum */ InjectionType NAMED_PARAMS = new InjectionType();
        public static final /* enum */ InjectionType UNSURE = new InjectionType();
        private static final /* synthetic */ InjectionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InjectionType[] values() {
            return (InjectionType[])$VALUES.clone();
        }

        public static InjectionType valueOf(String value) {
            return Enum.valueOf(InjectionType.class, value);
        }

        @NotNull
        public static EnumEntries<InjectionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = injectionTypeArray = new InjectionType[]{InjectionType.POSITIONAL_PARAMS, InjectionType.NAMED_PARAMS, InjectionType.UNSURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InjectionType.values().length];
            try {
                nArray[InjectionType.NAMED_PARAMS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InjectionType.POSITIONAL_PARAMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InjectionType.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

