/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.thirdparty;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LombokCopyableAnnotations {
    BASE_COPYABLE(LombokUtils.BASE_COPYABLE_ANNOTATIONS),
    COPY_TO_GETTER(LombokUtils.COPY_TO_GETTER_ANNOTATIONS),
    COPY_TO_SETTER(LombokUtils.COPY_TO_SETTER_ANNOTATIONS),
    COPY_TO_BUILDER_SINGULAR_SETTER(LombokUtils.COPY_TO_BUILDER_SINGULAR_SETTER_ANNOTATIONS),
    JACKSON_COPY_TO_BUILDER(LombokUtils.JACKSON_COPY_TO_BUILDER_ANNOTATIONS);

    private final Map<String, Set<String>> shortNames;

    private LombokCopyableAnnotations(String[] fqns) {
        this.shortNames = new HashMap<String, Set<String>>(fqns.length);
        for (String fqn : fqns) {
            String shortName = StringUtil.getShortName((String)fqn);
            this.shortNames.computeIfAbsent(shortName, __ -> new HashSet(5)).add(fqn);
        }
    }

    public static void copyOnXAnnotations(@Nullable PsiAnnotation processedAnnotation, @NotNull PsiModifierList modifierList, @NotNull String onXParameterName) {
        if (modifierList == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(0);
        }
        if (onXParameterName == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(1);
        }
        if (processedAnnotation == null) {
            return;
        }
        Iterable<String> annotationsToAdd = LombokProcessorUtil.getOnX(processedAnnotation, onXParameterName);
        annotationsToAdd.forEach(arg_0 -> ((PsiModifierList)modifierList).addAnnotation(arg_0));
    }

    @NotNull
    public List<PsiAnnotation> collectCopyableAnnotations(@NotNull PsiModifierListOwner psiFromElement, @Nullable PsiClass containingClass) {
        Object[] fieldAnnotations;
        if (psiFromElement == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(2);
        }
        if (0 == (fieldAnnotations = psiFromElement.getAnnotations()).length) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                LombokCopyableAnnotations.$$$reportNull$$$0(3);
            }
            return list;
        }
        HashSet<String> annotationNames = new HashSet<String>();
        Set existedShortAnnotationNames = ContainerUtil.map2Set((Object[])fieldAnnotations, PsiAnnotationSearchUtil::getShortNameOf);
        for (String shortName : existedShortAnnotationNames) {
            Set<String> fqns = this.shortNames.get(shortName);
            if (fqns == null) continue;
            annotationNames.addAll(fqns);
        }
        if (BASE_COPYABLE.equals((Object)this) && null != containingClass) {
            Collection<String> configuredCopyableAnnotations = ConfigDiscovery.getInstance().getMultipleValueLombokConfigProperty(ConfigKey.COPYABLE_ANNOTATIONS, containingClass);
            for (String fqn : configuredCopyableAnnotations) {
                if (!existedShortAnnotationNames.contains(StringUtil.getShortName((String)fqn))) continue;
                annotationNames.add(fqn);
            }
        }
        if (annotationNames.isEmpty()) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                LombokCopyableAnnotations.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (Object annotation : fieldAnnotations) {
            if (!PsiAnnotationSearchUtil.checkAnnotationHasOneOfFQNs((PsiAnnotation)annotation, annotationNames)) continue;
            result.add((PsiAnnotation)annotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static <T extends PsiModifierListOwner & PsiMember> void copyCopyableAnnotations(@NotNull T fromPsiElement, @NotNull LombokLightModifierList toModifierList, @NotNull LombokCopyableAnnotations copyableAnnotations) {
        if (fromPsiElement == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(6);
        }
        if (toModifierList == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(7);
        }
        if (copyableAnnotations == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(8);
        }
        LombokCopyableAnnotations.copyCopyableAnnotations(fromPsiElement, ((PsiMember)fromPsiElement).getContainingClass(), toModifierList, copyableAnnotations);
    }

    public static void copyCopyableAnnotations(@NotNull PsiModifierListOwner fromPsiElement, @Nullable PsiClass containingClass, @NotNull LombokLightModifierList toModifierList, @NotNull LombokCopyableAnnotations copyableAnnotations) {
        if (fromPsiElement == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(9);
        }
        if (toModifierList == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(10);
        }
        if (copyableAnnotations == null) {
            LombokCopyableAnnotations.$$$reportNull$$$0(11);
        }
        List<PsiAnnotation> annotationsToAdd = copyableAnnotations.collectCopyableAnnotations(fromPsiElement, containingClass);
        annotationsToAdd.forEach(toModifierList::withAnnotation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onXParameterName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFromElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/thirdparty/LombokCopyableAnnotations";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPsiElement";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModifierList";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/thirdparty/LombokCopyableAnnotations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCopyableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyOnXAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectCopyableAnnotations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableAnnotations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

