/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteLogStdRedirector {
    private static boolean ourOutRedirected = false;

    public static void logStdOutAndErr() {
        if (ourOutRedirected) {
            return;
        }
        JdbcNativeUtil.logInfo("Will duplicate streams to log");
        Logger logger = Logger.getLogger("com.intellij.database.remote.Output");
        System.setOut(RemoteLogStdRedirector.createStdOutLoggerStream(logger));
        System.setErr(RemoteLogStdRedirector.createStdErrLoggerStream(logger));
        ourOutRedirected = true;
    }

    private static PrintStream createStdErrLoggerStream(@NotNull Logger logger) {
        if (logger == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(0);
        }
        return RemoteLogStdRedirector.createStdLoggerStream(logger, Level.WARNING, System.err, "sun.stderr.encoding");
    }

    private static PrintStream createStdOutLoggerStream(@NotNull Logger logger) {
        if (logger == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(1);
        }
        return RemoteLogStdRedirector.createStdLoggerStream(logger, Level.INFO, System.out, "sun.stdout.encoding");
    }

    @NotNull
    private static PrintStream createStdLoggerStream(@NotNull Logger logger, @NotNull Level level, @NotNull OutputStream original, @NotNull String charsetProp) {
        if (logger == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(2);
        }
        if (level == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(3);
        }
        if (original == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(4);
        }
        if (charsetProp == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(5);
        }
        Charset charset = RemoteLogStdRedirector.createCharset(charsetProp);
        OutputStreamLogger stream = new OutputStreamLogger(logger, level, charset, original);
        try {
            return new PrintStream((OutputStream)stream, true, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    private static Charset createCharset(String prop) {
        String csName = System.getProperty(prop);
        if (csName != null) {
            Charset charset;
            try {
                charset = Charset.forName(csName);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
            if (charset == null) {
                RemoteLogStdRedirector.$$$reportNull$$$0(6);
            }
            return charset;
        }
        Charset charset = Charset.defaultCharset();
        if (charset == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(7);
        }
        return charset;
    }

    @Nullable
    static StackTraceElement getCallerFrame() {
        StackTraceElement[] trace;
        for (StackTraceElement element : trace = new Throwable().getStackTrace()) {
            if (!element.getClassName().startsWith("java.util.logging")) continue;
            return null;
        }
        for (StackTraceElement element : trace) {
            if (RemoteLogStdRedirector.undesiredFrame(element)) continue;
            return element;
        }
        return trace.length == 0 ? null : trace[0];
    }

    private static boolean undesiredFrame(StackTraceElement element) {
        String cn = element.getClassName();
        return cn.startsWith("com.intellij.database.remote.jdbc.helpers.RemoteLogHelper") || cn.startsWith("com.intellij.database.remote.jdbc.helpers.RemoteLogStdRedirector") || cn.startsWith("java.io.PrintStream") || cn.startsWith("java.io.PrintWriter") || cn.startsWith("sun.nio.cs.StreamEncoder") || cn.startsWith("java.io.OutputStreamWriter") || cn.startsWith("java.sql.DriverManager") && element.getMethodName().startsWith("print") || cn.startsWith("com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil") && element.getMethodName().startsWith("log");
    }

    @NotNull
    static LogRecord createRecord(@NotNull Level level, @NotNull String text, @Nullable StackTraceElement frame) {
        if (level == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(8);
        }
        if (text == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(9);
        }
        LogRecord lr = new LogRecord(level, text);
        if (frame != null) {
            lr.setSourceClassName(frame.getClassName());
            lr.setSourceMethodName(frame.getMethodName());
        }
        LogRecord logRecord = lr;
        if (logRecord == null) {
            RemoteLogStdRedirector.$$$reportNull$$$0(10);
        }
        return logRecord;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetProp";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/RemoteLogStdRedirector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RemoteLogStdRedirector";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStdErrLoggerStream";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStdOutLoggerStream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStdLoggerStream";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRecord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OutputStreamLogger
    extends TeeOutputStream {
        private final Logger myLogger;
        private final Level myLevel;
        private final Charset myCharset;

        OutputStreamLogger(@NotNull Logger logger, @NotNull Level level, @NotNull Charset charset, @NotNull OutputStream originalStream) {
            if (logger == null) {
                OutputStreamLogger.$$$reportNull$$$0(0);
            }
            if (level == null) {
                OutputStreamLogger.$$$reportNull$$$0(1);
            }
            if (charset == null) {
                OutputStreamLogger.$$$reportNull$$$0(2);
            }
            if (originalStream == null) {
                OutputStreamLogger.$$$reportNull$$$0(3);
            }
            super(originalStream);
            this.myLogger = logger;
            this.myLevel = level;
            this.myCharset = charset;
        }

        @Override
        public synchronized void flush() throws IOException {
            this.tee();
            int size = this.size();
            if (size == 0) {
                return;
            }
            if (this.buf[size - 1] == 10 || this.buf[size - 1] == 13) {
                StackTraceElement desiredCaller = RemoteLogStdRedirector.getCallerFrame();
                if (desiredCaller == null) {
                    this.reset();
                    return;
                }
                String text = new String(this.buf, 0, size, this.myCharset);
                LogRecord lr = RemoteLogStdRedirector.createRecord(this.myLevel, text, desiredCaller);
                this.reset();
                this.myLogger.log(lr);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logger";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalStream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/RemoteLogStdRedirector$OutputStreamLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TeeOutputStream
    extends ByteArrayOutputStream {
        private final OutputStream myOriginalStream;
        private int myFlushedOffset;

        TeeOutputStream(@NotNull OutputStream originalStream) {
            if (originalStream == null) {
                TeeOutputStream.$$$reportNull$$$0(0);
            }
            super(10000);
            this.myOriginalStream = originalStream;
        }

        @Override
        public void flush() throws IOException {
            this.tee();
            this.reset();
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.myFlushedOffset = 0;
        }

        protected synchronized void tee() throws IOException {
            int size = this.size();
            if (this.myFlushedOffset != size) {
                this.myOriginalStream.write(this.buf, this.myFlushedOffset, size - this.myFlushedOffset);
                this.myFlushedOffset = size;
                this.myOriginalStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.myOriginalStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalStream", "com/intellij/database/remote/jdbc/helpers/RemoteLogStdRedirector$TeeOutputStream", "<init>"));
        }
    }
}

