/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ed.annotation;

import com.google.common.collect.Sets;
import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class JpaNumberFormatAnnotation
extends Annotation {
    public static final String NAME = "NumberFormat";
    public static final Set<Datatype> NUMERIC_DATATYPES = Sets.newHashSet((Object[])new Datatype[]{Datatypes.BasicDatatype.BigDecimal, Datatypes.BasicDatatype.Double, Datatypes.BasicDatatype.Integer, Datatypes.BasicDatatype.Long, Datatypes.BasicDatatype.PDouble});

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        if (attribute == null) {
            JpaNumberFormatAnnotation.$$$reportNull$$$0(0);
        }
        if (entity == null) {
            JpaNumberFormatAnnotation.$$$reportNull$$$0(1);
        }
        return NUMERIC_DATATYPES.contains(attribute.getType()) && (StringUtils.isNotBlank((CharSequence)attribute.getNumberFormat()) || attribute.getNumberFormatStyle() != null);
    }

    @Override
    @NotNull
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, Module module) {
        EntityAttribute.NumberFormatStyle numberFormatStyle;
        if (attribute == null) {
            JpaNumberFormatAnnotation.$$$reportNull$$$0(2);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)attribute.getNumberFormat())) {
            params.put("pattern", "\"" + attribute.getNumberFormat() + "\"");
        }
        if ((numberFormatStyle = attribute.getNumberFormatStyle()) != null && numberFormatStyle != EntityAttribute.NumberFormatStyle.DEFAULT) {
            params.put("style", "org.springframework.format.annotation.NumberFormat.Style." + String.valueOf((Object)numberFormatStyle));
        }
        LinkedHashMap<String, String> linkedHashMap = params;
        if (linkedHashMap == null) {
            JpaNumberFormatAnnotation.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    @Override
    public List<String> knownAttributes(EntityAttribute attribute) {
        return Arrays.asList("pattern", "style");
    }

    @Override
    public String getFqn(Project project, Module module) {
        return "org.springframework.format.annotation.NumberFormat";
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ed/annotation/JpaNumberFormatAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ed/annotation/JpaNumberFormatAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParams";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

