/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AnnotationDescriptor;
import com.intellij.jpa.jpb.model.util.AnnotationParser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioAnnotationUtil {
    public static Collection<String> getArrayAttributeValue(PsiAnnotation annotation, @Nullable String attributeName) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attributeName);
        List<Object> result = new ArrayList();
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            result = StudioAnnotationUtil.getArrayAttributeValue(attributeValue);
        } else if (attributeValue instanceof PsiLiteral) {
            result = StudioAnnotationUtil.processLiteralValue(attributeValue);
        }
        return result;
    }

    public static List<String> getArrayAttributeValue(PsiAnnotationMemberValue attributeValue) {
        ArrayList<String> result = new ArrayList<String>();
        for (PsiAnnotationMemberValue value : ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
            List<String> literalValue = StudioAnnotationUtil.processLiteralValue(value);
            if (literalValue == null) continue;
            result.addAll(literalValue);
        }
        return result;
    }

    private static List<String> processLiteralValue(PsiAnnotationMemberValue value) {
        AnnotationParser annotationParser = (AnnotationParser)AnnotationParser.Companion.getInstance((PsiElement)value);
        if (annotationParser != null) {
            return annotationParser.processLiteralValue(value);
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findJpbAnnotation(PsiModifierListOwner listOwner, AnnotationDescriptor ... descriptors) {
        Project project = listOwner.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)listOwner);
        for (AnnotationDescriptor descriptor : descriptors) {
            PsiAnnotation result = AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (String[])new String[]{descriptor.getFqn(project, module)});
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<PsiAnnotation> findAllJpbAnnotations(PsiModifierListOwner listOwner, AnnotationDescriptor ... descriptors) {
        Project project = listOwner.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)listOwner);
        List annotationFqns = ContainerUtil.map((Object[])descriptors, descriptor -> descriptor.getFqn(project, module));
        return AnnotationUtil.findAllAnnotations((PsiModifierListOwner)listOwner, (Collection)annotationFqns, (boolean)true);
    }

    public static List<PsiAnnotation> findAllJpbAnnotationsWithContainer(PsiModifierListOwner listOwner, AnnotationDescriptor containerDesc, AnnotationDescriptor annotationDesc) {
        List<PsiAnnotation> annotations = StudioAnnotationUtil.findAllJpbAnnotations(listOwner, annotationDesc);
        List<PsiAnnotation> containers = StudioAnnotationUtil.findAllJpbAnnotations(listOwner, containerDesc);
        if (!annotations.isEmpty() && !containers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!containers.isEmpty()) {
            Project project = listOwner.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)listOwner);
            return new ArrayList<PsiAnnotation>(StudioAnnotationUtil.getArrayValueAnnotations(containers.get(0), "value", annotationDesc.getFqn(project, module)));
        }
        return annotations;
    }

    public static boolean hasJpbAnnotation(PsiModifierListOwner listOwner, AnnotationDescriptor ... descriptors) {
        return StudioAnnotationUtil.findJpbAnnotation(listOwner, descriptors) != null;
    }

    @Nullable
    public static String getStringAttributeValue(PsiModifierListOwner listOwner, String annotationName, String attributeName) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (String[])new String[]{annotationName});
        return annotation == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)attributeName);
    }

    public static String getStringAttributeValue(@NotNull PsiAnnotation annotation, String name, String defaultValue) {
        String value;
        if (annotation == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(0);
        }
        return (value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)name)) != null ? value : defaultValue;
    }

    public static String getDeclaredStringAttributeValue(PsiModifierListOwner listOwner, AnnotationDescriptor descriptor, String attributeName) {
        PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation(listOwner, descriptor);
        return annotation == null ? null : AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)attributeName);
    }

    public static List<String> getDeclaredStringAttributeValues(PsiModifierListOwner listOwner, AnnotationDescriptor descriptor, String attributeName) {
        return ContainerUtil.map(StudioAnnotationUtil.findAllJpbAnnotations(listOwner, descriptor), annotation -> AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)attributeName));
    }

    @Nullable
    public static Long getDeclaredLongAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(1);
        }
        PsiAnnotationMemberValue attrValue = anno.findDeclaredAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance((Project)anno.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)attrValue);
        return constValue instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : null;
    }

    public static Long getDeclaredLongAttributeValue(PsiModifierListOwner modifierList, AnnotationDescriptor descriptor, String attributeName) {
        PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation(modifierList, descriptor);
        return annotation == null ? null : StudioAnnotationUtil.getDeclaredLongAttributeValue(annotation, attributeName);
    }

    @Nullable
    public static PsiAnnotation findAnnotationBySimpleName(@Nullable PsiModifierListOwner listOwner, @NotNull String simpleName) {
        if (simpleName == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(2);
        }
        if (listOwner == null) {
            return null;
        }
        for (PsiAnnotation psiAnnotation : listOwner.getAnnotations()) {
            String qualifiedName = psiAnnotation.getQualifiedName();
            if (StringUtils.isBlank((CharSequence)qualifiedName) || !simpleName.equals(ClassUtil.extractClassName((String)qualifiedName))) continue;
            return psiAnnotation;
        }
        return null;
    }

    public static String extractStringFromAnnotationAttrValue(PsiAnnotationMemberValue attrValue) {
        if (attrValue instanceof PsiLiteralExpression) {
            Object value = ((PsiLiteralExpression)attrValue).getValue();
            return value == null ? "" : value.toString();
        }
        return StreamEx.of((Object[])attrValue.getChildren()).select(PsiLiteralExpression.class).map(PsiLiteralValue::getValue).joining((CharSequence)"\n");
    }

    public static Collection<PsiAnnotation> getArrayValueAnnotations(@NotNull PsiAnnotation annotation, @NotNull String attrName, @Nullable String annotationFqn) {
        if (annotation == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (attrName == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(4);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attrName);
        if (attributeValue instanceof PsiAnnotation && (annotationFqn == null || annotationFqn.equals(((PsiAnnotation)attributeValue).getQualifiedName()))) {
            result.add((PsiAnnotation)attributeValue);
        } else if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            for (PsiAnnotationMemberValue initializer : ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                if (!(initializer instanceof PsiAnnotation) || annotationFqn != null && !annotationFqn.equals(((PsiAnnotation)initializer).getQualifiedName())) continue;
                result.add((PsiAnnotation)initializer);
            }
        }
        return result;
    }

    public static Collection<PsiAnnotation> getArrayValueAnnotations(@NotNull PsiAnnotation annotation, @NotNull String attrName) {
        if (annotation == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(5);
        }
        if (attrName == null) {
            StudioAnnotationUtil.$$$reportNull$$$0(6);
        }
        return StudioAnnotationUtil.getArrayValueAnnotations(annotation, attrName, null);
    }

    @Nullable
    public static Boolean getDeclaredBooleanAttributeValue(PsiAnnotation annotation, String ... attrNames) {
        for (String attrName : attrNames) {
            PsiAnnotationMemberValue attrValue;
            if (!StringUtils.isNotBlank((CharSequence)attrName) || (attrValue = annotation.findDeclaredAttributeValue(attrName)) == null) continue;
            Object constValue = JavaPsiFacade.getInstance((Project)annotation.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)attrValue);
            return constValue instanceof Boolean ? (Boolean)constValue : null;
        }
        return null;
    }

    @Nullable
    public static String getDeclaredEnumStringValue(PsiModifierListOwner listOwner, String annotationName, String attributeName) {
        PsiAnnotation inheritanceAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (String[])new String[]{annotationName});
        return inheritanceAnn == null ? null : StudioAnnotationUtil.getDeclaredEnumStringValue(inheritanceAnn, attributeName);
    }

    @Nullable
    public static String getDeclaredEnumStringValue(PsiModifierListOwner listOwner, AnnotationDescriptor annotationDescriptor, String attributeName) {
        Project project = listOwner.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)listOwner);
        return StudioAnnotationUtil.getDeclaredEnumStringValue(listOwner, annotationDescriptor.getFqn(project, module), attributeName);
    }

    @Nullable
    public static String getDeclaredEnumStringValue(PsiAnnotation annotation, String attrName) {
        PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue(attrName);
        return StudioAnnotationUtil.getEnumStringValue(attributeValue);
    }

    @Nullable
    public static String getEnumStringValue(PsiAnnotation annotation, String attrName) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attrName);
        return StudioAnnotationUtil.getEnumStringValue(attributeValue);
    }

    @Nullable
    private static String getEnumStringValue(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiReferenceExpression) {
            PsiElement resolvedElem = ((PsiReferenceExpression)attributeValue).resolve();
            return resolvedElem instanceof PsiEnumConstant ? ((PsiEnumConstant)resolvedElem).getName() : null;
        }
        if (attributeValue instanceof PsiLiteral) {
            String enumName = StringUtils.substringAfterLast((String)attributeValue.getText(), (String)".");
            if (enumName == null || enumName.isEmpty()) {
                enumName = attributeValue.getText();
            }
            return enumName;
        }
        return null;
    }

    @Nullable
    public static String getDeclaredEnumFqnValue(PsiAnnotation annotation, String attrName) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attrName);
        if (attributeValue instanceof PsiReferenceExpression) {
            PsiEnumConstant enumConstant;
            PsiClass containingClass;
            PsiElement resolvedElem = ((PsiReferenceExpression)attributeValue).resolve();
            if (resolvedElem instanceof PsiEnumConstant && (containingClass = (enumConstant = (PsiEnumConstant)resolvedElem).getContainingClass()) != null) {
                return containingClass.getQualifiedName() + "." + enumConstant.getName();
            }
            return null;
        }
        if (attributeValue instanceof PsiLiteral) {
            String enumName = StringUtils.substringAfterLast((String)attributeValue.getText(), (String)".");
            if (enumName == null || enumName.isEmpty()) {
                enumName = attributeValue.getText();
            }
            return enumName;
        }
        return null;
    }

    @Nullable
    public static PsiType getDeclaredReferenceTypeValue(PsiAnnotation annotation, String attrName) {
        PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue(attrName);
        if (attributeValue instanceof PsiClassObjectAccessExpression) {
            return ((PsiClassObjectAccessExpression)attributeValue).getOperand().getType();
        }
        return null;
    }

    @Nullable
    public static String getDeclaredReferenceFqnStringValue(PsiAnnotation annotation, String attrName) {
        PsiType psiType = StudioAnnotationUtil.getDeclaredReferenceTypeValue(annotation, attrName);
        String fqn = psiType == null ? null : psiType.getCanonicalText();
        return "void".equals(fqn) ? null : fqn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/util/StudioAnnotationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringAttributeValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclaredLongAttributeValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findAnnotationBySimpleName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayValueAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

