/*
 * Copyright (c) 2022, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;

abstract class UnixDispatcher extends NativeDispatcher {
    private static final boolean SUPPORTS_PENDING_SIGNALS = NativeThread.supportPendingSignals();

    @Override
    void close(FileDescriptor fd) throws IOException {
        close0(fd);
    }

    private void signalThreads(long reader, long writer) {
        if (NativeThread.isNativeThread(reader))
            NativeThread.signal(reader);
        if (NativeThread.isNativeThread(writer))
            NativeThread.signal(writer);
    }

    @Override
    void implPreClose(FileDescriptor fd, long reader, long writer) throws IOException {
        if (SUPPORTS_PENDING_SIGNALS) {
            signalThreads(reader, writer);
        }
        preClose0(fd);
        if (!SUPPORTS_PENDING_SIGNALS) {
            signalThreads(reader, writer);
        }
    }

    private static native void close0(FileDescriptor fd) throws IOException;

    private static native void preClose0(FileDescriptor fd) throws IOException;

    static native void init();

    static {
        IOUtil.load();
        init();
    }
}
