/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_no extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabisk";
        final String metaValue_arc = "arameisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ae = "avestisk";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_ccp = "chakma";
        final String metaValue_cop = "koptisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_got = "gotisk";
        final String metaValue_el = "gresk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ja = "japansk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "laotisk";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_my = "burmesisk";
        final String metaValue_or = "odia";
        final String metaValue_pal = "pahlavi";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "singalesisk";
        final String metaValue_su = "sundanesisk";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thai";
        final String metaValue_bo = "tibetansk";
        final String metaValue_uga = "ugaritisk";
        final String metaValue_peo = "gammelpersisk";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "verden" },
            { "002", "Afrika" },
            { "003", "Nord-Amerika" },
            { "005", "S\u00f8r-Amerika" },
            { "009", "Oseania" },
            { "011", "Vest-Afrika" },
            { "013", "Mellom-Amerika" },
            { "014", "\u00d8st-Afrika" },
            { "015", "Nord-Afrika" },
            { "017", "Sentral-Afrika" },
            { "018", "S\u00f8rlige Afrika" },
            { "019", "Amerika" },
            { "021", "Nordlige Amerika" },
            { "029", "Karibia" },
            { "030", "\u00d8st-Asia" },
            { "034", "S\u00f8r-Asia" },
            { "035", "S\u00f8r\u00f8st-Asia" },
            { "039", "S\u00f8r-Europa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesia" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Sentral-Asia" },
            { "145", "Vest-Asia" },
            { "150", "Europa" },
            { "151", "\u00d8st-Europa" },
            { "154", "Nord-Europa" },
            { "155", "Vest-Europa" },
            { "202", "Afrika s\u00f8r for Sahara" },
            { "419", "Latin-Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "De forente arabiske emirater" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "\u00d8sterrike" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Aserbajdsjan" },
            { "BA", "Bosnia-Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibisk Nederland" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8ya" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Kokos\u00f8yene" },
            { "CD", "Kongo" },
            { "CF", "Den sentralafrikanske republikk" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Sveits" },
            { "CI", "Elfenbenskysten" },
            { "CK", "Cook\u00f8yene" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8ya" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kapp Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas\u00f8ya" },
            { "CY", "Kypros" },
            { "CZ", "Tsjekkia" },
            { "DE", "Tyskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Den dominikanske republikk" },
            { "DZ", "Algerie" },
            { "EA", "Ceuta og Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypt" },
            { "EH", "Vest-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Den europeiske union" },
            { "EZ", "eurosonen" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8yene" },
            { "FM", "Mikronesiaf\u00f8derasjonen" },
            { "FO", "F\u00e6r\u00f8yene" },
            { "FR", "Frankrike" },
            { "GA", "Gabon" },
            { "GB", "Storbritannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f8nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorial-Guinea" },
            { "GR", "Hellas" },
            { "GS", "S\u00f8r-Georgia og S\u00f8r-Sandwich\u00f8yene" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR Kina" },
            { "HM", "Heard- og McDonald\u00f8yene" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanari\u00f8yene" },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "India" },
            { "IO", "Det britiske territoriet i Indiahavet" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodsja" },
            { "KI", "Kiribati" },
            { "KM", "Komorene" },
            { "KN", "Saint Kitts og Nevis" },
            { "KP", "Nord-Korea" },
            { "KR", "S\u00f8r-Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman\u00f8yene" },
            { "KZ", "Kasakhstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall\u00f8yene" },
            { "MK", "Nord-Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR Kina" },
            { "MP", "Nord-Marianene" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivene" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Ny-Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f8ya" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransk Polynesia" },
            { "PG", "Papua Ny-Guinea" },
            { "PH", "Filippinene" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Pitcairn\u00f8yene" },
            { "PR", "Puerto Rico" },
            { "PS", "Det palestinske omr\u00e5det" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Ytre Oseania" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Rwanda" },
            { "SA", "Saudi-Arabia" },
            { "SB", "Salomon\u00f8yene" },
            { "SC", "Seychellene" },
            { "SD", "Sudan" },
            { "SE", "Sverige" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "S\u00f8r-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicos\u00f8yene" },
            { "TD", "Tsjad" },
            { "TF", "De franske s\u00f8rterritorier" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadsjikistan" },
            { "TK", "Tokelau" },
            { "TL", "\u00d8st-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Tyrkia" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "USAs ytre \u00f8yer" },
            { "UN", "FN" },
            { "US", "USA" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanstaten" },
            { "VC", "St. Vincent og Grenadinene" },
            { "VE", "Venezuela" },
            { "VG", "De britiske jomfru\u00f8yene" },
            { "VI", "De amerikanske jomfru\u00f8yene" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis og Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudospr\u00e5k \u2013 aksenter" },
            { "XB", "pseudospr\u00e5k \u2013 tekst begge veier" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00f8r-Afrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ukjent omr\u00e5de" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharisk" },
            { "an", "aragonsk" },
            { "ar", metaValue_ar },
            { "as", "assamesisk" },
            { "av", "avarisk" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "ba", "basjkirsk" },
            { "be", "belarusisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "ca", "katalansk" },
            { "ce", "tsjetsjensk" },
            { "ch", "chamorro" },
            { "co", "korsikansk" },
            { "cr", "cree" },
            { "cs", "tsjekkisk" },
            { "cu", "kirkeslavisk" },
            { "cv", "tsjuvasjisk" },
            { "cy", "walisisk" },
            { "da", "dansk" },
            { "de", "tysk" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "eu", "baskisk" },
            { "fa", "persisk" },
            { "ff", "fulfulde" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fo", "f\u00e6r\u00f8ysk" },
            { "fr", "fransk" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk-g\u00e6lisk" },
            { "gl", "galisisk" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "mansk" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesisk" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan-yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kasjmiri" },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "kornisk" },
            { "ky", "kirgisisk" },
            { "la", "latin" },
            { "lb", "luxemburgsk" },
            { "lg", "ganda" },
            { "li", "limburgsk" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litauisk" },
            { "lu", "luba-katanga" },
            { "lv", "latvisk" },
            { "mg", "gassisk" },
            { "mh", "marshallesisk" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayisk" },
            { "mt", "maltesisk" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norsk bokm\u00e5l" },
            { "nd", "nord-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "nederlandsk" },
            { "nn", "norsk nynorsk" },
            { "no", "norsk" },
            { "nr", "s\u00f8r-ndebele" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "oksitansk" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetisk" },
            { "pa", "panjabi" },
            { "pi", "pali" },
            { "pl", "polsk" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "qu", "quechua" },
            { "rm", "retoromansk" },
            { "rn", "rundi" },
            { "ro", "rumensk" },
            { "ru", "russisk" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardisk" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "si", metaValue_si },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "st", "s\u00f8r-sotho" },
            { "su", metaValue_su },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", metaValue_te },
            { "tg", "tadsjikisk" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "setswana" },
            { "to", "tongansk" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "tt", "tatarisk" },
            { "tw", "twi" },
            { "ty", "tahitisk" },
            { "ug", "uigurisk" },
            { "uk", "ukrainsk" },
            { "ur", "urdu" },
            { "uz", "usbekisk" },
            { "ve", "venda" },
            { "vi", "vietnamesisk" },
            { "vo", "volapyk" },
            { "wa", "vallonsk" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddisk" },
            { "yo", "joruba" },
            { "za", "zhuang" },
            { "zh", "kinesisk" },
            { "zu", "zulu" },
            { "ace", "achinesisk" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adygeisk" },
            { "aeb", "tunisisk-arabisk" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadisk" },
            { "akz", "alabama" },
            { "ale", "aleutisk" },
            { "aln", "gegisk-albansk" },
            { "alt", "s\u00f8raltaisk" },
            { "ang", "gammelengelsk" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", metaValue_arc },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "algerisk arabisk" },
            { "ars", "najdi-arabisk" },
            { "arw", "arawak" },
            { "ary", "marokkansk-arabisk" },
            { "arz", "egyptisk arabisk" },
            { "asa", "asu" },
            { "ase", "amerikansk tegnspr\u00e5k" },
            { "ast", "asturisk" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "avadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bar", "bairisk" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "vestbalutsji" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akose" },
            { "bua", "burjatisk" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karibisk" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chb", "chibcha" },
            { "chg", "tsjagatai" },
            { "chk", "chuukesisk" },
            { "chm", "mari" },
            { "chn", "chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewiansk" },
            { "chr", "cherokesisk" },
            { "chy", "cheyenne" },
            { "ckb", "sentralkurdisk" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "kapiz" },
            { "crg", "michif" },
            { "crh", "krimtatarisk" },
            { "crj", "s\u00f8rlig \u00f8stcree" },
            { "crk", "pr\u00e6rie-cree" },
            { "crl", "nordlig \u00f8stcree" },
            { "crm", "moose cree" },
            { "crr", "carolinsk-algonkinsk" },
            { "crs", "seselwa" },
            { "csb", "kasjubisk" },
            { "csw", "myr-cree" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavey" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "lavsorbisk" },
            { "dtp", "sentraldusun" },
            { "dua", "duala" },
            { "dum", "mellomnederlandsk" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "kiembu" },
            { "efi", "efik" },
            { "egl", "emiliansk" },
            { "egy", "gammelegyptisk" },
            { "eka", "ekajuk" },
            { "elx", "elamittisk" },
            { "enm", "mellomengelsk" },
            { "esu", "sentralyupik" },
            { "ewo", "ewondo" },
            { "ext", "ekstremaduransk" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fit", "tornedalsfinsk" },
            { "fon", "fon" },
            { "frc", "cajunfransk" },
            { "frm", "mellomfransk" },
            { "fro", "gammelfransk" },
            { "frp", "arpitansk" },
            { "frr", "nordfrisisk" },
            { "frs", "\u00f8stfrisisk" },
            { "fur", "friuliansk" },
            { "gaa", "ga" },
            { "gag", "gagausisk" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "zoroastrisk dari" },
            { "gez", "geez" },
            { "gil", "kiribatisk" },
            { "glk", "gileki" },
            { "gmh", "mellomh\u00f8ytysk" },
            { "goh", "gammelh\u00f8ytysk" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "gammelgresk" },
            { "gsw", "sveitsertysk" },
            { "guc", "wayuu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwich\u2019in" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawaiisk" },
            { "hax", "s\u00f8rlig haida" },
            { "hif", "fijiansk hindi" },
            { "hil", "hiligaynon" },
            { "hit", "hettittisk" },
            { "hmn", "hmong" },
            { "hsb", "h\u00f8ysorbisk" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "vestlig kanadisk inuktitut" },
            { "ilo", "iloko" },
            { "inh", "ingusjisk" },
            { "izh", "ingrisk" },
            { "jam", "jamaicansk kreolengelsk" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "j\u00f8depersisk" },
            { "jrb", "j\u00f8dearabisk" },
            { "jut", "jysk" },
            { "kaa", "karakalpakisk" },
            { "kab", "kabylsk" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardisk" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kappverdisk" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanesisk" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmancki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komipermjakisk" },
            { "kok", "konkani" },
            { "kos", "kosraeansk" },
            { "kpe", metaValue_kpe },
            { "krc", "karatsjajbalkarsk" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelsk" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f8lnsk" },
            { "kum", "kumykisk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u0313wala" },
            { "kxv", "kuvi" },
            { "lad", "ladinsk" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lesgisk" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurisk" },
            { "lil", "lillooet" },
            { "liv", "livisk" },
            { "lkt", "lakota" },
            { "lmo", "lombardisk" },
            { "lol", "mongo" },
            { "lou", "louisianakreolsk" },
            { "loz", "lozi" },
            { "lrc", "nord-luri" },
            { "lsm", "samia" },
            { "ltg", "latgallisk" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luhya" },
            { "lzh", "klassisk kinesisk" },
            { "lzz", "lazisk" },
            { "mad", "maduresisk" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksja" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "mauritisk-kreolsk" },
            { "mga", "mellomirsk" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mandsju" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "vestmarisk" },
            { "mua", "mundang" },
            { "mul", "flere spr\u00e5k" },
            { "mus", "creek" },
            { "mwl", "mirandesisk" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzia" },
            { "mzn", "mazandarani" },
            { "nan", "minnan" },
            { "nap", "napolitansk" },
            { "naq", "nama" },
            { "nds", "nedertysk" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueansk" },
            { "njo", "ao naga" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaisk" },
            { "non", "gammelnorsk" },
            { "nov", "novial" },
            { "nqo", "n\u02bcko" },
            { "nso", "nord-sotho" },
            { "nus", "nuer" },
            { "nwc", "klassisk newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "nordvestlig ojibwa" },
            { "ojc", "ojibwa (sentral)" },
            { "ojs", "oji-cree" },
            { "ojw", "vestlig ojibwa" },
            { "oka", "okanagansk" },
            { "osa", "osage" },
            { "ota", "ottomansk tyrkisk" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauisk" },
            { "pcd", "pikardisk" },
            { "pcm", "nigeriansk pidginspr\u00e5k" },
            { "pdc", "pennsylvaniatysk" },
            { "pdt", "plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "palatintysk" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "piemontesisk" },
            { "pnt", "pontisk" },
            { "pon", "ponapisk" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "pr\u00f8yssisk" },
            { "pro", "gammelproven\u00e7alsk" },
            { "quc", "k\u2019iche\u2019" },
            { "qug", "kichwa (Chimborazo-h\u00f8ylandet)" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongansk" },
            { "rgn", "romagnolsk" },
            { "rhg", "rohingya" },
            { "rif", "riff" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotumansk" },
            { "rue", "rusinsk" },
            { "rug", "roviana" },
            { "rup", "aromansk" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "samaritansk arameisk" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliansk" },
            { "sco", "skotsk" },
            { "sdc", "sassaresisk sardisk" },
            { "sdh", "s\u00f8rkurdisk" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkupisk" },
            { "ses", "koyraboro senni" },
            { "sga", "gammelirsk" },
            { "sgs", "samogitisk" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "tsjadisk arabisk" },
            { "sid", "sidamo" },
            { "slh", "s\u00f8rlig lushootseed" },
            { "sli", "lavschlesisk" },
            { "sly", "selayar" },
            { "sma", "s\u00f8rsamisk" },
            { "smj", "lulesamisk" },
            { "smn", "enaresamisk" },
            { "sms", "skoltesamisk" },
            { "snk", "soninke" },
            { "sog", "sogdisk" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "stq", "saterfrisisk" },
            { "str", "straits-salish" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerisk" },
            { "swb", "komorisk" },
            { "syc", "klassisk syrisk" },
            { "syr", "syriakisk" },
            { "szl", "schlesisk" },
            { "tce", "s\u00f8rlig tutchone" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelauisk" },
            { "tkr", "tsakhursk" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "talysj" },
            { "tmh", "tamasjek" },
            { "tog", "nyasa-tongansk" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "tsakonisk" },
            { "tsi", "tsimshian" },
            { "ttm", "nordlig tutchone" },
            { "ttt", "muslimsk tat" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalsk" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinsk" },
            { "tzm", "sentralmarokkansk tamazight" },
            { "udm", "udmurtisk" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "ukjent spr\u00e5k" },
            { "vec", "venetiansk" },
            { "vep", "vepsisk" },
            { "vls", "vestflamsk" },
            { "vmf", "Main-frankisk" },
            { "vmw", "makhuwa" },
            { "vot", "votisk" },
            { "vro", "s\u00f8restisk" },
            { "vun", "vunjo" },
            { "wae", "walsertysk" },
            { "wal", "wolaytta" },
            { "war", "waray-waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmukkisk" },
            { "xmf", "mingrelsk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapesisk" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonesisk" },
            { "zap", "zapotekisk" },
            { "zbl", "blissymboler" },
            { "zea", "zeeuws" },
            { "zen", "zenaga" },
            { "zgh", "standard marrokansk tamazight" },
            { "zun", "zuni" },
            { "zxx", "uten spr\u00e5klig innhold" },
            { "zza", "zazaisk" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "kaukasus-albansk" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", metaValue_arc },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", "bengalsk" },
            { "Blis", "blissymbol" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "punktskrift" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "felles kanadiske urspr\u00e5ksstavelser" },
            { "Cari", "karisk" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "kypriotisk" },
            { "Cyrl", "kyrillisk" },
            { "Cyrs", "kirkeslavisk kyrillisk" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Dupl", "duployan stenografi" },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "Egyp", "egyptiske hieroglyfer" },
            { "Elba", "elbasisk" },
            { "Ethi", "etiopisk" },
            { "Geok", "georgisk khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolittisk" },
            { "Goth", metaValue_got },
            { "Gran", "gammeltamilsk" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han-kinesisk med bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "forenklet" },
            { "Hant", "tradisjonell" },
            { "Hatr", "hatransk armensk" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "anatoliske hieroglyfer" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "japanske stavelsesskrifter" },
            { "Hung", "gammelungarsk" },
            { "Inds", "indus" },
            { "Ital", "gammelitalisk" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithisk" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "frakturlatinsk" },
            { "Latg", "g\u00e6lisk latinsk" },
            { "Latn", "latinsk" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "line\u00e6r A" },
            { "Linb", "line\u00e6r B" },
            { "Lisu", "fraser" },
            { "Loma", "loma" },
            { "Lyci", "lykisk" },
            { "Lydi", "lydisk" },
            { "Mahj", "mahajani" },
            { "Mand", "mandaisk" },
            { "Mani", "manikeisk" },
            { "Maya", "maya-hieroglyfer" },
            { "Mend", metaValue_men },
            { "Merc", "meroitisk kursiv" },
            { "Mero", "meroitisk" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mro" },
            { "Mtei", "meitei-mayek" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Narb", "gammelnordarabisk" },
            { "Nbat", "nabataeansk" },
            { "Nkgb", "naxi geba" },
            { "Nkoo", "n\u2019ko" },
            { "Nshu", "n\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmanya" },
            { "Palm", "palmyrensk" },
            { "Pauc", "pau cin hau" },
            { "Perm", "gammelpermisk" },
            { "Phag", "phags-pa" },
            { "Phli", "inskripsjonspahlavi" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", metaValue_pal },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollard-fonetisk" },
            { "Prti", "inskripsjonsparthisk" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runer" },
            { "Samr", "samaritansk" },
            { "Sara", "sarati" },
            { "Sarb", "gammels\u00f8rarabisk" },
            { "Saur", metaValue_saz },
            { "Sgnw", "tegnskrift" },
            { "Shaw", "shavisk" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syrisk" },
            { "Syre", "estrangelosyriakisk" },
            { "Syrj", "vestlig syriakisk" },
            { "Syrn", "\u00f8stlig syriakisk" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "ny tai lue" },
            { "Taml", "tamilsk" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "synlig tale" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumersk-akkadisk kileskrift" },
            { "Yiii", "yi" },
            { "Zinh", "nedarvet" },
            { "Zmth", "matematisk notasjon" },
            { "Zsye", "emoji" },
            { "Zsym", "symboler" },
            { "Zxxx", "spr\u00e5k uten skrift" },
            { "Zyyy", "felles" },
            { "Zzzz", "ukjent skrift" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamsk" },
            { "ro_MD", "moldovsk" },
            { "sw_CD", "kongolesisk swahili" },
            { "%%1901", "tradisjonell tysk ortografi" },
            { "%%1994", "standardisert resisk ortografi" },
            { "%%1996", "tysk ortografi fra 1996" },
            { "ar_001", "moderne standardarabisk" },
            { "key.ca", "kalender" },
            { "key.cf", "valutaformat" },
            { "key.co", "sorteringsrekkef\u00f8lge" },
            { "key.cu", "valuta" },
            { "key.hc", "timesyklus (12 eller 24)" },
            { "key.lb", "linjeskiftstil" },
            { "key.ms", "m\u00e5lesystem" },
            { "key.nu", "tall" },
            { "key.tz", "tidssone" },
            { "key.va", "spr\u00e5kvariant" },
            { "nds_NL", "nedersaksisk" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "%%BARLA", "barlaventa-dialektgruppen av kappverdiansk" },
            { "%%BISKE", "san giorgio- og biladialekt" },
            { "%%BOONT", "boontling" },
            { "%%JAUER", "jauer" },
            { "%%KKCOR", "felles ortografi" },
            { "%%KSCOR", "standard ortografi" },
            { "%%LIPAW", "resia med Lipovaz-dialekt" },
            { "%%NEDIS", "natisonedialekt" },
            { "%%NJIVA", "gniva- og njivadialekt" },
            { "%%NULIK", "moderne volap\u00fck" },
            { "%%OSOJS", "oseacco- og osojanedialekt" },
            { "%%POSIX", "dataspr\u00e5k" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "stolvizza- og solbicadialekt" },
            { "%%SOTAV", "sotavento-dialektgruppen av kappverdiansk" },
            { "%%UCCOR", "harmonisert ortografi" },
            { "zh_Hans", "forenklet kinesisk" },
            { "zh_Hant", "tradisjonell kinesisk" },
            { "%%DAJNKO", "dajnkoalfabet" },
            { "%%EKAVSK", "serbisk med ekavisk uttale" },
            { "%%FONIPA", "det internasjonale fonetiske alfabet (IPA)" },
            { "%%FONUPA", "det uraliske fonetiske alfabet (UPA)" },
            { "%%NDYUKA", "ndyuka-dialekt" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse dialekt" },
            { "%%TARASK", "taraskievica-ortografi" },
            { "%%UCRCOR", "harmonisert revidert ortografi" },
            { "%%ULSTER", "ulster" },
            { "%%UNIFON", "Unifon fonetisk alfabet" },
            { "%%ALALC97", "ALA-LC-romanisering, 1997-utgaven" },
            { "%%AREVELA", "\u00f8st-armensk" },
            { "%%AREVMDA", "vest-armensk" },
            { "%%BALANKA", "balankadialekten av anii" },
            { "%%BAUDDHA", "bauddha" },
            { "%%BOHORIC", "bohorisk alfabet" },
            { "%%EMODENG", "tidlig moderne engelsk" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "%%ITIHASA", "itihasa" },
            { "%%LAUKIKA", "laukika" },
            { "%%METELKO", "Metelko-alfabet" },
            { "%%MONOTON", "monotonisk rettskriving" },
            { "%%POLYTON", "polytonisk rettskriving" },
            { "%%REVISED", "revidert ortografi" },
            { "%%SURSILV", "sursilvan" },
            { "%%SUTSILV", "sutsilvan" },
            { "%%VAIDIKA", "vaidika" },
            { "%%1606NICT", "nyere mellomfransk til 1606" },
            { "%%1694ACAD", "eldre nyfransk" },
            { "%%1959ACAD", "akademisk" },
            { "%%BAKU1926", "samlet tyrkisk-latinsk alfabet" },
            { "%%BISCAYAN", "biscayan" },
            { "%%FONXSAMP", "fonxsamp" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "%%HSISTEMO", "h-systemet" },
            { "%%IJEKAVSK", "serbisk med ijekavisk uttale" },
            { "%%JYUTPING", "jyutping" },
            { "%%KOCIEWIE", "kociewie" },
            { "%%SCOTLAND", "skotsk standard engelsk" },
            { "%%SURMIRAN", "surmiransk" },
            { "%%VALENCIA", "valensiansk" },
            { "%%VALLADER", "vallader" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "%%XSISTEMO", "x-systemet" },
            { "type.ca.roc", "minguo-kalender" },
            { "type.co.eor", "sorteringsrekkef\u00f8lge for flerspr\u00e5klige europeiske dokumenter" },
            { "type.hc.h11", "12-timers system (0\u201311)" },
            { "type.hc.h12", "12-timers system (1\u201312)" },
            { "type.hc.h23", "24-timers system (0\u201323)" },
            { "type.hc.h24", "24-timers system (1\u201324)" },
            { "type.m0.bgn", "USBGN-translitterasjon" },
            { "type.nu.arab", "arabisk-indiske sifre" },
            { "type.nu.armn", "armenske tall" },
            { "type.nu.bali", "baliske tall" },
            { "type.nu.beng", "bengalske sifre" },
            { "type.nu.brah", "brahmiske tall" },
            { "type.nu.cakm", "chakma-sifre" },
            { "type.nu.cham", "cham-tall" },
            { "type.nu.cyrl", "kyrilliske tall" },
            { "type.nu.deva", "devanagari-sifre" },
            { "type.nu.ethi", "etiopiske tall" },
            { "type.nu.geor", "georgiske tall" },
            { "type.nu.grek", "greske tall" },
            { "type.nu.gujr", "gujarati-sifre" },
            { "type.nu.guru", "gurmukhi-sifre" },
            { "type.nu.hans", "forenklet kinesisk-tall" },
            { "type.nu.hant", "tradisjonell kinesisk-tall" },
            { "type.nu.hebr", "hebraiske tall" },
            { "type.nu.java", "javanesiske sifre" },
            { "type.nu.jpan", "japanske tall" },
            { "type.nu.kali", "kayah li-tall" },
            { "type.nu.kawi", "kawi-sifre" },
            { "type.nu.khmr", "khmer-sifre" },
            { "type.nu.knda", "kannada-sifre" },
            { "type.nu.lana", "thai tham hora-tall" },
            { "type.nu.laoo", "laotiske sifre" },
            { "type.nu.latn", "vestlige sifre" },
            { "type.nu.lepc", "lepecha-tall" },
            { "type.nu.limb", "limbu-tall" },
            { "type.nu.mlym", "malayalam-sifre" },
            { "type.nu.mong", "mongolske tall" },
            { "type.nu.mtei", "meetei mayek-sifre" },
            { "type.nu.mymr", "burmesiske sifre" },
            { "type.nu.nkoo", "n\u2019ko-tall" },
            { "type.nu.olck", "ol chiki-sifre" },
            { "type.nu.orya", "odia-sifre" },
            { "type.nu.osma", "osmanya-tall" },
            { "type.nu.saur", "sarushatra-tall" },
            { "type.nu.shrd", "sharada-tall" },
            { "type.nu.sora", "sora sompeng-tall" },
            { "type.nu.sund", "sundanese-tall" },
            { "type.nu.takr", "takri-tall" },
            { "type.nu.talu", "ny tai lue-tall" },
            { "type.nu.taml", "tamilske tall" },
            { "type.nu.telu", "telugu-sifre" },
            { "type.nu.thai", "thailandske sifre" },
            { "type.nu.tibt", "tibetanske sifre" },
            { "type.nu.tirh", "tirhuta-sifre" },
            { "type.nu.tnsa", "tangsa-sifre" },
            { "type.nu.vaii", "vai-sifre" },
            { "type.ca.dangi", "dangisk kalender" },
            { "type.co.ducet", "standard Unicode-sorteringsrekkef\u00f8lge" },
            { "type.co.emoji", "emoji-sorteringsrekkef\u00f8lge" },
            { "type.lb.loose", "l\u00f8s linjeskiftstil" },
            { "type.nu.roman", "romertall" },
            { "type.ca.coptic", "koptisk kalender" },
            { "type.ca.hebrew", "hebraisk kalender" },
            { "type.ca.indian", "indisk nasjonalkalender" },
            { "type.co.compat", "forrige sorteringsrekkef\u00f8lge (for kompatibilitet)" },
            { "type.co.pinyin", "pinyinsortering" },
            { "type.co.search", "generelt s\u00f8k" },
            { "type.co.stroke", "streksortering" },
            { "type.co.unihan", "radikal-strek-sortering" },
            { "type.co.zhuyin", "zhuyin-sortering" },
            { "type.d0.fwidth", "full bredde" },
            { "type.d0.hwidth", "halv bredde" },
            { "type.lb.normal", "normal linjeskiftstil" },
            { "type.lb.strict", "streng linjeskiftstil" },
            { "type.m0.ungegn", "UNGEGN-translitterasjon" },
            { "type.ms.metric", "metrisk system" },
            { "type.nu.native", "spr\u00e5kspesifikke sifre" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "type.ca.islamic", "hijrikalender" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "type.ca.persian", "persisk kalender" },
            { "type.cf.account", "valutaformat for regnskapsf\u00f8ring" },
            { "type.co.big5han", "tradisjonell kinesisk sortering - Big 5" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.arabext", "utvidede arabisk-indiske sifre" },
            { "type.nu.armnlow", "sm\u00e5 armenske tall" },
            { "type.nu.finance", "Finansielle tall" },
            { "type.nu.greklow", "sm\u00e5 greske tall" },
            { "type.nu.hanidec", "kinesiske desimaltall" },
            { "type.nu.hansfin", "forenklet kinesisk-finanstall" },
            { "type.nu.hantfin", "tradisjonell kinesisk-finanstall" },
            { "type.nu.jpanfin", "japanske finanstall" },
            { "type.nu.tamldec", "tamilske sifre" },
            { "type.ca.buddhist", "buddhistisk kalender" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "type.ca.japanese", "japansk kalender" },
            { "type.cf.standard", "standard valutaformat" },
            { "type.co.phonetic", "fonetisk sortering" },
            { "type.co.searchjl", "S\u00f8k etter f\u00f8rste konsonant i hangul" },
            { "type.co.standard", "standard sorteringsrekkef\u00f8lge" },
            { "type.ms.uksystem", "britisk m\u00e5lesystem" },
            { "type.ms.ussystem", "amerikansk m\u00e5lesystem" },
            { "type.nu.fullwide", "sifre med full bredde" },
            { "type.nu.lanatham", "tai tham tham-tall" },
            { "type.nu.mymrshan", "myanmar shan-tall" },
            { "type.nu.romanlow", "sm\u00e5 romertall" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "type.co.gb2312han", "forenklet kinesisk sortering - GB2312" },
            { "type.co.phonebook", "telefonkatalogsortering" },
            { "type.co.dictionary", "ordlistesortering" },
            { "type.co.traditional", "tradisjonell sortering" },
            { "type.nu.traditional", "Tradisjonelle tall" },
            { "type.ca.islamic-rgsa", "islamsk kalender (Saudi-Arabia, observasjon)" },
            { "type.ca.islamic-tbla", "islamsk kalender (tabell, astronomisk)" },
            { "type.ca.islamic-civil", "hijrikalender (tabell, sivil)" },
            { "type.ca.islamic-umalqura", "hijrikalender (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
        };
        return data;
    }
}
