/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import sun.misc.IOUtils;

class NativeUnpack {
    private long unpackerPtr;
    private BufferedInputStream in;
    private int _verbose;
    private long _byteCount;
    private int _segCount;
    private int _fileCount;
    private long _estByteLimit;
    private int _estSegLimit;
    private int _estFileLimit;
    private int _prevPercent = -1;
    private int _bufsize = 16384;
    private final CRC32 _crc32 = new CRC32();
    private UnpackerImpl _p200;
    private PropMap _props;

    private static synchronized native void initIDs();

    private synchronized native long start(ByteBuffer var1, long var2);

    private synchronized native boolean getNextFile(Object[] var1);

    private synchronized native ByteBuffer getUnusedInput();

    private synchronized native long finish();

    protected synchronized native boolean setOption(String var1, String var2);

    protected synchronized native String getOption(String var1);

    NativeUnpack(UnpackerImpl unpackerImpl) {
        this._p200 = unpackerImpl;
        this._props = unpackerImpl.props;
        unpackerImpl._nunp = this;
    }

    private static Object currentInstance() {
        UnpackerImpl unpackerImpl = (UnpackerImpl)Utils.getTLGlobals();
        return unpackerImpl == null ? null : unpackerImpl._nunp;
    }

    private synchronized long getUnpackerPtr() {
        return this.unpackerPtr;
    }

    private long readInputFn(ByteBuffer byteBuffer, long l) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        long l2 = byteBuffer.capacity() - byteBuffer.position();
        assert (l <= l2);
        long l3 = 0L;
        int n = 0;
        while (l3 < l) {
            int n2;
            ++n;
            int n3 = this._bufsize;
            byte[] byArray = new byte[n3];
            if ((long)n3 > l2 - l3) {
                n3 = (int)(l2 - l3);
            }
            if ((n2 = this.in.read(byArray, 0, n3)) <= 0) break;
            assert ((l3 += (long)n2) <= l2);
            byteBuffer.put(byArray, 0, n2);
        }
        if (this._verbose > 1) {
            Utils.log.fine("readInputFn(" + l + "," + l2 + ") => " + l3 + " steps=" + n);
        }
        this._estByteLimit = l2 > 100L ? this._byteCount + l2 : (this._byteCount + l3) * 20L;
        this._byteCount += l3;
        this.updateProgress();
        return l3;
    }

    private void updateProgress() {
        double d = this._segCount;
        if (this._estByteLimit > 0L && this._byteCount > 0L) {
            d += (double)this._byteCount / (double)this._estByteLimit;
        }
        double d2 = this._fileCount;
        double d3 = 0.33 * d / (double)Math.max(this._estSegLimit, 1) + 0.67 * d2 / (double)Math.max(this._estFileLimit, 1);
        int n = (int)Math.round(100.0 * d3);
        if (n > 100) {
            n = 100;
        }
        if (n > this._prevPercent) {
            this._prevPercent = n;
            this._props.setInteger("unpack.progress", n);
            if (this._verbose > 0) {
                Utils.log.info("progress = " + n);
            }
        }
    }

    private void copyInOption(String string) {
        boolean bl;
        String string2 = this._props.getProperty(string);
        if (this._verbose > 0) {
            Utils.log.info("set " + string + "=" + string2);
        }
        if (string2 != null && !(bl = this.setOption(string, string2))) {
            Utils.log.warning("Invalid option " + string + "=" + string2);
        }
    }

    void run(InputStream inputStream, JarOutputStream jarOutputStream, ByteBuffer byteBuffer) throws IOException {
        BufferedInputStream bufferedInputStream;
        this.in = bufferedInputStream = new BufferedInputStream(inputStream);
        this._verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
        int n = "keep".equals(this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "0")) ? 0 : this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time");
        this.copyInOption("com.sun.java.util.jar.pack.verbose");
        this.copyInOption("unpack.deflate.hint");
        if (n == 0) {
            this.copyInOption("com.sun.java.util.jar.pack.unpack.modification.time");
        }
        this.updateProgress();
        while (true) {
            long l = this.start(byteBuffer, 0L);
            this._estByteLimit = 0L;
            this._byteCount = 0L;
            ++this._segCount;
            int n2 = (int)(l >>> 32);
            int n3 = (int)(l >>> 0);
            this._estSegLimit = this._segCount + n2;
            double d = this._fileCount + n3;
            this._estFileLimit = (int)(d * (double)this._estSegLimit / (double)this._segCount);
            int[] nArray = new int[]{0, 0, 0, 0};
            Object[] objectArray = new Object[]{nArray, null, null, null};
            while (this.getNextFile(objectArray)) {
                String string = (String)objectArray[1];
                long l2 = ((long)nArray[0] << 32) + ((long)nArray[1] << 32 >>> 32);
                long l3 = n != 0 ? (long)n : (long)nArray[2];
                boolean bl = nArray[3] != 0;
                ByteBuffer byteBuffer2 = (ByteBuffer)objectArray[2];
                ByteBuffer byteBuffer3 = (ByteBuffer)objectArray[3];
                this.writeEntry(jarOutputStream, string, l3, l2, bl, byteBuffer2, byteBuffer3);
                ++this._fileCount;
                this.updateProgress();
            }
            byteBuffer = this.getUnusedInput();
            long l4 = this.finish();
            if (this._verbose > 0) {
                Utils.log.info("bytes consumed = " + l4);
            }
            if (byteBuffer == null && !Utils.isPackMagic(Utils.readMagic(bufferedInputStream))) break;
            if (this._verbose <= 0 || byteBuffer == null) continue;
            Utils.log.info("unused input = " + byteBuffer);
        }
    }

    void run(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
        this.run(inputStream, jarOutputStream, null);
    }

    void run(File file, JarOutputStream jarOutputStream) throws IOException {
        ByteBuffer byteBuffer = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.run(fileInputStream, jarOutputStream, byteBuffer);
        }
    }

    private void writeEntry(JarOutputStream jarOutputStream, String string, long l, long l2, boolean bl, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        byte[] byArray;
        int n;
        int n2 = (int)l2;
        if ((long)n2 != l2) {
            throw new IOException("file too large: " + l2);
        }
        CRC32 cRC32 = this._crc32;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this._verbose > 1) {
            Utils.log.fine("Writing entry: " + string + " size=" + n2 + (bl ? " deflated" : ""));
        }
        int n3 = 0;
        if (byteBuffer != null) {
            n = byteBuffer.capacity();
            byArray = new byte[n];
            byteBuffer.get(byArray);
            byteArrayOutputStream.write(byArray);
            n3 += n;
        }
        if (byteBuffer2 != null) {
            n = byteBuffer2.capacity();
            byArray = new byte[n];
            byteBuffer2.get(byArray);
            byteArrayOutputStream.write(byArray);
            n3 += n;
        }
        while (n3 < n2) {
            byte[] byArray2 = IOUtils.readNBytes(this.in, n2 - n3);
            if (byArray2.length <= 0) {
                throw new IOException("EOF at end of archive");
            }
            byteArrayOutputStream.write(byArray2);
            n3 += byArray2.length;
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (this._bufsize < byArray3.length) {
            this._bufsize = byArray3.length;
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l * 1000L);
        if (n2 == 0) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
            zipEntry.setCompressedSize(0L);
        } else if (!bl) {
            zipEntry.setMethod(0);
            zipEntry.setSize(n2);
            zipEntry.setCompressedSize(n2);
            cRC32.reset();
            cRC32.update(byArray3, 0, n2);
            zipEntry.setCrc(cRC32.getValue());
        } else {
            zipEntry.setMethod(8);
            zipEntry.setSize(n2);
        }
        jarOutputStream.putNextEntry(zipEntry);
        if (n2 > 0) {
            jarOutputStream.write(byArray3, 0, n2);
        }
        jarOutputStream.closeEntry();
        if (this._verbose > 0) {
            Utils.log.info("Writing " + Utils.zeString(zipEntry));
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("unpack");
                return null;
            }
        });
        NativeUnpack.initIDs();
    }
}

