/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModulePackages
extends Attribute {
    private int[] packageIndexTable;

    ModulePackages(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, (int[])null, constantPool);
        int packageCount = input.readUnsignedShort();
        this.packageIndexTable = new int[packageCount];
        for (int i = 0; i < packageCount; ++i) {
            this.packageIndexTable[i] = input.readUnsignedShort();
        }
    }

    public ModulePackages(int nameIndex, int length, int[] packageIndexTable, ConstantPool constantPool) {
        super((byte)23, nameIndex, length, constantPool);
        this.packageIndexTable = packageIndexTable != null ? packageIndexTable : Const.EMPTY_INT_ARRAY;
        Args.requireU2(this.packageIndexTable.length, "packageIndexTable.length");
    }

    public ModulePackages(ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndexTable(), c.getConstantPool());
    }

    @Override
    public void accept(Visitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ModulePackages c = (ModulePackages)this.clone();
        if (this.packageIndexTable != null) {
            c.packageIndexTable = (int[])this.packageIndexTable.clone();
        }
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.packageIndexTable.length);
        for (int index : this.packageIndexTable) {
            file.writeShort(index);
        }
    }

    public int getNumberOfPackages() {
        return this.packageIndexTable == null ? 0 : this.packageIndexTable.length;
    }

    public int[] getPackageIndexTable() {
        return this.packageIndexTable;
    }

    public String[] getPackageNames() {
        String[] names = new String[this.packageIndexTable.length];
        for (int i = 0; i < this.packageIndexTable.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.packageIndexTable[i], (byte)20).replace('/', '.');
        }
        return names;
    }

    public void setPackageIndexTable(int[] packageIndexTable) {
        this.packageIndexTable = packageIndexTable != null ? packageIndexTable : Const.EMPTY_INT_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModulePackages(");
        buf.append(this.packageIndexTable.length);
        buf.append("):\n");
        for (int index : this.packageIndexTable) {
            String packageName = super.getConstantPool().getConstantString(index, (byte)20);
            buf.append("  ").append(Utility.compactClassName(packageName, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

