/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static SocketFactory defaultSocketFactory = null;
    private static final long serialVersionUID = -8310631444933958385L;

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        Object object;
        Object object2;
        SocketFactory socketFactory = SslRMIClientSocketFactory.getDefaultClientSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string, n);
        boolean bl = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("jdk.rmi.ssl.client.enableEndpointIdentification", "true")));
        if (bl) {
            object2 = sSLSocket.getSSLParameters();
            if (object2 == null) {
                object2 = new SSLParameters();
            }
            ((SSLParameters)object2).setEndpointIdentificationAlgorithm("HTTPS");
            sSLSocket.setSSLParameters((SSLParameters)object2);
        }
        if ((object2 = System.getProperty("javax.rmi.ssl.client.enabledCipherSuites")) != null) {
            object = new StringTokenizer((String)object2, ",");
            int n2 = ((StringTokenizer)object).countTokens();
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = ((StringTokenizer)object).nextToken();
            }
            try {
                sSLSocket.setEnabledCipherSuites(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }
        if ((object = System.getProperty("javax.rmi.ssl.client.enabledProtocols")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            int n3 = stringTokenizer.countTokens();
            String[] stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            try {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }
        return sSLSocket;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static synchronized SocketFactory getDefaultClientSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = SSLSocketFactory.getDefault();
        }
        return defaultSocketFactory;
    }
}

