/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.TablePrintable;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import sun.awt.AWTAccessor;
import sun.reflect.misc.ReflectUtil;
import sun.swing.PrintingStatus;
import sun.swing.SwingUtilities2;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible,
RowSorterListener {
    private static final String uiClassID = "TableUI";
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    protected int rowHeight;
    protected int rowMargin;
    protected Color gridColor;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected int autoResizeMode;
    protected boolean autoCreateColumnsFromModel;
    protected Dimension preferredViewportSize;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected transient Component editorComp;
    protected transient TableCellEditor cellEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultRenderersByColumnClass;
    protected transient Hashtable defaultEditorsByColumnClass;
    protected Color selectionForeground;
    protected Color selectionBackground;
    private SizeSequence rowModel;
    private boolean dragEnabled;
    private boolean surrendersFocusOnKeystroke;
    private PropertyChangeListener editorRemover = null;
    private boolean columnSelectionAdjusting;
    private boolean rowSelectionAdjusting;
    private Throwable printError;
    private boolean isRowHeightSet;
    private boolean updateSelectionOnSort;
    private transient SortManager sortManager;
    private boolean ignoreSortChange;
    private boolean sorterChanged;
    private boolean autoCreateRowSorter;
    private boolean fillsViewportHeight;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private transient DropLocation dropLocation;

    public JTable() {
        this(null, null, null);
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.setLayout(null);
        this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
        this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
            this.autoCreateColumnsFromModel = true;
        }
        this.setColumnModel(tableColumnModel);
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (tableModel == null) {
            tableModel = this.createDefaultDataModel();
        }
        this.setModel(tableModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    public JTable(final Object[][] objectArray, final Object[] objectArray2) {
        this(new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                return objectArray2[n].toString();
            }

            @Override
            public int getRowCount() {
                return objectArray.length;
            }

            @Override
            public int getColumnCount() {
                return objectArray2.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        JViewport jViewport;
        Container container;
        Container container2 = SwingUtilities.getUnwrappedParent(this);
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport2 = jScrollPane.getViewport();
            if (jViewport2 == null || SwingUtilities.getUnwrappedView(jViewport2) != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            this.configureEnclosingScrollPaneUI();
        }
    }

    private void configureEnclosingScrollPaneUI() {
        JViewport jViewport;
        Container container;
        Container container2 = SwingUtilities.getUnwrappedParent(this);
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            Object object;
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport2 = jScrollPane.getViewport();
            if (jViewport2 == null || SwingUtilities.getUnwrappedView(jViewport2) != this) {
                return;
            }
            Border border = jScrollPane.getBorder();
            if ((border == null || border instanceof UIResource) && (object = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                jScrollPane.setBorder((Border)object);
            }
            if ((object = jScrollPane.getCorner("UPPER_TRAILING_CORNER")) == null || object instanceof UIResource) {
                object = null;
                try {
                    object = (Component)UIManager.get("Table.scrollPaneCornerComponent");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", (Component)object);
            }
        }
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        JViewport jViewport;
        Container container;
        Container container2 = SwingUtilities.getUnwrappedParent(this);
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport2 = jScrollPane.getViewport();
            if (jViewport2 == null || SwingUtilities.getUnwrappedView(jViewport2) != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
            Component component = jScrollPane.getCorner("UPPER_TRAILING_CORNER");
            if (component instanceof UIResource) {
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", null);
            }
        }
    }

    @Override
    void setUIProperty(String string, Object object) {
        if (string == "rowHeight") {
            if (!this.isRowHeightSet) {
                this.setRowHeight(((Number)object).intValue());
                this.isRowHeightSet = false;
            }
            return;
        }
        super.setUIProperty(string, object);
    }

    @Deprecated
    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            JTableHeader jTableHeader2 = this.tableHeader;
            if (jTableHeader2 != null) {
                jTableHeader2.setTable(null);
            }
            this.tableHeader = jTableHeader;
            if (jTableHeader != null) {
                jTableHeader.setTable(this);
            }
            this.firePropertyChange("tableHeader", jTableHeader2, jTableHeader);
        }
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.rowModel = null;
        if (this.sortManager != null) {
            this.sortManager.modelRowSizes = null;
        }
        this.isRowHeightSet = true;
        this.resizeAndRepaint();
        this.firePropertyChange("rowHeight", n2, n);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    private SizeSequence getRowModel() {
        if (this.rowModel == null) {
            this.rowModel = new SizeSequence(this.getRowCount(), this.getRowHeight());
        }
        return this.rowModel;
    }

    public void setRowHeight(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.getRowModel().setSize(n, n2);
        if (this.sortManager != null) {
            this.sortManager.setViewRowHeight(n, n2);
        }
        this.resizeAndRepaint();
    }

    public int getRowHeight(int n) {
        return this.rowModel == null ? this.getRowHeight() : this.rowModel.getSize(n);
    }

    public void setRowMargin(int n) {
        int n2 = this.rowMargin;
        this.rowMargin = n;
        this.resizeAndRepaint();
        this.firePropertyChange("rowMargin", n2, n);
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.setRowMargin(dimension.height);
        this.getColumnModel().setColumnMargin(dimension.width);
        this.resizeAndRepaint();
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.rowMargin);
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setShowGrid(boolean bl) {
        this.setShowHorizontalLines(bl);
        this.setShowVerticalLines(bl);
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl) {
        boolean bl2 = this.showHorizontalLines;
        this.showHorizontalLines = bl;
        this.firePropertyChange("showHorizontalLines", bl2, bl);
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        boolean bl2 = this.showVerticalLines;
        this.showVerticalLines = bl;
        this.firePropertyChange("showVerticalLines", bl2, bl);
        this.repaint();
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setAutoResizeMode(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4) {
            int n2 = this.autoResizeMode;
            this.autoResizeMode = n;
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            this.firePropertyChange("autoResizeMode", n2, this.autoResizeMode);
        }
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        if (this.autoCreateColumnsFromModel != bl) {
            boolean bl2 = this.autoCreateColumnsFromModel;
            this.autoCreateColumnsFromModel = bl;
            if (bl) {
                this.createDefaultColumnsFromModel();
            }
            this.firePropertyChange("autoCreateColumnsFromModel", bl2, bl);
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                TableColumn tableColumn = new TableColumn(i);
                this.addColumn(tableColumn);
            }
        }
    }

    public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
        } else {
            this.defaultRenderersByColumnClass.remove(clazz);
        }
    }

    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Object v = this.defaultRenderersByColumnClass.get(clazz);
        if (v != null) {
            return (TableCellRenderer)v;
        }
        Class<Object> clazz2 = clazz.getSuperclass();
        if (clazz2 == null && clazz != Object.class) {
            clazz2 = Object.class;
        }
        return this.getDefaultRenderer(clazz2);
    }

    public void setDefaultEditor(Class<?> clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public TableCellEditor getDefaultEditor(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Object v = this.defaultEditorsByColumnClass.get(clazz);
        if (v != null) {
            return (TableCellEditor)v;
        }
        return this.getDefaultEditor(clazz.getSuperclass());
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDropMode(DropMode dropMode) {
        if (dropMode != null) {
            switch (dropMode) {
                case USE_SELECTION: 
                case ON: 
                case INSERT: 
                case INSERT_ROWS: 
                case INSERT_COLS: 
                case ON_OR_INSERT: 
                case ON_OR_INSERT_ROWS: 
                case ON_OR_INSERT_COLS: {
                    this.dropMode = dropMode;
                    return;
                }
            }
        }
        throw new IllegalArgumentException((Object)((Object)dropMode) + ": Unsupported drop mode for table");
    }

    public final DropMode getDropMode() {
        return this.dropMode;
    }

    @Override
    DropLocation dropLocationForPoint(Point point) {
        DropLocation dropLocation = null;
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        boolean bl = Boolean.TRUE == this.getClientProperty("Table.isFileList") && SwingUtilities2.pointOutsidePrefSize(this, n, n2, point);
        Rectangle rectangle = this.getCellRect(n, n2, true);
        boolean bl2 = false;
        boolean bl3 = this.getComponentOrientation().isLeftToRight();
        switch (this.dropMode) {
            case USE_SELECTION: 
            case ON: {
                if (n == -1 || n2 == -1 || bl) {
                    dropLocation = new DropLocation(point, -1, -1, false, false);
                    break;
                }
                dropLocation = new DropLocation(point, n, n2, false, false);
                break;
            }
            case INSERT: {
                if (n == -1 && n2 == -1) {
                    dropLocation = new DropLocation(point, 0, 0, true, true);
                    break;
                }
                SwingUtilities2.Section section = SwingUtilities2.liesInHorizontal(rectangle, point, bl3, true);
                if (n == -1) {
                    if (section == SwingUtilities2.Section.LEADING) {
                        dropLocation = new DropLocation(point, this.getRowCount(), n2, true, true);
                        break;
                    }
                    if (section == SwingUtilities2.Section.TRAILING) {
                        dropLocation = new DropLocation(point, this.getRowCount(), n2 + 1, true, true);
                        break;
                    }
                    dropLocation = new DropLocation(point, this.getRowCount(), n2, true, false);
                    break;
                }
                if (section == SwingUtilities2.Section.LEADING || section == SwingUtilities2.Section.TRAILING) {
                    SwingUtilities2.Section section2 = SwingUtilities2.liesInVertical(rectangle, point, true);
                    if (section2 == SwingUtilities2.Section.LEADING) {
                        bl2 = true;
                    } else if (section2 == SwingUtilities2.Section.TRAILING) {
                        ++n;
                        bl2 = true;
                    }
                    dropLocation = new DropLocation(point, n, section == SwingUtilities2.Section.TRAILING ? n2 + 1 : n2, bl2, true);
                    break;
                }
                if (SwingUtilities2.liesInVertical(rectangle, point, false) == SwingUtilities2.Section.TRAILING) {
                    ++n;
                }
                dropLocation = new DropLocation(point, n, n2, true, false);
                break;
            }
            case INSERT_ROWS: {
                if (n == -1 && n2 == -1) {
                    dropLocation = new DropLocation(point, -1, -1, false, false);
                    break;
                }
                if (n == -1) {
                    dropLocation = new DropLocation(point, this.getRowCount(), n2, true, false);
                    break;
                }
                if (SwingUtilities2.liesInVertical(rectangle, point, false) == SwingUtilities2.Section.TRAILING) {
                    ++n;
                }
                dropLocation = new DropLocation(point, n, n2, true, false);
                break;
            }
            case ON_OR_INSERT_ROWS: {
                if (n == -1 && n2 == -1) {
                    dropLocation = new DropLocation(point, -1, -1, false, false);
                    break;
                }
                if (n == -1) {
                    dropLocation = new DropLocation(point, this.getRowCount(), n2, true, false);
                    break;
                }
                SwingUtilities2.Section section = SwingUtilities2.liesInVertical(rectangle, point, true);
                if (section == SwingUtilities2.Section.LEADING) {
                    bl2 = true;
                } else if (section == SwingUtilities2.Section.TRAILING) {
                    ++n;
                    bl2 = true;
                }
                dropLocation = new DropLocation(point, n, n2, bl2, false);
                break;
            }
            case INSERT_COLS: {
                if (n == -1) {
                    dropLocation = new DropLocation(point, -1, -1, false, false);
                    break;
                }
                if (n2 == -1) {
                    dropLocation = new DropLocation(point, this.getColumnCount(), n2, false, true);
                    break;
                }
                if (SwingUtilities2.liesInHorizontal(rectangle, point, bl3, false) == SwingUtilities2.Section.TRAILING) {
                    ++n2;
                }
                dropLocation = new DropLocation(point, n, n2, false, true);
                break;
            }
            case ON_OR_INSERT_COLS: {
                if (n == -1) {
                    dropLocation = new DropLocation(point, -1, -1, false, false);
                    break;
                }
                if (n2 == -1) {
                    dropLocation = new DropLocation(point, n, this.getColumnCount(), false, true);
                    break;
                }
                SwingUtilities2.Section section = SwingUtilities2.liesInHorizontal(rectangle, point, bl3, true);
                if (section == SwingUtilities2.Section.LEADING) {
                    bl2 = true;
                } else if (section == SwingUtilities2.Section.TRAILING) {
                    ++n2;
                    bl2 = true;
                }
                dropLocation = new DropLocation(point, n, n2, false, bl2);
                break;
            }
            case ON_OR_INSERT: {
                if (n == -1 && n2 == -1) {
                    dropLocation = new DropLocation(point, 0, 0, true, true);
                    break;
                }
                SwingUtilities2.Section section = SwingUtilities2.liesInHorizontal(rectangle, point, bl3, true);
                if (n == -1) {
                    if (section == SwingUtilities2.Section.LEADING) {
                        dropLocation = new DropLocation(point, this.getRowCount(), n2, true, true);
                        break;
                    }
                    if (section == SwingUtilities2.Section.TRAILING) {
                        dropLocation = new DropLocation(point, this.getRowCount(), n2 + 1, true, true);
                        break;
                    }
                    dropLocation = new DropLocation(point, this.getRowCount(), n2, true, false);
                    break;
                }
                SwingUtilities2.Section section3 = SwingUtilities2.liesInVertical(rectangle, point, true);
                if (section3 == SwingUtilities2.Section.LEADING) {
                    bl2 = true;
                } else if (section3 == SwingUtilities2.Section.TRAILING) {
                    ++n;
                    bl2 = true;
                }
                dropLocation = new DropLocation(point, n, section == SwingUtilities2.Section.TRAILING ? n2 + 1 : n2, bl2, section != SwingUtilities2.Section.MIDDLE);
                break;
            }
            default: {
                assert (false) : "Unexpected drop mode";
                break;
            }
        }
        return dropLocation;
    }

    @Override
    Object setDropLocation(TransferHandler.DropLocation dropLocation, Object object, boolean bl) {
        Object object2;
        Object object3 = null;
        DropLocation dropLocation2 = (DropLocation)dropLocation;
        if (this.dropMode == DropMode.USE_SELECTION) {
            if (dropLocation2 == null) {
                if (!bl && object != null) {
                    this.clearSelection();
                    object2 = ((int[][])object)[0];
                    int[] nArray = ((int[][])object)[1];
                    int[] nArray2 = ((int[][])object)[2];
                    for (Object object4 : object2) {
                        this.addRowSelectionInterval((int)object4, (int)object4);
                    }
                    for (Object object4 : (Object)nArray) {
                        this.addColumnSelectionInterval((int)object4, (int)object4);
                    }
                    SwingUtilities2.setLeadAnchorWithoutSelection(this.getSelectionModel(), nArray2[1], nArray2[0]);
                    SwingUtilities2.setLeadAnchorWithoutSelection(this.getColumnModel().getSelectionModel(), nArray2[3], nArray2[2]);
                }
            } else {
                object3 = this.dropLocation == null ? (Object)new int[][]{this.getSelectedRows(), this.getSelectedColumns(), {this.getAdjustedIndex(this.getSelectionModel().getAnchorSelectionIndex(), true), this.getAdjustedIndex(this.getSelectionModel().getLeadSelectionIndex(), true), this.getAdjustedIndex(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex(), false), this.getAdjustedIndex(this.getColumnModel().getSelectionModel().getLeadSelectionIndex(), false)}} : object;
                if (dropLocation2.getRow() == -1) {
                    this.clearSelectionAndLeadAnchor();
                } else {
                    this.setRowSelectionInterval(dropLocation2.getRow(), dropLocation2.getRow());
                    this.setColumnSelectionInterval(dropLocation2.getColumn(), dropLocation2.getColumn());
                }
            }
        }
        object2 = this.dropLocation;
        this.dropLocation = dropLocation2;
        this.firePropertyChange("dropLocation", object2, this.dropLocation);
        return object3;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    public void setAutoCreateRowSorter(boolean bl) {
        boolean bl2 = this.autoCreateRowSorter;
        this.autoCreateRowSorter = bl;
        if (bl) {
            this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        }
        this.firePropertyChange("autoCreateRowSorter", bl2, bl);
    }

    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    public void setUpdateSelectionOnSort(boolean bl) {
        if (this.updateSelectionOnSort != bl) {
            this.updateSelectionOnSort = bl;
            this.firePropertyChange("updateSelectionOnSort", !bl, bl);
        }
    }

    public boolean getUpdateSelectionOnSort() {
        return this.updateSelectionOnSort;
    }

    public void setRowSorter(RowSorter<? extends TableModel> rowSorter) {
        RowSorter<? extends TableModel> rowSorter2 = null;
        if (this.sortManager != null) {
            rowSorter2 = this.sortManager.sorter;
            this.sortManager.dispose();
            this.sortManager = null;
        }
        this.rowModel = null;
        this.clearSelectionAndLeadAnchor();
        if (rowSorter != null) {
            this.sortManager = new SortManager(rowSorter);
        }
        this.resizeAndRepaint();
        this.firePropertyChange("rowSorter", rowSorter2, rowSorter);
        this.firePropertyChange("sorter", rowSorter2, rowSorter);
    }

    public RowSorter<? extends TableModel> getRowSorter() {
        return this.sortManager != null ? this.sortManager.sorter : null;
    }

    public void setSelectionMode(int n) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n);
        this.getColumnModel().getSelectionModel().setSelectionMode(n);
    }

    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this.rowSelectionAllowed;
        this.rowSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
        }
        this.firePropertyChange("rowSelectionAllowed", bl2, bl);
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this.columnModel.getColumnSelectionAllowed();
        this.columnModel.setColumnSelectionAllowed(bl);
        if (bl2 != bl) {
            this.repaint();
        }
        this.firePropertyChange("columnSelectionAllowed", bl2, bl);
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnModel.getColumnSelectionAllowed();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        boolean bl2 = this.cellSelectionEnabled;
        this.cellSelectionEnabled = bl;
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
    }

    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            ListSelectionModel listSelectionModel = this.selectionModel;
            listSelectionModel.setValueIsAdjusting(true);
            int n = this.getAdjustedIndex(listSelectionModel.getLeadSelectionIndex(), true);
            int n2 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex(), true);
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
            SwingUtilities2.setLeadAnchorWithoutSelection(listSelectionModel, n, n2);
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel = this.columnModel.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            n = this.getAdjustedIndex(listSelectionModel.getLeadSelectionIndex(), false);
            n2 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex(), false);
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
            SwingUtilities2.setLeadAnchorWithoutSelection(listSelectionModel, n, n2);
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.columnModel.getSelectionModel().clearSelection();
    }

    private void clearSelectionAndLeadAnchor() {
        this.selectionModel.setValueIsAdjusting(true);
        this.columnModel.getSelectionModel().setValueIsAdjusting(true);
        this.clearSelection();
        this.selectionModel.setAnchorSelectionIndex(-1);
        this.selectionModel.setLeadSelectionIndex(-1);
        this.columnModel.getSelectionModel().setAnchorSelectionIndex(-1);
        this.columnModel.getSelectionModel().setLeadSelectionIndex(-1);
        this.selectionModel.setValueIsAdjusting(false);
        this.columnModel.getSelectionModel().setValueIsAdjusting(false);
    }

    private int getAdjustedIndex(int n, boolean bl) {
        int n2 = bl ? this.getRowCount() : this.getColumnCount();
        return n < n2 ? n : -1;
    }

    private int boundRow(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        return n;
    }

    private int boundColumn(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        return n;
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.selectionModel.setSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void setColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().setSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public void addRowSelectionInterval(int n, int n2) {
        this.selectionModel.addSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().addSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public void removeRowSelectionInterval(int n, int n2) {
        this.selectionModel.removeSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().removeSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        int n = this.selectionModel.getMinSelectionIndex();
        int n2 = this.selectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public int[] getSelectedColumns() {
        return this.columnModel.getSelectedColumns();
    }

    public int getSelectedRowCount() {
        int n = this.selectionModel.getMinSelectionIndex();
        int n2 = this.selectionModel.getMaxSelectionIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public boolean isRowSelected(int n) {
        return this.selectionModel.isSelectedIndex(n);
    }

    public boolean isColumnSelected(int n) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(n) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n2));
    }

    private void changeSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        if (bl2) {
            if (bl) {
                if (bl4) {
                    listSelectionModel.addSelectionInterval(n2, n);
                } else {
                    listSelectionModel.removeSelectionInterval(n2, n);
                    if (Boolean.TRUE == this.getClientProperty("Table.isFileList")) {
                        listSelectionModel.addSelectionInterval(n, n);
                        listSelectionModel.setAnchorSelectionIndex(n2);
                    }
                }
            } else {
                listSelectionModel.setSelectionInterval(n2, n);
            }
        } else if (bl) {
            if (bl3) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        int n3 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex(), true);
        int n4 = this.getAdjustedIndex(listSelectionModel2.getAnchorSelectionIndex(), false);
        boolean bl3 = true;
        if (n3 == -1) {
            if (this.getRowCount() > 0) {
                n3 = 0;
            }
            bl3 = false;
        }
        if (n4 == -1) {
            if (this.getColumnCount() > 0) {
                n4 = 0;
            }
            bl3 = false;
        }
        boolean bl4 = this.isCellSelected(n, n2);
        bl3 = bl3 && this.isCellSelected(n3, n4);
        this.changeSelectionModel(listSelectionModel2, n2, bl, bl2, bl4, n4, bl3);
        this.changeSelectionModel(listSelectionModel, n, bl, bl2, bl4, n3, bl3);
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, n2, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
        this.repaint();
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        this.repaint();
    }

    public TableColumn getColumn(Object object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndex(object);
        return tableColumnModel.getColumn(n);
    }

    public int convertColumnIndexToModel(int n) {
        return SwingUtilities2.convertColumnIndexToModel(this.getColumnModel(), n);
    }

    public int convertColumnIndexToView(int n) {
        return SwingUtilities2.convertColumnIndexToView(this.getColumnModel(), n);
    }

    public int convertRowIndexToView(int n) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            return rowSorter.convertRowIndexToView(n);
        }
        return n;
    }

    public int convertRowIndexToModel(int n) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            return rowSorter.convertRowIndexToModel(n);
        }
        return n;
    }

    public int getRowCount() {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            return rowSorter.getViewRowCount();
        }
        return this.getModel().getRowCount();
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public String getColumnName(int n) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n));
    }

    public Class<?> getColumnClass(int n) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n));
    }

    public Object getValueAt(int n, int n2) {
        return this.getModel().getValueAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getModel().setValueAt(object, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getModel().isCellEditable(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getHeaderValue() == null) {
            int n = tableColumn.getModelIndex();
            String string = this.getModel().getColumnName(n);
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        this.getColumnModel().removeColumn(tableColumn);
    }

    public void moveColumn(int n, int n2) {
        this.getColumnModel().moveColumn(n, n2);
    }

    public int columnAtPoint(Point point) {
        int n = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            n = this.getWidth() - n - 1;
        }
        return this.getColumnModel().getColumnIndexAtX(n);
    }

    public int rowAtPoint(Point point) {
        int n;
        int n2 = point.y;
        int n3 = n = this.rowModel == null ? n2 / this.getRowHeight() : this.rowModel.getIndex(n2);
        if (n < 0) {
            return -1;
        }
        if (n >= this.getRowCount()) {
            return -1;
        }
        return n;
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3;
        Rectangle rectangle = new Rectangle();
        boolean bl2 = true;
        if (n < 0) {
            bl2 = false;
        } else if (n >= this.getRowCount()) {
            rectangle.y = this.getHeight();
            bl2 = false;
        } else {
            rectangle.height = this.getRowHeight(n);
            int n4 = rectangle.y = this.rowModel == null ? n * rectangle.height : this.rowModel.getPosition(n);
        }
        if (n2 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl2 = false;
        } else if (n2 >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl2 = false;
        } else {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    rectangle.x += tableColumnModel.getColumn(n3).getWidth();
                }
            } else {
                for (n3 = tableColumnModel.getColumnCount() - 1; n3 > n2; --n3) {
                    rectangle.x += tableColumnModel.getColumn(n3).getWidth();
                }
            }
            rectangle.width = tableColumnModel.getColumn(n2).getWidth();
        }
        if (bl2 && !bl) {
            int n5 = Math.min(this.getRowMargin(), rectangle.height);
            n3 = Math.min(this.getColumnModel().getColumnMargin(), rectangle.width);
            rectangle.setBounds(rectangle.x + n3 / 2, rectangle.y + n5 / 2, rectangle.width - n3, rectangle.height - n5);
        }
        return rectangle;
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void doLayout() {
        TableColumn tableColumn = this.getResizingColumn();
        if (tableColumn == null) {
            this.setWidthsFromPreferredWidths(false);
        } else {
            int n = this.viewIndexForColumn(tableColumn);
            int n2 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n, n2);
            n2 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            if (n2 != 0) {
                tableColumn.setWidth(tableColumn.getWidth() + n2);
            }
            this.setWidthsFromPreferredWidths(true);
        }
        super.doLayout();
    }

    private TableColumn getResizingColumn() {
        return this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
    }

    @Deprecated
    public void sizeColumnsToFit(boolean bl) {
        int n = this.autoResizeMode;
        this.setAutoResizeMode(bl ? 3 : 4);
        this.sizeColumnsToFit(-1);
        this.setAutoResizeMode(n);
    }

    public void sizeColumnsToFit(int n) {
        if (n == -1) {
            this.setWidthsFromPreferredWidths(false);
        } else if (this.autoResizeMode == 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        } else {
            int n2 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n, n2);
            this.setWidthsFromPreferredWidths(true);
        }
    }

    private void setWidthsFromPreferredWidths(final boolean bl) {
        int n = this.getWidth();
        int n2 = this.getPreferredSize().width;
        int n3 = !bl ? n : n2;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            @Override
            public int getElementCount() {
                return tableColumnModel.getColumnCount();
            }

            @Override
            public int getLowerBoundAt(int n) {
                return tableColumnModel.getColumn(n).getMinWidth();
            }

            @Override
            public int getUpperBoundAt(int n) {
                return tableColumnModel.getColumn(n).getMaxWidth();
            }

            @Override
            public int getMidPointAt(int n) {
                if (!bl) {
                    return tableColumnModel.getColumn(n).getPreferredWidth();
                }
                return tableColumnModel.getColumn(n).getWidth();
            }

            @Override
            public void setSizeAt(int n, int n2) {
                if (!bl) {
                    tableColumnModel.getColumn(n2).setWidth(n);
                } else {
                    tableColumnModel.getColumn(n2).setPreferredWidth(n);
                }
            }
        };
        this.adjustSizes((long)n3, resizable3, bl);
    }

    private void accommodateDelta(int n, int n2) {
        int n3;
        int n4 = this.getColumnCount();
        int n5 = n;
        switch (this.autoResizeMode) {
            case 1: {
                n3 = Math.min(++n5 + 1, n4);
                break;
            }
            case 2: {
                ++n5;
                n3 = n4;
                break;
            }
            case 3: {
                n5 = n4 - 1;
                n3 = n5 + 1;
                break;
            }
            case 4: {
                n5 = 0;
                n3 = n4;
                break;
            }
            default: {
                return;
            }
        }
        final int n6 = n5;
        final int n7 = n3;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            @Override
            public int getElementCount() {
                return n7 - n6;
            }

            @Override
            public int getLowerBoundAt(int n) {
                return tableColumnModel.getColumn(n + n6).getMinWidth();
            }

            @Override
            public int getUpperBoundAt(int n) {
                return tableColumnModel.getColumn(n + n6).getMaxWidth();
            }

            @Override
            public int getMidPointAt(int n) {
                return tableColumnModel.getColumn(n + n6).getWidth();
            }

            @Override
            public void setSizeAt(int n, int n2) {
                tableColumnModel.getColumn(n2 + n6).setWidth(n);
            }
        };
        int n8 = 0;
        for (int i = n5; i < n3; ++i) {
            TableColumn tableColumn = this.columnModel.getColumn(i);
            int n9 = tableColumn.getWidth();
            n8 += n9;
        }
        this.adjustSizes((long)(n8 + n2), resizable3, false);
    }

    private void adjustSizes(long l, final Resizable3 resizable3, boolean bl) {
        int n = resizable3.getElementCount();
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            l2 += (long)resizable3.getMidPointAt(i);
        }
        Resizable2 resizable2 = l < l2 == !bl ? new Resizable2(){

            @Override
            public int getElementCount() {
                return resizable3.getElementCount();
            }

            @Override
            public int getLowerBoundAt(int n) {
                return resizable3.getLowerBoundAt(n);
            }

            @Override
            public int getUpperBoundAt(int n) {
                return resizable3.getMidPointAt(n);
            }

            @Override
            public void setSizeAt(int n, int n2) {
                resizable3.setSizeAt(n, n2);
            }
        } : new Resizable2(){

            @Override
            public int getElementCount() {
                return resizable3.getElementCount();
            }

            @Override
            public int getLowerBoundAt(int n) {
                return resizable3.getMidPointAt(n);
            }

            @Override
            public int getUpperBoundAt(int n) {
                return resizable3.getUpperBoundAt(n);
            }

            @Override
            public void setSizeAt(int n, int n2) {
                resizable3.setSizeAt(n, n2);
            }
        };
        this.adjustSizes(l, resizable2, !bl);
    }

    private void adjustSizes(long l, Resizable2 resizable2, boolean bl) {
        int n;
        long l2 = 0L;
        long l3 = 0L;
        for (n = 0; n < resizable2.getElementCount(); ++n) {
            l2 += (long)resizable2.getLowerBoundAt(n);
            l3 += (long)resizable2.getUpperBoundAt(n);
        }
        if (bl) {
            l = Math.min(Math.max(l2, l), l3);
        }
        for (n = 0; n < resizable2.getElementCount(); ++n) {
            int n2;
            int n3 = resizable2.getLowerBoundAt(n);
            int n4 = resizable2.getUpperBoundAt(n);
            if (l2 == l3) {
                n2 = n3;
            } else {
                double d = (double)(l - l2) / (double)(l3 - l2);
                n2 = (int)Math.round((double)n3 + d * (double)(n4 - n3));
            }
            resizable2.setSizeAt(n2, n);
            l -= (long)n2;
            l2 -= (long)n3;
            l3 -= (long)n4;
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n2, n, false);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
            AWTAccessor.MouseEventAccessor mouseEventAccessor = AWTAccessor.getMouseEventAccessor();
            mouseEventAccessor.setCausedByTouchEvent(mouseEvent2, mouseEventAccessor.isCausedByTouchEvent(mouseEvent));
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public void setSurrendersFocusOnKeystroke(boolean bl) {
        this.surrendersFocusOnKeystroke = bl;
    }

    public boolean getSurrendersFocusOnKeystroke() {
        return this.surrendersFocusOnKeystroke;
    }

    public boolean editCellAt(int n, int n2) {
        return this.editCellAt(n, n2, null);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Object object;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.editorRemover == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover((KeyboardFocusManager)object);
            ((KeyboardFocusManager)object).addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((object = this.getCellEditor(n, n2)) != null && object.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor((TableCellEditor)object, n, n2);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(n, n2, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editorComp.repaint();
            this.setCellEditor((TableCellEditor)object);
            this.setEditingRow(n);
            this.setEditingColumn(n2);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            object = tableColumnModel.getColumn(i);
            SwingUtilities.updateRendererOrEditorUI(((TableColumn)object).getCellRenderer());
            SwingUtilities.updateRendererOrEditorUI(((TableColumn)object).getCellEditor());
            SwingUtilities.updateRendererOrEditorUI(((TableColumn)object).getHeaderRenderer());
        }
        Enumeration enumeration = this.defaultRenderersByColumnClass.elements();
        while (enumeration.hasMoreElements()) {
            SwingUtilities.updateRendererOrEditorUI(enumeration.nextElement());
        }
        object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            SwingUtilities.updateRendererOrEditorUI(object.nextElement());
        }
        if (this.tableHeader != null && this.tableHeader.getParent() == null) {
            this.tableHeader.updateUI();
        }
        this.configureEnclosingScrollPaneUI();
        this.setUI((TableUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this.dataModel != tableModel) {
            TableModel tableModel2 = this.dataModel;
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
            this.tableChanged(new TableModelEvent(tableModel, -1));
            this.firePropertyChange("model", tableModel2, tableModel);
            if (this.getAutoCreateRowSorter()) {
                this.setRowSorter(new TableRowSorter<TableModel>(tableModel));
            }
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            if (this.tableHeader != null) {
                this.tableHeader.setColumnModel(tableColumnModel);
            }
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
            this.repaint();
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void sorterChanged(RowSorterEvent rowSorterEvent) {
        if (rowSorterEvent.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                jTableHeader.repaint();
            }
        } else if (rowSorterEvent.getType() == RowSorterEvent.Type.SORTED) {
            this.sorterChanged = true;
            if (!this.ignoreSortChange) {
                this.sortedTableChanged(rowSorterEvent, null);
            }
        }
    }

    private void sortedTableChanged(RowSorterEvent rowSorterEvent, TableModelEvent tableModelEvent) {
        ModelChange modelChange;
        int n = -1;
        ModelChange modelChange2 = modelChange = tableModelEvent != null ? new ModelChange(tableModelEvent) : null;
        if (!(modelChange != null && modelChange.allRowsChanged || this.editingRow == -1)) {
            n = this.convertRowIndexToModel(rowSorterEvent, this.editingRow);
        }
        this.sortManager.prepareForChange(rowSorterEvent, modelChange);
        if (tableModelEvent != null) {
            if (modelChange.type == 0) {
                this.repaintSortedRows(modelChange);
            }
            this.notifySorter(modelChange);
            if (modelChange.type != 0) {
                this.sorterChanged = true;
            }
        } else {
            this.sorterChanged = true;
        }
        this.sortManager.processChange(rowSorterEvent, modelChange, this.sorterChanged);
        if (this.sorterChanged) {
            if (this.editingRow != -1) {
                int n2 = n == -1 ? -1 : this.convertRowIndexToView(n, modelChange);
                this.restoreSortingEditingRow(n2);
            }
            if (tableModelEvent == null || modelChange.type != 0) {
                this.resizeAndRepaint();
            }
        }
        if (modelChange != null && modelChange.allRowsChanged) {
            this.clearSelectionAndLeadAnchor();
            this.resizeAndRepaint();
        }
    }

    private void repaintSortedRows(ModelChange modelChange) {
        if (modelChange.startModelIndex > modelChange.endModelIndex || modelChange.startModelIndex + 10 < modelChange.endModelIndex) {
            this.repaint();
            return;
        }
        int n = modelChange.event.getColumn();
        int n2 = n;
        if (n2 == -1) {
            n2 = 0;
        } else if ((n2 = this.convertColumnIndexToView(n2)) == -1) {
            return;
        }
        int n3 = modelChange.startModelIndex;
        while (n3 <= modelChange.endModelIndex) {
            int n4;
            if ((n4 = this.convertRowIndexToView(n3++)) == -1) continue;
            Rectangle rectangle = this.getCellRect(n4, n2, false);
            int n5 = rectangle.x;
            int n6 = rectangle.width;
            if (n == -1) {
                n5 = 0;
                n6 = this.getWidth();
            }
            this.repaint(n5, rectangle.y, n6, rectangle.height);
        }
    }

    private void restoreSortingSelection(int[] nArray, int n, ModelChange modelChange) {
        int n2;
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            nArray[n2] = this.convertRowIndexToView(nArray[n2], modelChange);
        }
        n = this.convertRowIndexToView(n, modelChange);
        if (nArray.length == 0 || nArray.length == 1 && nArray[0] == this.getSelectedRow()) {
            return;
        }
        this.selectionModel.setValueIsAdjusting(true);
        this.selectionModel.clearSelection();
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            if (nArray[n2] == -1) continue;
            this.selectionModel.addSelectionInterval(nArray[n2], nArray[n2]);
        }
        SwingUtilities2.setLeadAnchorWithoutSelection(this.selectionModel, n, n);
        this.selectionModel.setValueIsAdjusting(false);
    }

    private void restoreSortingEditingRow(int n) {
        if (n == -1) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.cancelCellEditing();
                if (this.getCellEditor() != null) {
                    this.removeEditor();
                }
            }
        } else {
            this.editingRow = n;
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifySorter(ModelChange modelChange) {
        try {
            this.ignoreSortChange = true;
            this.sorterChanged = false;
            switch (modelChange.type) {
                case 0: {
                    if (modelChange.event.getLastRow() == Integer.MAX_VALUE) {
                        this.sortManager.sorter.allRowsChanged();
                        return;
                    }
                    if (modelChange.event.getColumn() == -1) {
                        this.sortManager.sorter.rowsUpdated(modelChange.startModelIndex, modelChange.endModelIndex);
                        return;
                    }
                    this.sortManager.sorter.rowsUpdated(modelChange.startModelIndex, modelChange.endModelIndex, modelChange.event.getColumn());
                    return;
                }
                case 1: {
                    this.sortManager.sorter.rowsInserted(modelChange.startModelIndex, modelChange.endModelIndex);
                    return;
                }
                case -1: {
                    this.sortManager.sorter.rowsDeleted(modelChange.startModelIndex, modelChange.endModelIndex);
                    return;
                }
            }
            return;
        }
        finally {
            this.ignoreSortChange = false;
        }
    }

    private int convertRowIndexToView(int n, ModelChange modelChange) {
        if (n < 0) {
            return -1;
        }
        if (modelChange != null && n >= modelChange.startModelIndex) {
            if (modelChange.type == 1) {
                if (n + modelChange.length >= modelChange.modelRowCount) {
                    return -1;
                }
                return this.sortManager.sorter.convertRowIndexToView(n + modelChange.length);
            }
            if (modelChange.type == -1) {
                if (n <= modelChange.endModelIndex) {
                    return -1;
                }
                if (n - modelChange.length >= modelChange.modelRowCount) {
                    return -1;
                }
                return this.sortManager.sorter.convertRowIndexToView(n - modelChange.length);
            }
        }
        if (n >= this.getModel().getRowCount()) {
            return -1;
        }
        return this.sortManager.sorter.convertRowIndexToView(n);
    }

    private int[] convertSelectionToModel(RowSorterEvent rowSorterEvent) {
        int[] nArray = this.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = this.convertRowIndexToModel(rowSorterEvent, nArray[i]);
        }
        return nArray;
    }

    private int convertRowIndexToModel(RowSorterEvent rowSorterEvent, int n) {
        if (rowSorterEvent != null) {
            if (rowSorterEvent.getPreviousRowCount() == 0) {
                return n;
            }
            return rowSorterEvent.convertPreviousRowIndexToModel(n);
        }
        if (n < 0 || n >= this.getRowCount()) {
            return -1;
        }
        return this.convertRowIndexToModel(n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.clearSelectionAndLeadAnchor();
            this.rowModel = null;
            if (this.sortManager != null) {
                try {
                    this.ignoreSortChange = true;
                    this.sortManager.sorter.modelStructureChanged();
                }
                finally {
                    this.ignoreSortChange = false;
                }
                this.sortManager.allChanged();
            }
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
                return;
            }
            this.resizeAndRepaint();
            return;
        }
        if (this.sortManager != null) {
            this.sortedTableChanged(null, tableModelEvent);
            return;
        }
        if (this.rowModel != null) {
            this.repaint();
        }
        if (tableModelEvent.getType() == 1) {
            this.tableRowsInserted(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.tableRowsDeleted(tableModelEvent);
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n == -1) {
            rectangle = new Rectangle(0, n2 * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n4 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n4, false);
        }
        if (n3 != Integer.MAX_VALUE) {
            rectangle.height = (n3 - n2 + 1) * this.getRowHeight();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clearSelectionAndLeadAnchor();
            this.resizeAndRepaint();
            this.rowModel = null;
        }
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        this.selectionModel.insertIndexInterval(n, n3, true);
        if (this.rowModel != null) {
            this.rowModel.insertEntries(n, n3, this.getRowHeight());
        }
        int n4 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n * n4, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n) * n4);
        this.revalidate();
        this.repaint(rectangle);
    }

    private void tableRowsDeleted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        int n4 = this.getRowCount() + n3;
        this.selectionModel.removeIndexInterval(n, n2);
        if (this.rowModel != null) {
            this.rowModel.removeEntries(n, n3);
        }
        int n5 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n * n5, this.getColumnModel().getTotalColumnWidth(), (n4 - n) * n5);
        this.revalidate();
        this.repaint(rectangle);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        TableColumn tableColumn;
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if ((tableColumn = this.getResizingColumn()) != null && this.autoResizeMode == 0) {
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    private int limit(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n, n2));
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (this.columnSelectionAdjusting && !bl) {
            this.columnSelectionAdjusting = false;
            return;
        }
        this.columnSelectionAdjusting = bl;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getColumnCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getColumnCount() - 1);
        int n3 = 0;
        int n4 = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            n3 = this.selectionModel.getMinSelectionIndex();
            n4 = this.selectionModel.getMaxSelectionIndex();
            int n5 = this.getAdjustedIndex(this.selectionModel.getLeadSelectionIndex(), true);
            if (n3 == -1 || n4 == -1) {
                if (n5 == -1) {
                    return;
                }
                n3 = n4 = n5;
            } else if (n5 != -1) {
                n3 = Math.min(n3, n5);
                n4 = Math.max(n4, n5);
            }
        }
        Rectangle rectangle = this.getCellRect(n3, n, false);
        Rectangle rectangle2 = this.getCellRect(n4, n2, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.sortManager != null) {
            this.sortManager.viewSelectionChanged(listSelectionEvent);
        }
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (this.rowSelectionAdjusting && !bl) {
            this.rowSelectionAdjusting = false;
            return;
        }
        this.rowSelectionAdjusting = bl;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getRowCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getRowCount() - 1);
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getCellRect(n2, this.getColumnCount() - 1, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = this.getLeadingRow(rectangle);
        int n4 = this.getLeadingCol(rectangle);
        if (n == 1 && n3 < 0) {
            return this.getRowHeight();
        }
        if (n == 0 && n4 < 0) {
            return 100;
        }
        Rectangle rectangle2 = this.getCellRect(n3, n4, true);
        int n5 = this.leadingEdge(rectangle, n);
        int n6 = this.leadingEdge(rectangle2, n);
        int n7 = n == 1 ? rectangle2.height : rectangle2.width;
        if (n5 == n6) {
            if (n2 < 0) {
                int n8 = 0;
                if (n == 1) {
                    while (--n3 >= 0 && (n8 = this.getRowHeight(n3)) == 0) {
                    }
                } else {
                    while (--n4 >= 0 && (n8 = this.getCellRect((int)n3, (int)n4, (boolean)true).width) == 0) {
                    }
                }
                return n8;
            }
            return n7;
        }
        int n9 = Math.abs(n5 - n6);
        int n10 = n7 - n9;
        if (n2 > 0) {
            return n10;
        }
        return n9;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getRowCount() == 0) {
            if (1 == n) {
                int n3 = this.getRowHeight();
                return n3 > 0 ? Math.max(n3, rectangle.height / n3 * n3) : rectangle.height;
            }
            return rectangle.width;
        }
        if (null == this.rowModel && 1 == n) {
            int n4 = this.rowAtPoint(rectangle.getLocation());
            assert (n4 != -1);
            int n5 = this.columnAtPoint(rectangle.getLocation());
            Rectangle rectangle2 = this.getCellRect(n4, n5, true);
            if (rectangle2.y == rectangle.y) {
                int n6 = this.getRowHeight();
                assert (n6 > 0);
                return Math.max(n6, rectangle.height / n6 * n6);
            }
        }
        if (n2 < 0) {
            return this.getPreviousBlockIncrement(rectangle, n);
        }
        return this.getNextBlockIncrement(rectangle, n);
    }

    private int getPreviousBlockIncrement(Rectangle rectangle, int n) {
        int n2;
        Point point;
        int n3;
        int n4 = this.leadingEdge(rectangle, n);
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (n == 1) {
            n3 = n4 - rectangle.height;
            int n5 = rectangle.x + (bl ? 0 : rectangle.width);
            point = new Point(n5, n3);
        } else if (bl) {
            n3 = n4 - rectangle.width;
            point = new Point(n3, rectangle.y);
        } else {
            n3 = n4 + rectangle.width;
            point = new Point(n3 - 1, rectangle.y);
        }
        int n6 = this.rowAtPoint(point);
        int n7 = this.columnAtPoint(point);
        if (n == 1 & n6 < 0) {
            n2 = 0;
        } else if (n == 0 & n7 < 0) {
            n2 = bl ? 0 : this.getWidth();
        } else {
            Rectangle rectangle2 = this.getCellRect(n6, n7, true);
            int n8 = this.leadingEdge(rectangle2, n);
            int n9 = this.trailingEdge(rectangle2, n);
            n2 = (n == 1 || bl) && n9 >= n4 ? n8 : (n == 0 && !bl && n9 <= n4 ? n8 : (n3 == n8 ? n8 : n9));
        }
        return Math.abs(n4 - n2);
    }

    private int getNextBlockIncrement(Rectangle rectangle, int n) {
        boolean bl;
        int n2 = this.getTrailingRow(rectangle);
        int n3 = this.getTrailingCol(rectangle);
        int n4 = this.leadingEdge(rectangle, n);
        if (n == 1 && n2 < 0) {
            return rectangle.height;
        }
        if (n == 0 && n3 < 0) {
            return rectangle.width;
        }
        Rectangle rectangle2 = this.getCellRect(n2, n3, true);
        int n5 = this.leadingEdge(rectangle2, n);
        int n6 = this.trailingEdge(rectangle2, n);
        if (n == 1 || this.getComponentOrientation().isLeftToRight()) {
            bl = n5 <= n4;
        } else {
            boolean bl2 = bl = n5 >= n4;
        }
        int n7 = bl ? n6 : (n6 == this.trailingEdge(rectangle, n) ? n6 : n5);
        return Math.abs(n7 - n4);
    }

    private int getLeadingRow(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.rowAtPoint(point);
    }

    private int getLeadingCol(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int getTrailingRow(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y + rectangle.height - 1) : new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.rowAtPoint(point);
    }

    private int getTrailingCol(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x + rectangle.width - 1, rectangle.y) : new Point(rectangle.x, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int leadingEdge(Rectangle rectangle, int n) {
        if (n == 1) {
            return rectangle.y;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x;
        }
        return rectangle.x + rectangle.width;
    }

    private int trailingEdge(Rectangle rectangle, int n) {
        if (n == 1) {
            return rectangle.y + rectangle.height;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x + rectangle.width;
        }
        return rectangle.x;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        return this.getFillsViewportHeight() && container instanceof JViewport && container.getHeight() > this.getPreferredSize().height;
    }

    public void setFillsViewportHeight(boolean bl) {
        boolean bl2 = this.fillsViewportHeight;
        this.fillsViewportHeight = bl;
        this.resizeAndRepaint();
        this.firePropertyChange("fillsViewportHeight", bl2, bl);
    }

    public boolean getFillsViewportHeight() {
        return this.fillsViewportHeight;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (!bl2 && n == 1 && this.isFocusOwner() && !Boolean.FALSE.equals(this.getClientProperty("JTable.autoStartsEdit"))) {
            Component component = this.getEditorComponent();
            if (component == null) {
                if (keyEvent == null || keyEvent.getID() != 401) {
                    return false;
                }
                int n2 = keyEvent.getKeyCode();
                if (n2 == 16 || n2 == 17 || n2 == 18 || n2 == 157 || n2 == 65406) {
                    return false;
                }
                int n3 = this.getSelectionModel().getLeadSelectionIndex();
                int n4 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n3 != -1 && n4 != -1 && !this.isEditing() && !this.editCellAt(n3, n4, keyEvent)) {
                    return false;
                }
                component = this.getEditorComponent();
                if (component == null) {
                    return false;
                }
            }
            if (component instanceof JComponent) {
                bl2 = ((JComponent)component).processKeyBinding(keyStroke, keyEvent, 0, bl);
                Object object = this.getClientProperty("JTable.forceAutoStartsEdit");
                if (this.getSurrendersFocusOnKeystroke() || Boolean.TRUE.equals(object)) {
                    component.requestFocus();
                }
            }
        }
        return bl2;
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults(8, 0.75f);
        this.defaultRenderersByColumnClass.put(Object.class, uIDefaults -> new DefaultTableCellRenderer.UIResource());
        this.defaultRenderersByColumnClass.put(Number.class, uIDefaults -> new NumberRenderer());
        this.defaultRenderersByColumnClass.put(Float.class, uIDefaults -> new DoubleRenderer());
        this.defaultRenderersByColumnClass.put(Double.class, uIDefaults -> new DoubleRenderer());
        this.defaultRenderersByColumnClass.put(Date.class, uIDefaults -> new DateRenderer());
        this.defaultRenderersByColumnClass.put(Icon.class, uIDefaults -> new IconRenderer());
        this.defaultRenderersByColumnClass.put(ImageIcon.class, uIDefaults -> new IconRenderer());
        this.defaultRenderersByColumnClass.put(Boolean.class, uIDefaults -> new BooleanRenderer());
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults(3, 0.75f);
        this.defaultEditorsByColumnClass.put(Object.class, uIDefaults -> new GenericEditor());
        this.defaultEditorsByColumnClass.put(Number.class, uIDefaults -> new NumberEditor());
        this.defaultEditorsByColumnClass.put(Boolean.class, uIDefaults -> new BooleanEditor());
    }

    protected void initializeLocalVars() {
        this.updateSelectionOnSort = true;
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(2);
        this.setRowHeight(16);
        this.isRowHeightSet = false;
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setSurrendersFocusOnKeystroke(false);
        this.setPreferredScrollableViewportSize(new Dimension(450, 400));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("tableCellEditor", tableCellEditor2, tableCellEditor);
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        }
        return tableCellRenderer;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isCellSelected(n, n2);
            boolean bl3 = this.selectionModel.getLeadSelectionIndex() == n;
            boolean bl4 = this.columnModel.getSelectionModel().getLeadSelectionIndex() == n2;
            bl2 = bl3 && bl4 && this.isFocusOwner();
        }
        return tableCellRenderer.getTableCellRendererComponent(this, object, bl, bl2, n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        return tableCellEditor;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        JComponent jComponent;
        boolean bl;
        Object object = this.getValueAt(n, n2);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl = this.isCellSelected(n, n2), n, n2);
        if (component instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Serializable serializable;
            tableCellEditor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                serializable = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = serializable != null ? SwingUtilities.isDescendingFrom(serializable, this) : false;
                this.remove(this.editorComp);
                if (bl) {
                    this.requestFocusInWindow();
                }
            }
            serializable = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint((Rectangle)serializable);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        this.createDefaultRenderers();
        this.createDefaultEditors();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    @Override
    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    protected String paramString() {
        String string;
        String string2 = this.gridColor != null ? this.gridColor.toString() : "";
        String string3 = this.showHorizontalLines ? "true" : "false";
        String string4 = string = this.showVerticalLines ? "true" : "false";
        String string5 = this.autoResizeMode == 0 ? "AUTO_RESIZE_OFF" : (this.autoResizeMode == 1 ? "AUTO_RESIZE_NEXT_COLUMN" : (this.autoResizeMode == 2 ? "AUTO_RESIZE_SUBSEQUENT_COLUMNS" : (this.autoResizeMode == 3 ? "AUTO_RESIZE_LAST_COLUMN" : (this.autoResizeMode == 4 ? "AUTO_RESIZE_ALL_COLUMNS" : ""))));
        String string6 = this.autoCreateColumnsFromModel ? "true" : "false";
        String string7 = this.preferredViewportSize != null ? this.preferredViewportSize.toString() : "";
        String string8 = this.rowSelectionAllowed ? "true" : "false";
        String string9 = this.cellSelectionEnabled ? "true" : "false";
        String string10 = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string11 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",autoCreateColumnsFromModel=" + string6 + ",autoResizeMode=" + string5 + ",cellSelectionEnabled=" + string9 + ",editingColumn=" + this.editingColumn + ",editingRow=" + this.editingRow + ",gridColor=" + string2 + ",preferredViewportSize=" + string7 + ",rowHeight=" + this.rowHeight + ",rowMargin=" + this.rowMargin + ",rowSelectionAllowed=" + string8 + ",selectionBackground=" + string11 + ",selectionForeground=" + string10 + ",showHorizontalLines=" + string3 + ",showVerticalLines=" + string;
    }

    public boolean print() throws PrinterException {
        return this.print(PrintMode.FIT_WIDTH);
    }

    public boolean print(PrintMode printMode) throws PrinterException {
        return this.print(printMode, null, null);
    }

    public boolean print(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        boolean bl = !GraphicsEnvironment.isHeadless();
        return this.print(printMode, messageFormat, messageFormat2, bl, null, bl);
    }

    public boolean print(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2) throws PrinterException, HeadlessException {
        return this.print(printMode, messageFormat, messageFormat2, bl, printRequestAttributeSet, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2, PrintService printService) throws PrinterException, HeadlessException {
        Throwable throwable;
        PrintingStatus printingStatus;
        boolean bl3 = GraphicsEnvironment.isHeadless();
        if (bl3) {
            if (bl) {
                throw new HeadlessException("Can't show print dialog.");
            }
            if (bl2) {
                throw new HeadlessException("Can't run interactively.");
            }
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        Printable printable = this.getPrintable(printMode, messageFormat, messageFormat2);
        if (bl2) {
            printable = new ThreadSafePrintable(printable);
            printingStatus = PrintingStatus.createPrintingStatus(this, printerJob);
            printable = printingStatus.createNotificationPrintable(printable);
        } else {
            printingStatus = null;
        }
        printerJob.setPrintable(printable);
        if (printService != null) {
            printerJob.setPrintService(printService);
        }
        if (bl && !printerJob.printDialog(printRequestAttributeSet)) {
            return false;
        }
        if (!bl2) {
            printerJob.print(printRequestAttributeSet);
            return true;
        }
        this.printError = null;
        final Object object = new Object();
        final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                catch (Throwable throwable) {
                    Object object2 = object;
                    synchronized (object2) {
                        JTable.this.printError = throwable;
                    }
                }
                finally {
                    printingStatus.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        printingStatus.showModal(true);
        Object object2 = object;
        synchronized (object2) {
            throwable = this.printError;
            this.printError = null;
        }
        if (throwable != null) {
            if (throwable instanceof PrinterAbortException) {
                return false;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    public Printable getPrintable(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        return new TablePrintable(this, printMode, messageFormat, messageFormat2);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        int previousFocusedRow;
        int previousFocusedCol;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescription;
        private Accessible[] columnDescription;

        protected AccessibleJTable() {
            super(JTable.this);
            JTable.this.putClientProperty("JTable.forceAutoStartsEdit", true);
            JTable.this.addPropertyChangeListener(this);
            JTable.this.getSelectionModel().addListSelectionListener(this);
            TableColumnModel tableColumnModel = JTable.this.getColumnModel();
            tableColumnModel.addColumnModelListener(this);
            tableColumnModel.getSelectionModel().addListSelectionListener(this);
            JTable.this.getModel().addTableModelListener(this);
            this.previousFocusedRow = JTable.this.getSelectionModel().getLeadSelectionIndex();
            this.previousFocusedCol = JTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.equals("model")) {
                if (object != null && object instanceof TableModel) {
                    ((TableModel)object).removeTableModelListener(this);
                }
                if (object2 != null && object2 instanceof TableModel) {
                    ((TableModel)object2).addTableModelListener(this);
                }
            } else if (string.equals("selectionModel")) {
                Object object3 = propertyChangeEvent.getSource();
                if (object3 == JTable.this) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                } else if (object3 == JTable.this.getColumnModel()) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                }
            } else if (string.equals("columnModel")) {
                TableColumnModel tableColumnModel;
                if (object != null && object instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object;
                    tableColumnModel.removeColumnModelListener(this);
                    tableColumnModel.getSelectionModel().removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object2;
                    tableColumnModel.addColumnModelListener(this);
                    tableColumnModel.getSelectionModel().addListSelectionListener(this);
                }
            } else if (string.equals("tableCellEditor")) {
                if (object != null && object instanceof TableCellEditor) {
                    ((TableCellEditor)object).removeCellEditorListener(this);
                }
                if (object2 != null && object2 instanceof TableCellEditor) {
                    ((TableCellEditor)object2).addCellEditorListener(this);
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            if (tableModelEvent != null) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getColumn();
                if (n == -1) {
                    n = 0;
                    n2 = JTable.this.getColumnCount() - 1;
                }
                AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
                this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            }
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = 1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getFromIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            int n2 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange2 = new AccessibleJTableModelChange(n2, 0, 0, tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange2);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", false, true);
            int n = JTable.this.getSelectionModel().getLeadSelectionIndex();
            int n2 = JTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n != this.previousFocusedRow || n2 != this.previousFocusedCol) {
                Accessible accessible = this.getAccessibleAt(this.previousFocusedRow, this.previousFocusedCol);
                Accessible accessible2 = this.getAccessibleAt(n, n2);
                this.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
                this.previousFocusedRow = n;
                this.previousFocusedCol = n2;
            }
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n = JTable.this.columnAtPoint(point);
            int n2 = JTable.this.rowAtPoint(point);
            if (n != -1 && n2 != -1) {
                Component component;
                if (n2 == JTable.this.getEditingRow() && n == JTable.this.getEditingColumn() && (component = JTable.this.getEditorComponent()) instanceof Accessible) {
                    return (Accessible)((Object)component);
                }
                return new AccessibleJTableCell(JTable.this, n2, n, this.getAccessibleIndexAt(n2, n));
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return JTable.this.getColumnCount() * JTable.this.getRowCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            Component component;
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            if (n3 == JTable.this.getEditingRow() && n2 == JTable.this.getEditingColumn() && (component = JTable.this.getEditorComponent()) instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return new AccessibleJTableCell(JTable.this, n3, n2, this.getAccessibleIndexAt(n3, n2));
        }

        @Override
        public int getAccessibleSelectionCount() {
            int n = JTable.this.getSelectedRowCount();
            int n2 = JTable.this.getSelectedColumnCount();
            if (JTable.this.cellSelectionEnabled) {
                return n * n2;
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                return n * JTable.this.getColumnCount() + n2 * JTable.this.getRowCount() - n * n2;
            }
            if (JTable.this.getRowSelectionAllowed()) {
                return n * JTable.this.getColumnCount();
            }
            if (JTable.this.getColumnSelectionAllowed()) {
                return n2 * JTable.this.getRowCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n > this.getAccessibleSelectionCount()) {
                return null;
            }
            int n2 = JTable.this.getSelectedRowCount();
            int n3 = JTable.this.getSelectedColumnCount();
            int[] nArray = JTable.this.getSelectedRows();
            int[] nArray2 = JTable.this.getSelectedColumns();
            int n4 = JTable.this.getColumnCount();
            int n5 = JTable.this.getRowCount();
            if (JTable.this.cellSelectionEnabled) {
                int n6 = nArray[n / n3];
                int n7 = nArray2[n % n3];
                return this.getAccessibleChild(n6 * n4 + n7);
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                int n8 = n;
                int n9 = nArray[0] == 0 ? 0 : 1;
                int n10 = 0;
                int n11 = -1;
                while (n10 < nArray.length) {
                    switch (n9) {
                        case 0: {
                            if (n8 < n4) {
                                int n12 = n8 % n4;
                                int n13 = nArray[n10];
                                return this.getAccessibleChild(n13 * n4 + n12);
                            }
                            n8 -= n4;
                            if (n10 + 1 == nArray.length || nArray[n10] != nArray[n10 + 1] - 1) {
                                n9 = 1;
                                n11 = nArray[n10];
                            }
                            ++n10;
                            break;
                        }
                        case 1: {
                            if (n8 < n3 * (nArray[n10] - (n11 == -1 ? 0 : n11 + 1))) {
                                int n14 = nArray2[n8 % n3];
                                int n15 = (n10 > 0 ? nArray[n10 - 1] + 1 : 0) + n8 / n3;
                                return this.getAccessibleChild(n15 * n4 + n14);
                            }
                            n8 -= n3 * (nArray[n10] - (n11 == -1 ? 0 : n11 + 1));
                            n9 = 0;
                        }
                    }
                }
                if (n8 < n3 * (n5 - (n11 == -1 ? 0 : n11 + 1))) {
                    int n16 = nArray2[n8 % n3];
                    int n17 = nArray[n10 - 1] + n8 / n3 + 1;
                    return this.getAccessibleChild(n17 * n4 + n16);
                }
            } else {
                if (JTable.this.getRowSelectionAllowed()) {
                    int n18 = n % n4;
                    int n19 = nArray[n / n4];
                    return this.getAccessibleChild(n19 * n4 + n18);
                }
                if (JTable.this.getColumnSelectionAllowed()) {
                    int n20 = nArray2[n % n3];
                    int n21 = n / n3;
                    return this.getAccessibleChild(n21 * n4 + n20);
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            return JTable.this.isCellSelected(n3, n2);
        }

        @Override
        public void addAccessibleSelection(int n) {
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            JTable.this.changeSelection(n3, n2, true, false);
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (JTable.this.cellSelectionEnabled) {
                int n2 = this.getAccessibleColumnAtIndex(n);
                int n3 = this.getAccessibleRowAtIndex(n);
                JTable.this.removeRowSelectionInterval(n3, n3);
                JTable.this.removeColumnSelectionInterval(n2, n2);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            JTable.this.clearSelection();
        }

        @Override
        public void selectAllAccessibleSelection() {
            if (JTable.this.cellSelectionEnabled) {
                JTable.this.selectAll();
            }
        }

        @Override
        public int getAccessibleRow(int n) {
            return this.getAccessibleRowAtIndex(n);
        }

        @Override
        public int getAccessibleColumn(int n) {
            return this.getAccessibleColumnAtIndex(n);
        }

        @Override
        public int getAccessibleIndex(int n, int n2) {
            return this.getAccessibleIndexAt(n, n2);
        }

        @Override
        public AccessibleTable getAccessibleTable() {
            return this;
        }

        @Override
        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        @Override
        public void setAccessibleCaption(Accessible accessible) {
            Accessible accessible2 = this.caption;
            this.caption = accessible;
            this.firePropertyChange("accessibleTableCaptionChanged", accessible2, this.caption);
        }

        @Override
        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        @Override
        public void setAccessibleSummary(Accessible accessible) {
            Accessible accessible2 = this.summary;
            this.summary = accessible;
            this.firePropertyChange("accessibleTableSummaryChanged", accessible2, this.summary);
        }

        @Override
        public int getAccessibleRowCount() {
            return JTable.this.getRowCount();
        }

        @Override
        public int getAccessibleColumnCount() {
            return JTable.this.getColumnCount();
        }

        @Override
        public Accessible getAccessibleAt(int n, int n2) {
            return this.getAccessibleChild(n * this.getAccessibleColumnCount() + n2);
        }

        @Override
        public int getAccessibleRowExtentAt(int n, int n2) {
            return 1;
        }

        @Override
        public int getAccessibleColumnExtentAt(int n, int n2) {
            return 1;
        }

        @Override
        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        @Override
        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        @Override
        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader jTableHeader = JTable.this.getTableHeader();
            return jTableHeader == null ? null : new AccessibleTableHeader(jTableHeader);
        }

        @Override
        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        @Override
        public Accessible getAccessibleRowDescription(int n) {
            if (n < 0 || n >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (this.rowDescription == null) {
                return null;
            }
            return this.rowDescription[n];
        }

        @Override
        public void setAccessibleRowDescription(int n, Accessible accessible) {
            if (n < 0 || n >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (this.rowDescription == null) {
                int n2 = this.getAccessibleRowCount();
                this.rowDescription = new Accessible[n2];
            }
            this.rowDescription[n] = accessible;
        }

        @Override
        public Accessible getAccessibleColumnDescription(int n) {
            if (n < 0 || n >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (this.columnDescription == null) {
                return null;
            }
            return this.columnDescription[n];
        }

        @Override
        public void setAccessibleColumnDescription(int n, Accessible accessible) {
            if (n < 0 || n >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (this.columnDescription == null) {
                int n2 = this.getAccessibleColumnCount();
                this.columnDescription = new Accessible[n2];
            }
            this.columnDescription[n] = accessible;
        }

        @Override
        public boolean isAccessibleSelected(int n, int n2) {
            return JTable.this.isCellSelected(n, n2);
        }

        @Override
        public boolean isAccessibleRowSelected(int n) {
            return JTable.this.isRowSelected(n);
        }

        @Override
        public boolean isAccessibleColumnSelected(int n) {
            return JTable.this.isColumnSelected(n);
        }

        @Override
        public int[] getSelectedAccessibleRows() {
            return JTable.this.getSelectedRows();
        }

        @Override
        public int[] getSelectedAccessibleColumns() {
            return JTable.this.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int n) {
            int n2 = this.getAccessibleColumnCount();
            if (n2 == 0) {
                return -1;
            }
            return n / n2;
        }

        public int getAccessibleColumnAtIndex(int n) {
            int n2 = this.getAccessibleColumnCount();
            if (n2 == 0) {
                return -1;
            }
            return n % n2;
        }

        public int getAccessibleIndexAt(int n, int n2) {
            return n * this.getAccessibleColumnCount() + n2;
        }

        private class AccessibleJTableHeaderCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int row;
            private int column;
            private JTableHeader parent;
            private Component rendererComponent;

            public AccessibleJTableHeaderCell(int n, int n2, JTableHeader jTableHeader, Component component) {
                this.row = n;
                this.column = n2;
                this.parent = jTableHeader;
                this.rendererComponent = component;
                this.setAccessibleParent(jTableHeader);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                return this.rendererComponent.getAccessibleContext();
            }

            private Component getCurrentComponent() {
                return this.rendererComponent;
            }

            @Override
            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            @Override
            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = JTable.this.getVisibleRect()).intersects(rectangle = JTable.this.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (JTable.this.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            @Override
            public Accessible getAccessibleParent() {
                return this.parent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.column;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            @Override
            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    if (accessibleContext.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                    }
                    return this.isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            @Override
            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null && this.parent.isShowing()) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getHeaderRect(this.column)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point point) {
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getHeaderRect(this.column);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getHeaderRect(this.column)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable jTable, int n, int n2, int n3) {
                this.parent = jTable;
                this.row = n;
                this.column = n2;
                this.index = n3;
                this.setAccessibleParent(this.parent);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            protected AccessibleContext getCurrentAccessibleContext() {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class<?>)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, JTable.this.getValueAt(this.row, this.column), false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Component)serializable).getAccessibleContext();
                }
                return null;
            }

            protected Component getCurrentComponent() {
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class<?> clazz = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
                }
                return tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, this.row, this.column);
            }

            @Override
            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return string;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return (String)JTable.this.getClientProperty("AccessibleName");
            }

            @Override
            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = JTable.this.getVisibleRect()).intersects(rectangle = JTable.this.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.parent.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            @Override
            public Accessible getAccessibleParent() {
                return this.parent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.index;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleAction();
                }
                return null;
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            @Override
            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    if (accessibleContext.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                    }
                    return this.isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            @Override
            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null && this.parent.isShowing()) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point point) {
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private JTableHeader header;
            private TableColumnModel headerModel;

            AccessibleTableHeader(JTableHeader jTableHeader) {
                this.header = jTableHeader;
                this.headerModel = jTableHeader.getColumnModel();
            }

            @Override
            public Accessible getAccessibleCaption() {
                return null;
            }

            @Override
            public void setAccessibleCaption(Accessible accessible) {
            }

            @Override
            public Accessible getAccessibleSummary() {
                return null;
            }

            @Override
            public void setAccessibleSummary(Accessible accessible) {
            }

            @Override
            public int getAccessibleRowCount() {
                return 1;
            }

            @Override
            public int getAccessibleColumnCount() {
                return this.headerModel.getColumnCount();
            }

            @Override
            public Accessible getAccessibleAt(int n, int n2) {
                TableColumn tableColumn = this.headerModel.getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.header.getDefaultRenderer();
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
                return new AccessibleJTableHeaderCell(n, n2, JTable.this.getTableHeader(), component);
            }

            @Override
            public int getAccessibleRowExtentAt(int n, int n2) {
                return 1;
            }

            @Override
            public int getAccessibleColumnExtentAt(int n, int n2) {
                return 1;
            }

            @Override
            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            @Override
            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            @Override
            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            @Override
            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            @Override
            public Accessible getAccessibleRowDescription(int n) {
                return null;
            }

            @Override
            public void setAccessibleRowDescription(int n, Accessible accessible) {
            }

            @Override
            public Accessible getAccessibleColumnDescription(int n) {
                return null;
            }

            @Override
            public void setAccessibleColumnDescription(int n, Accessible accessible) {
            }

            @Override
            public boolean isAccessibleSelected(int n, int n2) {
                return false;
            }

            @Override
            public boolean isAccessibleRowSelected(int n) {
                return false;
            }

            @Override
            public boolean isAccessibleColumnSelected(int n) {
                return false;
            }

            @Override
            public int[] getSelectedAccessibleRows() {
                return new int[0];
            }

            @Override
            public int[] getSelectedAccessibleColumns() {
                return new int[0];
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(int n, int n2, int n3, int n4, int n5) {
                this.type = n;
                this.firstRow = n2;
                this.lastRow = n3;
                this.firstColumn = n4;
                this.lastColumn = n5;
            }

            @Override
            public int getType() {
                return this.type;
            }

            @Override
            public int getFirstRow() {
                return this.firstRow;
            }

            @Override
            public int getLastRow() {
                return this.lastRow;
            }

            @Override
            public int getFirstColumn() {
                return this.firstColumn;
            }

            @Override
            public int getLastColumn() {
                return this.lastColumn;
            }
        }
    }

    private class ThreadSafePrintable
    implements Printable {
        private Printable printDelegate;
        private int retVal;
        private Throwable retThrowable;

        public ThreadSafePrintable(Printable printable) {
            this.printDelegate = printable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int print(final Graphics graphics, final PageFormat pageFormat, final int n) throws PrinterException {
            Runnable runnable;
            Runnable runnable2 = runnable = new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        ThreadSafePrintable.this.retVal = ThreadSafePrintable.this.printDelegate.print(graphics, pageFormat, n);
                    }
                    catch (Throwable throwable) {
                        ThreadSafePrintable.this.retThrowable = throwable;
                    }
                    finally {
                        this.notifyAll();
                    }
                }
            };
            synchronized (runnable2) {
                this.retVal = -1;
                this.retThrowable = null;
                SwingUtilities.invokeLater(runnable);
                while (this.retVal == -1 && this.retThrowable == null) {
                    try {
                        runnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.retThrowable != null) {
                    if (this.retThrowable instanceof PrinterException) {
                        throw (PrinterException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof RuntimeException) {
                        throw (RuntimeException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof Error) {
                        throw (Error)this.retThrowable;
                    }
                    throw new AssertionError((Object)this.retThrowable);
                }
                return this.retVal;
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!JTable.this.isEditing() || JTable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JTable.this) || JTable.this.getCellEditor().stopCellEditing()) break;
                JTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    static class GenericEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;

        public GenericEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            try {
                if ("".equals(string)) {
                    if (this.constructor.getDeclaringClass() == String.class) {
                        this.value = string;
                    }
                    return super.stopCellEditing();
                }
                SwingUtilities2.checkAccess(this.constructor.getModifiers());
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                ReflectUtil.checkPackageAccess(clazz);
                SwingUtilities2.checkAccess(clazz.getModifiers());
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleBooleanRenderer();
            }
            return this.accessibleContext;
        }

        class AccessibleBooleanRenderer
        extends JCheckBox.AccessibleJCheckBox {
            AccessibleBooleanRenderer() {
                super(BooleanRenderer.this);
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return null;
            }
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer.UIResource {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer.UIResource {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private final class ModelChange {
        int startModelIndex;
        int endModelIndex;
        int type;
        int modelRowCount;
        TableModelEvent event;
        int length;
        boolean allRowsChanged;

        ModelChange(TableModelEvent tableModelEvent) {
            this.startModelIndex = Math.max(0, tableModelEvent.getFirstRow());
            this.endModelIndex = tableModelEvent.getLastRow();
            this.modelRowCount = JTable.this.getModel().getRowCount();
            if (this.endModelIndex < 0) {
                this.endModelIndex = Math.max(0, this.modelRowCount - 1);
            }
            this.length = this.endModelIndex - this.startModelIndex + 1;
            this.type = tableModelEvent.getType();
            this.event = tableModelEvent;
            this.allRowsChanged = tableModelEvent.getLastRow() == Integer.MAX_VALUE;
        }
    }

    private final class SortManager {
        RowSorter<? extends TableModel> sorter;
        private ListSelectionModel modelSelection;
        private int modelLeadIndex;
        private boolean syncingSelection;
        private int[] lastModelSelection;
        private SizeSequence modelRowSizes;

        SortManager(RowSorter<? extends TableModel> rowSorter) {
            this.sorter = rowSorter;
            rowSorter.addRowSorterListener(JTable.this);
        }

        public void dispose() {
            if (this.sorter != null) {
                this.sorter.removeRowSorterListener(JTable.this);
            }
        }

        public void setViewRowHeight(int n, int n2) {
            if (this.modelRowSizes == null) {
                this.modelRowSizes = new SizeSequence(JTable.this.getModel().getRowCount(), JTable.this.getRowHeight());
            }
            this.modelRowSizes.setSize(JTable.this.convertRowIndexToModel(n), n2);
        }

        public void allChanged() {
            this.modelLeadIndex = -1;
            this.modelSelection = null;
            this.modelRowSizes = null;
        }

        public void viewSelectionChanged(ListSelectionEvent listSelectionEvent) {
            if (!this.syncingSelection && this.modelSelection != null) {
                this.modelSelection = null;
            }
        }

        public void prepareForChange(RowSorterEvent rowSorterEvent, ModelChange modelChange) {
            if (JTable.this.getUpdateSelectionOnSort()) {
                this.cacheSelection(rowSorterEvent, modelChange);
            }
        }

        private void cacheSelection(RowSorterEvent rowSorterEvent, ModelChange modelChange) {
            if (rowSorterEvent != null) {
                if (this.modelSelection == null && this.sorter.getViewRowCount() != JTable.this.getModel().getRowCount()) {
                    int n;
                    this.modelSelection = new DefaultListSelectionModel();
                    ListSelectionModel listSelectionModel = JTable.this.getSelectionModel();
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    int n3 = listSelectionModel.getMaxSelectionIndex();
                    for (int i = n2; i <= n3; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i) || (n = JTable.this.convertRowIndexToModel(rowSorterEvent, i)) == -1) continue;
                        this.modelSelection.addSelectionInterval(n, n);
                    }
                    n = JTable.this.convertRowIndexToModel(rowSorterEvent, listSelectionModel.getLeadSelectionIndex());
                    SwingUtilities2.setLeadAnchorWithoutSelection(this.modelSelection, n, n);
                } else if (this.modelSelection == null) {
                    this.cacheModelSelection(rowSorterEvent);
                }
            } else if (modelChange.allRowsChanged) {
                this.modelSelection = null;
            } else if (this.modelSelection != null) {
                switch (modelChange.type) {
                    case -1: {
                        this.modelSelection.removeIndexInterval(modelChange.startModelIndex, modelChange.endModelIndex);
                        break;
                    }
                    case 1: {
                        this.modelSelection.insertIndexInterval(modelChange.startModelIndex, modelChange.length, true);
                        break;
                    }
                }
            } else {
                this.cacheModelSelection(null);
            }
        }

        private void cacheModelSelection(RowSorterEvent rowSorterEvent) {
            this.lastModelSelection = JTable.this.convertSelectionToModel(rowSorterEvent);
            this.modelLeadIndex = JTable.this.convertRowIndexToModel(rowSorterEvent, JTable.this.selectionModel.getLeadSelectionIndex());
        }

        public void processChange(RowSorterEvent rowSorterEvent, ModelChange modelChange, boolean bl) {
            if (modelChange != null) {
                if (modelChange.allRowsChanged) {
                    this.modelRowSizes = null;
                    JTable.this.rowModel = null;
                } else if (this.modelRowSizes != null) {
                    if (modelChange.type == 1) {
                        this.modelRowSizes.insertEntries(modelChange.startModelIndex, modelChange.endModelIndex - modelChange.startModelIndex + 1, JTable.this.getRowHeight());
                    } else if (modelChange.type == -1) {
                        this.modelRowSizes.removeEntries(modelChange.startModelIndex, modelChange.endModelIndex - modelChange.startModelIndex + 1);
                    }
                }
            }
            if (bl) {
                this.setViewRowHeightsFromModel();
                this.restoreSelection(modelChange);
            }
        }

        private void setViewRowHeightsFromModel() {
            if (this.modelRowSizes != null) {
                JTable.this.rowModel.setSizes(JTable.this.getRowCount(), JTable.this.getRowHeight());
                for (int i = JTable.this.getRowCount() - 1; i >= 0; --i) {
                    int n = JTable.this.convertRowIndexToModel(i);
                    JTable.this.rowModel.setSize(i, this.modelRowSizes.getSize(n));
                }
            }
        }

        private void restoreSelection(ModelChange modelChange) {
            this.syncingSelection = true;
            if (this.lastModelSelection != null) {
                JTable.this.restoreSortingSelection(this.lastModelSelection, this.modelLeadIndex, modelChange);
                this.lastModelSelection = null;
            } else if (this.modelSelection != null) {
                int n;
                ListSelectionModel listSelectionModel = JTable.this.getSelectionModel();
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.clearSelection();
                int n2 = this.modelSelection.getMinSelectionIndex();
                int n3 = this.modelSelection.getMaxSelectionIndex();
                for (n = n2; n <= n3; ++n) {
                    int n4;
                    if (!this.modelSelection.isSelectedIndex(n) || (n4 = JTable.this.convertRowIndexToView(n)) == -1) continue;
                    listSelectionModel.addSelectionInterval(n4, n4);
                }
                n = this.modelSelection.getLeadSelectionIndex();
                if (n != -1 && !this.modelSelection.isSelectionEmpty()) {
                    n = JTable.this.convertRowIndexToView(n);
                }
                SwingUtilities2.setLeadAnchorWithoutSelection(listSelectionModel, n, n);
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.syncingSelection = false;
        }
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final int row;
        private final int col;
        private final boolean isInsertRow;
        private final boolean isInsertCol;

        private DropLocation(Point point, int n, int n2, boolean bl, boolean bl2) {
            super(point);
            this.row = n;
            this.col = n2;
            this.isInsertRow = bl;
            this.isInsertCol = bl2;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.col;
        }

        public boolean isInsertRow() {
            return this.isInsertRow;
        }

        public boolean isInsertColumn() {
            return this.isInsertCol;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + ",row=" + this.row + ",column=" + this.col + ",insertRow=" + this.isInsertRow + ",insertColumn=" + this.isInsertCol + "]";
        }
    }

    public static enum PrintMode {
        NORMAL,
        FIT_WIDTH;

    }
}

