/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.peer.CanvasPeer;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class XCanvasPeer
extends XComponentPeer
implements CanvasPeer {
    private boolean eraseBackgroundDisabled;

    XCanvasPeer() {
    }

    XCanvasPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XCanvasPeer(Component component) {
        super(component);
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        if (SunToolkit.getSunAwtNoerasebackground()) {
            this.disableBackgroundErase();
        }
    }

    @Override
    public GraphicsConfiguration getAppropriateGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        GraphicsConfiguration[] graphicsConfigurationArray;
        if (this.graphicsConfig == null || graphicsConfiguration == null) {
            return graphicsConfiguration;
        }
        X11GraphicsDevice x11GraphicsDevice = this.getSameScreenDevice(graphicsConfiguration);
        int n = this.graphicsConfig.getVisual();
        for (GraphicsConfiguration graphicsConfiguration2 : graphicsConfigurationArray = x11GraphicsDevice.getConfigurations()) {
            X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)graphicsConfiguration2;
            if (n != x11GraphicsConfig.getVisual()) continue;
            this.graphicsConfig = x11GraphicsConfig;
        }
        return this.graphicsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X11GraphicsDevice getSameScreenDevice(GraphicsConfiguration graphicsConfiguration) {
        XToolkit.awtLock();
        try {
            int n = ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen();
            X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
            return x11GraphicsDevice;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    protected boolean shouldFocusOnClick() {
        return true;
    }

    public void disableBackgroundErase() {
        this.eraseBackgroundDisabled = true;
    }

    @Override
    protected boolean doEraseBackground() {
        return !this.eraseBackgroundDisabled;
    }
}

