/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.event.EventHelper;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.jfr.events.X509ValidationEvent;
import oracle.jrockit.jfr.VMJFR;

@InstrumentationTarget(value="sun.security.provider.certpath.PKIXCertPathValidator")
final class PKIXCertPathValidatorInstrumentor {
    private static AtomicLong validationCounter;

    private PKIXCertPathValidatorInstrumentor() {
    }

    @InstrumentationMethod
    private static void recordEvent(TrustAnchor trustAnchor, List<X509Certificate> list) {
        if (!VMJFR.x509ValidationToken.isEnabled()) {
            PKIXCertPathValidatorInstrumentor.recordEvent(trustAnchor, list);
            return;
        }
        X509ValidationEvent x509ValidationEvent = new X509ValidationEvent(VMJFR.x509ValidationToken);
        if (x509ValidationEvent.shouldWrite() || EventHelper.isLoggingSecurity()) {
            int n;
            int[] nArray = new int[list.size()];
            for (n = 0; n < list.size(); ++n) {
                nArray[n] = list.get(n).hashCode();
            }
            n = trustAnchor.getTrustedCert().hashCode();
            if (x509ValidationEvent.shouldWrite()) {
                int n2;
                x509ValidationEvent.certificateId = n;
                x509ValidationEvent.certificatePosition = n2 = 1;
                x509ValidationEvent.validationCounter = validationCounter.incrementAndGet();
                x509ValidationEvent.commit();
                for (int n3 : nArray) {
                    x509ValidationEvent.certificateId = n3;
                    x509ValidationEvent.certificatePosition = ++n2;
                    x509ValidationEvent.commit();
                }
            }
            if (EventHelper.isLoggingSecurity()) {
                EventHelper.logX509ValidationEvent((int)n, (int[])nArray);
            }
        }
    }
}

