/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JFRStackFrame
extends VMObject {
    public static final byte FRAME_INTERPRETER = 0;
    public static final byte FRAME_JIT = 1;
    public static final byte FRAME_INLINE = 2;
    public static final int NUM_FRAME_TYPES = 3;
    private static Field methodIDField;
    private static CIntegerField lineField;
    private static CIntegerField bciField;
    private static Field typeField;
    public static final ArrayList methodIDs;

    public JFRStackFrame(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrStackFrame");
        methodIDField = type.getField("_methodid");
        lineField = type.getCIntegerField("_line");
        bciField = type.getCIntegerField("_bci");
        typeField = type.getField("_type");
    }

    public long methodID() {
        return methodIDField.getJLong(this.addr);
    }

    public int line() {
        return (int)lineField.getValue(this.addr);
    }

    public int bci() {
        return (int)bciField.getValue(this.addr);
    }

    public int type() {
        return typeField.getJByte(this.addr);
    }

    public void write(JFRStreamWriter writer) {
        writer.write(this.methodID());
        methodIDs.add(this.methodID());
        writer.write(this.line());
        writer.write(this.bci());
        writer.write((byte)this.type());
    }

    static {
        methodIDs = new ArrayList();
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRStackFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

