/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPublicKey;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

final class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    private static final long serialVersionUID = 7565477590005668886L;
    private static final BigInteger PKCS8_VERSION = BigInteger.ZERO;
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private final BigInteger p;
    private final BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    private static DHComponents decode(byte[] byArray) throws IOException {
        DerValue derValue = null;
        try {
            int n;
            derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("Key not a SEQUENCE");
            }
            BigInteger bigInteger = derValue.data.getBigInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + bigInteger);
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new IOException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (objectIdentifier == null) {
                throw new IOException("Null OID");
            }
            if (derInputStream.available() == 0) {
                throw new IOException("Parameters missing");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.tag == 5) {
                throw new IOException("Null parameters");
            }
            if (derValue3.tag != 48) {
                throw new IOException("Parameters not a SEQUENCE");
            }
            derValue3.data.reset();
            BigInteger bigInteger2 = derValue3.data.getBigInteger();
            BigInteger bigInteger3 = derValue3.data.getBigInteger();
            int n2 = n = derValue3.data.available() != 0 ? derValue3.data.getInteger() : 0;
            if (derValue3.data.available() != 0) {
                throw new IOException("Extra parameter data");
            }
            byte[] byArray2 = derValue.data.getOctetString();
            DerInputStream derInputStream2 = new DerInputStream(byArray2);
            BigInteger bigInteger4 = derInputStream2.getBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Excess trailing data");
            }
            return new DHComponents(bigInteger4, bigInteger2, bigInteger3, n, byArray2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing key encoding", numberFormatException);
        }
    }

    private static byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, int n, byte[] byArray) {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(PKCS8_VERSION);
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(DHPublicKey.DH_OID);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(bigInteger);
            derOutputStream3.putInteger(bigInteger2);
            if (n != 0) {
                derOutputStream3.putInteger(n);
            }
            DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
            derOutputStream2.putDerValue(derValue);
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream.putOctetString(byArray);
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.write((byte)48, derOutputStream);
            byte[] byArray2 = derOutputStream4.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n;
        byte[] byArray = bigInteger.toByteArray();
        DerValue derValue = new DerValue(2, byArray);
        try {
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new ProviderException("Cannot produce ASN.1 encoding", iOException);
        }
        this.encodedKey = DHPrivateKey.encode(bigInteger2, bigInteger3, n, this.key);
    }

    DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        DHComponents dHComponents;
        this.encodedKey = (byte[])byArray.clone();
        try {
            dHComponents = DHPrivateKey.decode(this.encodedKey);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid encoding" + iOException.getMessage());
        }
        this.x = dHComponents.x;
        this.p = dHComponents.p;
        this.g = dHComponents.g;
        this.l = dHComponents.l;
        this.key = dHComponents.key;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.p, this.g);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPrivateKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)object;
        DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
        return this.x.compareTo(dHPrivateKey.getX()) == 0 && this.p.compareTo(dHParameterSpec.getP()) == 0 && this.g.compareTo(dHParameterSpec.getG()) == 0;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.encodedKey);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DHComponents dHComponents;
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException("key not deserializable");
        }
        if (this.encodedKey == null || this.encodedKey.length == 0) {
            throw new InvalidObjectException("encoded key not deserializable");
        }
        byte[] byArray = (byte[])this.encodedKey.clone();
        try {
            dHComponents = DHPrivateKey.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidObjectException("Invalid encoding" + iOException.getMessage());
        }
        if (!(Arrays.equals(dHComponents.key, this.key) && dHComponents.x.equals(this.x) && dHComponents.p.equals(this.p) && dHComponents.g.equals(this.g) && dHComponents.l == this.l)) {
            throw new InvalidObjectException("encoded key not matching internal fields");
        }
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.encodedKey, (byte)0);
        this.key = dHComponents.key;
        this.encodedKey = byArray;
    }

    private static class DHComponents {
        final BigInteger x;
        final BigInteger p;
        final BigInteger g;
        final int l;
        final byte[] key;

        DHComponents(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, byte[] byArray) {
            this.x = bigInteger;
            this.p = bigInteger2;
            this.g = bigInteger3;
            this.l = n;
            this.key = byArray;
        }
    }
}

